/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ParquetRecordReaderWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;

public class MapredParquetInputFormat
extends FileInputFormat<Void, VoidPointable> {
    private final ParquetInputFormat<ArrayBackedValueStorage> realInputFormat = new ParquetInputFormat();
    private IExternalFilterValueEmbedder valueEmbedder;

    public RecordReader<Void, VoidPointable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new ParquetRecordReaderWrapper(split, job, reporter, this.valueEmbedder);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (MapredParquetInputFormat.isTaskSideMetaData(job)) {
            return super.getSplits(job, numSplits);
        }
        List<Footer> footers = this.getFooters(job);
        List splits = this.realInputFormat.getSplits((Configuration)job, footers);
        if (splits == null) {
            return null;
        }
        InputSplit[] resultSplits = new InputSplit[splits.size()];
        int i = 0;
        for (ParquetInputSplit split : splits) {
            resultSplits[i++] = new ParquetInputSplitWrapper(split);
        }
        return resultSplits;
    }

    public List<Footer> getFooters(JobConf job) throws IOException {
        return this.realInputFormat.getFooters((Configuration)job, Arrays.asList(super.listStatus(job)));
    }

    public void setValueEmbedder(IExternalFilterValueEmbedder valueEmbedder) {
        this.valueEmbedder = valueEmbedder;
    }

    public static boolean isTaskSideMetaData(JobConf job) {
        return job.getBoolean("parquet.task.side.metadata", true);
    }

    static class ParquetInputSplitWrapper
    implements InputSplit {
        ParquetInputSplit realSplit;

        public ParquetInputSplitWrapper() {
        }

        public ParquetInputSplitWrapper(ParquetInputSplit realSplit) {
            this.realSplit = realSplit;
        }

        public long getLength() throws IOException {
            return this.realSplit.getLength();
        }

        public String[] getLocations() throws IOException {
            return this.realSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            this.realSplit = new ParquetInputSplit();
            this.realSplit.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.realSplit.write(out);
        }

        public String toString() {
            return this.realSplit.toString();
        }
    }
}

