/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;

public class HDFSTextLineReader {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private int bufferSize = 32768;
    private FSDataInputStream reader;
    private byte[] buffer;
    private int bufferLength = 0;
    private int bufferPosn = 0;
    private long currentFilePos = 0L;
    private static final byte CR = 13;
    private static final byte LF = 10;
    public static final String KEY_BUFFER_SIZE = "io.file.buffer.size";

    public HDFSTextLineReader(FSDataInputStream in) throws IOException {
        this(in, 32768);
    }

    public HDFSTextLineReader(FSDataInputStream in, int bufferSize) throws IOException {
        this.reader = in;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
        this.currentFilePos = in.getPos();
    }

    public HDFSTextLineReader() throws IOException {
        this.bufferSize = 32768;
        this.buffer = new byte[this.bufferSize];
    }

    public HDFSTextLineReader(FSDataInputStream in, Configuration conf) throws IOException {
        this(in, conf.getInt(KEY_BUFFER_SIZE, 32768));
    }

    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        str.clear();
        int txtLength = 0;
        int newlineLength = 0;
        boolean prevCharCR = false;
        long bytesConsumed = 0L;
        do {
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                if (prevCharCR) {
                    ++bytesConsumed;
                }
                this.bufferLength = this.reader.read(this.buffer);
                if (this.bufferLength <= 0) break;
            }
            while (this.bufferPosn < this.bufferLength) {
                if (this.buffer[this.bufferPosn] == 10) {
                    newlineLength = prevCharCR ? 2 : 1;
                    ++this.bufferPosn;
                    break;
                }
                if (prevCharCR) {
                    newlineLength = 1;
                    break;
                }
                prevCharCR = this.buffer[this.bufferPosn] == 13;
                ++this.bufferPosn;
            }
            int readLength = this.bufferPosn - startPosn;
            if (prevCharCR && newlineLength == 0) {
                --readLength;
            }
            bytesConsumed += (long)readLength;
            int appendLength = readLength - newlineLength;
            if (appendLength > maxLineLength - txtLength) {
                appendLength = maxLineLength - txtLength;
            }
            if (appendLength <= 0) continue;
            str.append(this.buffer, startPosn, appendLength);
            txtLength += appendLength;
        } while (newlineLength == 0 && bytesConsumed < (long)maxBytesToConsume);
        if (bytesConsumed > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes before newline: " + bytesConsumed);
        }
        this.currentFilePos = this.reader.getPos() - (long)this.bufferLength + (long)this.bufferPosn;
        return (int)bytesConsumed;
    }

    public int readLine(Text str, int maxLineLength) throws IOException {
        return this.readLine(str, maxLineLength, Integer.MAX_VALUE);
    }

    public int readLine(Text str) throws IOException {
        return this.readLine(str, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void seek(long desired) throws IOException {
        if (this.reader.getPos() <= desired || this.currentFilePos > desired) {
            this.reader.seek(desired);
            this.bufferLength = 0;
            this.bufferPosn = 0;
            this.currentFilePos = desired;
        } else if (this.currentFilePos < desired) {
            int difference = (int)(desired - this.currentFilePos);
            this.bufferPosn += difference;
            this.currentFilePos = desired;
        }
    }

    public FSDataInputStream getReader() {
        return this.reader;
    }

    public void resetReader(FSDataInputStream reader) throws IOException {
        this.reader = reader;
        this.bufferLength = 0;
        this.bufferPosn = 0;
        this.currentFilePos = reader.getPos();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

