/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws.parquet;

import com.amazonaws.SdkBaseException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.HDFSDataSourceFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.aws.s3.S3Utils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.util.ExceptionUtils;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3ParquetReaderFactory
extends HDFSDataSourceFactory {
    private static final long serialVersionUID = -6140824803254158253L;
    private static final List<String> recordReaderNames = Collections.singletonList("S3");

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException, HyracksDataException {
        String path;
        if (configuration.containsKey("path")) {
            path = configuration.get("path");
        } else {
            AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
            IExternalFilterEvaluator evaluator = filterEvaluatorFactory.create(serviceCtx, warningCollector);
            ExternalDataPrefix externalDataPrefix = new ExternalDataPrefix(configuration);
            configuration.put("prefix-root", externalDataPrefix.getRoot());
            String container = configuration.get("container");
            List<S3Object> filesOnly = S3Utils.listS3Objects(configuration, includeExcludeMatcher, warningCollector, externalDataPrefix, evaluator);
            path = AwsS3ParquetReaderFactory.buildPathURIs(container, filesOnly);
        }
        AwsS3ParquetReaderFactory.putS3ConfToHadoopConf(configuration, path);
        try {
            JobConf conf = this.prepareHDFSConf(serviceCtx, configuration, filterEvaluatorFactory);
            int numberOfPartitions = this.getPartitionConstraint().getLocations().length;
            S3Utils.configureAwsS3HdfsJobConf(conf, configuration, numberOfPartitions);
            this.configureHdfsConf(conf, configuration);
        }
        catch (SdkBaseException | SdkException ex) {
            throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        catch (AlgebricksException ex) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
            if (root instanceof SdkException || root instanceof SdkBaseException) {
                throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, root, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)root)});
            }
            throw ex;
        }
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public Set<String> getReaderSupportedFormats() {
        return Collections.singleton("parquet");
    }

    private static void putS3ConfToHadoopConf(Map<String, String> configuration, String path) {
        configuration.put("path", path);
        configuration.put("input-format", "parquet-input-format");
        configuration.put("parser", "noop");
    }

    private static String buildPathURIs(String container, List<S3Object> filesOnly) {
        StringBuilder builder = new StringBuilder();
        if (!filesOnly.isEmpty()) {
            AwsS3ParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(0));
            for (int i = 1; i < filesOnly.size(); ++i) {
                builder.append(',');
                AwsS3ParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(i));
            }
        }
        return builder.toString();
    }

    private static void appendFileURI(StringBuilder builder, String container, S3Object file) {
        builder.append("s3a");
        builder.append("://");
        builder.append(container);
        builder.append('/');
        builder.append(file.key());
    }
}

