/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class AListTypeComputer
extends AbstractResultTypeComputer {
    public static final AListTypeComputer INSTANCE_REMOVE = new AListTypeComputer(2, false, false, true);
    public static final AListTypeComputer INSTANCE_PUT = new AListTypeComputer(2, false, true, true);
    public static final AListTypeComputer INSTANCE_PREPEND = new AListTypeComputer(2, true, true, false);
    public static final AListTypeComputer INSTANCE_APPEND = new AListTypeComputer(2, false, true, false);
    public static final AListTypeComputer INSTANCE_INSERT = new AListTypeComputer(3, false, true, false);
    public static final AListTypeComputer INSTANCE_REPLACE = new AListTypeComputer(3, false, true, false);
    public static final AListTypeComputer INSTANCE_SLICE = new AListTypeComputer(-1, false, false, true);
    public static final AListTypeComputer INSTANCE_MOVE = new AListTypeComputer(3, false, false, true);
    public static final AListTypeComputer INSTANCE_SWAP = new AListTypeComputer(3, false, false, true);
    private final int minNumArgs;
    private final boolean listIsLast;
    private final boolean makeOpen;
    private final boolean nullInNullOut;

    private AListTypeComputer(int minNumArgs, boolean listIsLast, boolean makeOpen, boolean nullInNullOut) {
        this.minNumArgs = minNumArgs;
        this.listIsLast = listIsLast;
        this.makeOpen = makeOpen;
        this.nullInNullOut = nullInNullOut;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType listType;
        if (this.minNumArgs > -1 && strippedInputTypes.length < this.minNumArgs) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(ErrorCode.COMPILATION_INVALID_NUM_OF_ARGS, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        int listIndex = 0;
        if (this.listIsLast) {
            listIndex = strippedInputTypes.length - 1;
        }
        if ((listType = strippedInputTypes[listIndex]).getTypeTag().isListType()) {
            if (this.makeOpen) {
                listType = DefaultOpenFieldType.getDefaultOpenFieldType(listType.getTypeTag());
            }
            return AUnionType.createUnknownableType(listType);
        }
        return BuiltinType.ANY;
    }

    @Override
    protected boolean propagateNullAndMissing() {
        return this.nullInNullOut;
    }
}

