/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;

class HashPartitioner {
    private final int[] hashFields;
    private final IBinaryHashFunction[] hashFunctions;
    private final Int2IntMap storagePartition2Compute;

    public HashPartitioner(int[] hashFields, IBinaryHashFunction[] hashFunctions, Int2IntMap storagePartition2Compute) {
        this.hashFields = hashFields;
        this.hashFunctions = hashFunctions;
        this.storagePartition2Compute = storagePartition2Compute;
    }

    protected int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
        if (nParts == 1) {
            return 0;
        }
        int h = 0;
        int startOffset = accessor.getTupleStartOffset(tIndex);
        int slotLength = accessor.getFieldSlotsLength();
        for (int j = 0; j < this.hashFields.length; ++j) {
            int fIdx = this.hashFields[j];
            IBinaryHashFunction hashFn = this.hashFunctions[j];
            int fStart = accessor.getFieldStartOffset(tIndex, fIdx);
            int fEnd = accessor.getFieldEndOffset(tIndex, fIdx);
            int fh = hashFn.hash(accessor.getBuffer().array(), startOffset + slotLength + fStart, fEnd - fStart);
            h = h * 31 + fh;
        }
        if (h < 0) {
            h = -(h + 1);
        }
        if (this.storagePartition2Compute == null) {
            return h % nParts;
        }
        int storagePartition = h % this.storagePartition2Compute.size();
        int computePartition = this.storagePartition2Compute.getOrDefault(storagePartition, Integer.MIN_VALUE);
        if (computePartition < 0 || computePartition >= nParts) {
            throw new IllegalStateException("couldn't resolve storage partition " + storagePartition + " to compute partition " + computePartition + ". num_storage=" + this.storagePartition2Compute.size() + ", nParts=" + nParts + ",storagePartition2Compute=" + this.storagePartition2Compute);
        }
        return computePartition;
    }
}

