/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.transaction;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.runtime.message.ResourceIdRequestMessage;
import org.apache.asterix.runtime.message.ResourceIdRequestResponseMessage;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalResourceIdFactory
implements IResourceIdFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long INVALID_ID = -1L;
    private static final int MAX_NUMBER_OF_ATTEMPTS = 3;
    private static final long WAIT_FOR_REQUEST_TIME_THRESHOLD_NS = TimeUnit.SECONDS.toNanos(2L);
    private static final long WAIT_FOR_BLOCK_ID_TIME_MS = TimeUnit.SECONDS.toMillis(2L);
    private final INCServiceContext serviceCtx;
    private final LongPriorityQueue resourceIds;
    private final String nodeId;
    private final int initialBlockSize;
    private final int maxBlockSize;
    private final AtomicInteger numberOfFailedRequests;
    private final AtomicLong requestTime;
    private int currentBlockSize;
    private volatile boolean reset = false;

    public GlobalResourceIdFactory(INCServiceContext serviceCtx, int initialBlockSize) {
        this.serviceCtx = serviceCtx;
        this.nodeId = serviceCtx.getNodeId();
        this.initialBlockSize = initialBlockSize;
        this.maxBlockSize = initialBlockSize * 2;
        this.currentBlockSize = initialBlockSize;
        this.resourceIds = new LongArrayFIFOQueue(initialBlockSize);
        this.numberOfFailedRequests = new AtomicInteger();
        this.requestTime = new AtomicLong();
    }

    public synchronized void addNewIds(ResourceIdRequestResponseMessage resourceIdResponse) throws InterruptedException {
        LOGGER.debug("rec'd block of ids: {}", (Object)resourceIdResponse);
        if (resourceIdResponse.getBlockSize() != this.currentBlockSize) {
            LOGGER.debug("dropping outdated block size of resource ids: {}, current block size: {}", (Object)resourceIdResponse, (Object)this.currentBlockSize);
            return;
        }
        this.populateIDs(resourceIdResponse);
    }

    public long createId() throws HyracksDataException {
        this.resetIDsIfNeeded();
        long id = this.getID();
        while (id == -1L) {
            this.waitForID();
            id = this.getID();
        }
        return id;
    }

    public synchronized void reset() {
        this.reset = true;
        ++this.currentBlockSize;
        if (this.currentBlockSize > this.maxBlockSize) {
            this.currentBlockSize = this.initialBlockSize;
        }
        LOGGER.debug("current resource ids block size: {}", (Object)this.currentBlockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIDs(ResourceIdRequestResponseMessage response) {
        LongPriorityQueue longPriorityQueue = this.resourceIds;
        synchronized (longPriorityQueue) {
            long startingId = response.getResourceId();
            for (int i = 0; i < response.getBlockSize(); ++i) {
                this.resourceIds.enqueue(startingId + (long)i);
            }
            this.resourceIds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIDsIfNeeded() throws HyracksDataException {
        LongPriorityQueue longPriorityQueue = this.resourceIds;
        synchronized (longPriorityQueue) {
            if (this.reset) {
                this.resourceIds.clear();
                this.reset = false;
                this.requestNewBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getID() throws HyracksDataException {
        int size;
        long id = -1L;
        long time = System.nanoTime();
        LongPriorityQueue longPriorityQueue = this.resourceIds;
        synchronized (longPriorityQueue) {
            size = this.resourceIds.size();
            if (size > 0) {
                id = this.resourceIds.dequeueLong();
            }
        }
        if (size == 1 || size == 0 && this.shouldRequestNewBlock(time)) {
            this.requestNewBlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForID() throws HyracksDataException {
        long time = System.nanoTime();
        try {
            LongPriorityQueue longPriorityQueue = this.resourceIds;
            synchronized (longPriorityQueue) {
                while (this.resourceIds.isEmpty() && !this.shouldRequestNewBlock(time)) {
                    this.resourceIds.wait(WAIT_FOR_BLOCK_ID_TIME_MS);
                    time = System.nanoTime();
                }
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean shouldRequestNewBlock(long time) {
        int failures = this.numberOfFailedRequests.get();
        long timeDiff = time - this.requestTime.get();
        if (failures > 0 || timeDiff >= WAIT_FOR_REQUEST_TIME_THRESHOLD_NS) {
            long thresholdSec = TimeUnit.NANOSECONDS.toSeconds(WAIT_FOR_REQUEST_TIME_THRESHOLD_NS);
            long timeDiffSec = TimeUnit.NANOSECONDS.toSeconds(timeDiff);
            LOGGER.warn("Preemptive requests are either failed or lost (failures:{}, number-of-failures-threshold: {}), (time-since-last-request: {}s, time-threshold: {}s)", (Object)failures, (Object)3, (Object)timeDiffSec, (Object)thresholdSec);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void requestNewBlock() throws HyracksDataException {
        int attempts = this.numberOfFailedRequests.get();
        if (attempts >= 3) {
            LongPriorityQueue longPriorityQueue = this.resourceIds;
            synchronized (longPriorityQueue) {
                this.resourceIds.notifyAll();
            }
            throw new RuntimeDataException(ErrorCode.ILLEGAL_STATE, new Serializable[]{"New block request was attempted (" + attempts + " times) - exceeding the maximum number of allowed retries. See the logs for more information."});
        }
        this.requestTime.set(System.nanoTime());
        this.serviceCtx.getControllerService().getExecutor().submit(() -> {
            try {
                ResourceIdRequestMessage msg = new ResourceIdRequestMessage(this.nodeId, this.currentBlockSize);
                ((INCMessageBroker)this.serviceCtx.getMessageBroker()).sendMessageToPrimaryCC((ICcAddressedMessage)msg);
                this.numberOfFailedRequests.set(0);
            }
            catch (Exception e) {
                LOGGER.warn("failed to request a new block", (Throwable)e);
                this.numberOfFailedRequests.incrementAndGet();
                LongPriorityQueue longPriorityQueue = this.resourceIds;
                synchronized (longPriorityQueue) {
                    this.resourceIds.notify();
                }
            }
        });
    }
}

