/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.messaging.AtomicJobPreparedMessage;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallback;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.projection.ITupleProjector;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMPrimaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    public static final AInt8 UPSERT_NEW = new AInt8(0);
    public static final AInt8 UPSERT_EXISTING = new AInt8(1);
    public static final AInt8 DELETE_EXISTING = new AInt8(2);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    protected final PermutingFrameTupleReference key;
    private MultiComparator keySearchCmp;
    private ArrayTupleBuilder missingTupleBuilder;
    private final IMissingWriter missingWriter;
    protected ArrayTupleBuilder tb;
    private DataOutput dos;
    protected RangePredicate searchPred;
    protected final IIndexCursor[] cursors;
    protected ITupleReference prevTuple;
    protected final int numOfPrimaryKeys;
    protected boolean isFiltered = false;
    private final ArrayTupleReference prevTupleWithFilter = new ArrayTupleReference();
    private ArrayTupleBuilder prevRecWithPKWithFilterValue;
    private Integer filterSourceIndicator = null;
    private ARecordType filterItemType;
    private int presetFieldIndex = -1;
    private ARecordPointable recPointable;
    private DataOutput prevDos;
    private final boolean hasMeta;
    private final int filterFieldIndex;
    private final int metaFieldIndex;
    protected final ISearchOperationCallback[] searchCallbacks;
    protected final IFrameOperationCallback[] frameOpCallbacks;
    private final IFrameOperationCallbackFactory frameOpCallbackFactory;
    private final ISearchOperationCallbackFactory searchCallbackFactory;
    private final IFrameTupleProcessor[] processors;
    private final ITracer tracer;
    private final long traceCategory;
    private final ITupleProjector tupleProjector;
    private long lastRecordInTimeStamp = 0L;
    private final Int2ObjectMap<IntSet> partition2TuplesMap = new Int2ObjectOpenHashMap();
    private final boolean hasSecondaries;

    public LSMPrimaryUpsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IModificationOperationCallbackFactory modCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numOfPrimaryKeys, Integer filterSourceIndicator, ARecordType filterItemType, int filterFieldIndex, IFrameOperationCallbackFactory frameOpCallbackFactory, IMissingWriterFactory missingWriterFactory, boolean hasSecondaries, ITupleProjectorFactory projectorFactory, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, null, tuplePartitionerFactory, partitionsMap);
        this.hasSecondaries = hasSecondaries;
        this.frameOpCallbacks = new IFrameOperationCallback[this.partitions.length];
        this.searchCallbacks = new ISearchOperationCallback[this.partitions.length];
        this.cursors = new IIndexCursor[this.partitions.length];
        this.processors = new IFrameTupleProcessor[this.partitions.length];
        this.key = new PermutingFrameTupleReference();
        this.searchCallbackFactory = searchCallbackFactory;
        this.numOfPrimaryKeys = numOfPrimaryKeys;
        this.frameOpCallbackFactory = frameOpCallbackFactory;
        this.missingWriter = missingWriterFactory.createMissingWriter();
        int[] searchKeyPermutations = new int[numOfPrimaryKeys];
        System.arraycopy(fieldPermutation, 0, searchKeyPermutations, 0, searchKeyPermutations.length);
        this.key.setFieldPermutation(searchKeyPermutations);
        this.hasMeta = fieldPermutation.length > numOfPrimaryKeys + 1 && (filterFieldIndex < 0 || filterFieldIndex >= 0 && fieldPermutation.length > numOfPrimaryKeys + 2);
        this.metaFieldIndex = numOfPrimaryKeys + 1;
        this.filterFieldIndex = numOfPrimaryKeys + (this.hasMeta ? 2 : 1);
        if (filterFieldIndex >= 0) {
            this.isFiltered = true;
            this.filterItemType = filterItemType;
            this.presetFieldIndex = filterFieldIndex;
            this.filterSourceIndicator = filterSourceIndicator;
            this.recPointable = ARecordPointable.FACTORY.createPointable();
            this.prevRecWithPKWithFilterValue = new ArrayTupleBuilder(fieldPermutation.length + (this.hasMeta ? 1 : 0));
            this.prevDos = this.prevRecWithPKWithFilterValue.getDataOutput();
        }
        this.tracer = ctx.getJobletContext().getServiceContext().getTracer();
        this.traceCategory = this.tracer.getRegistry().get("Latency");
        this.tupleProjector = projectorFactory.createTupleProjector(ctx);
    }

    protected void beforeModification(ITupleReference tuple) {
    }

    protected void createTupleProcessors(final boolean hasSecondaries) {
        for (int i = 0; i < this.partitions.length; ++i) {
            final ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessors[i];
            final IIndexCursor cursor = this.cursors[i];
            final ISearchOperationCallback searchCallback = this.searchCallbacks[i];
            final IModificationOperationCallback modCallback = this.modCallbacks[i];
            final IFrameOperationCallback frameOpCallback = this.frameOpCallbacks[i];
            this.processors[i] = new IFrameTupleProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(FrameTupleAccessor accessor, ITupleReference tuple, int index) throws HyracksDataException {
                    try {
                        LSMPrimaryUpsertOperatorNodePushable.this.tb.reset();
                        IModificationOperationCallback abstractModCallback = modCallback;
                        boolean recordWasInserted = false;
                        boolean recordWasDeleted = false;
                        boolean isDelete = LSMPrimaryUpsertOperatorNodePushable.isDeleteOperation(tuple, LSMPrimaryUpsertOperatorNodePushable.this.numOfPrimaryKeys);
                        LSMPrimaryUpsertOperatorNodePushable.this.resetSearchPredicate(index);
                        if (LSMPrimaryUpsertOperatorNodePushable.this.isFiltered || isDelete || hasSecondaries) {
                            lsmAccessor.search(cursor, (ISearchPredicate)LSMPrimaryUpsertOperatorNodePushable.this.searchPred);
                            try {
                                if (cursor.hasNext()) {
                                    cursor.next();
                                    LSMPrimaryUpsertOperatorNodePushable.this.prevTuple = LSMPrimaryUpsertOperatorNodePushable.this.tupleProjector.project(cursor.getTuple(), LSMPrimaryUpsertOperatorNodePushable.this.dos, LSMPrimaryUpsertOperatorNodePushable.this.tb);
                                    LSMPrimaryUpsertOperatorNodePushable.this.appendOperationIndicator(!isDelete, true);
                                    LSMPrimaryUpsertOperatorNodePushable.this.appendFilterToPrevTuple();
                                    LSMPrimaryUpsertOperatorNodePushable.this.appendPrevRecord();
                                    LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousMeta();
                                    LSMPrimaryUpsertOperatorNodePushable.this.appendFilterToOutput();
                                }
                                LSMPrimaryUpsertOperatorNodePushable.this.appendOperationIndicator(!isDelete, false);
                                LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousTupleAsMissing();
                            }
                            finally {
                                cursor.close();
                            }
                        } else {
                            searchCallback.before((ITupleReference)LSMPrimaryUpsertOperatorNodePushable.this.key);
                            LSMPrimaryUpsertOperatorNodePushable.this.appendOperationIndicator(true, false);
                            LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousTupleAsMissing();
                        }
                        LSMPrimaryUpsertOperatorNodePushable.this.beforeModification(tuple);
                        if (isDelete && LSMPrimaryUpsertOperatorNodePushable.this.prevTuple != null) {
                            if (abstractModCallback instanceof AbstractIndexModificationOperationCallback) {
                                ((AbstractIndexModificationOperationCallback)abstractModCallback).setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                            }
                            lsmAccessor.forceDelete(tuple);
                            recordWasDeleted = true;
                        } else if (!isDelete) {
                            if (abstractModCallback instanceof AbstractIndexModificationOperationCallback) {
                                ((AbstractIndexModificationOperationCallback)abstractModCallback).setOp(AbstractIndexModificationOperationCallback.Operation.UPSERT);
                            }
                            lsmAccessor.forceUpsert(tuple);
                            recordWasInserted = true;
                        }
                        if (LSMPrimaryUpsertOperatorNodePushable.this.isFiltered && LSMPrimaryUpsertOperatorNodePushable.this.prevTuple != null) {
                            lsmAccessor.updateFilter(LSMPrimaryUpsertOperatorNodePushable.this.prevTuple);
                        }
                        LSMPrimaryUpsertOperatorNodePushable.this.writeOutput(index, recordWasInserted, recordWasDeleted, searchCallback);
                    }
                    catch (Exception e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }

                public void start() throws HyracksDataException {
                    ((LSMTreeIndexAccessor)lsmAccessor).getCtx().setOperation(IndexOperation.UPSERT);
                }

                public void finish() throws HyracksDataException {
                    ((LSMTreeIndexAccessor)lsmAccessor).getCtx().setOperation(IndexOperation.UPSERT);
                }

                public void fail(Throwable th) {
                    frameOpCallback.fail(th);
                }
            };
        }
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.writer.open();
        this.writerOpen = true;
        try {
            this.missingTupleBuilder = new ArrayTupleBuilder(1);
            DataOutput out = this.missingTupleBuilder.getDataOutput();
            try {
                this.missingWriter.writeMissing(out);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.missingTupleBuilder.addFieldEndOffset();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            INcApplicationContext appCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            for (int i = 0; i < this.indexHelpers.length; ++i) {
                IIndexDataflowHelper indexHelper = this.indexHelpers[i];
                this.indexHelpersOpen[i] = true;
                indexHelper.open();
                this.indexes[i] = indexHelper.getIndexInstance();
                if (((ILSMIndex)this.indexes[i]).isAtomic()) {
                    ((PrimaryIndexOperationTracker)((ILSMIndex)this.indexes[i]).getOperationTracker()).clear();
                }
                if (this.ctx.getSharedObject() != null && i == 0) {
                    PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)((AbstractLSMIndex)this.indexes[0]));
                    TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
                }
                this.modCallbacks[i] = this.modOpCallbackFactory.createModificationOperationCallback(indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
                this.searchCallbacks[i] = this.searchCallbackFactory.createSearchOperationCallback(indexHelper.getResource().getId(), this.ctx, (IOperatorNodePushable)this);
                IndexAccessParameters iap = new IndexAccessParameters(this.modCallbacks[i], this.searchCallbacks[i]);
                iap.getParameters().put("TUPLE_PROJECTOR", this.tupleProjector);
                this.indexAccessors[i] = this.indexes[i].createAccessor((IIndexAccessParameters)iap);
                this.setAtomicOpContextIfAtomic(this.indexes[i], this.indexAccessors[i]);
                this.cursors[i] = ((LSMTreeIndexAccessor)this.indexAccessors[i]).createSearchCursor(false);
                LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)this.indexes[i]), (ILogManager)appCtx.getTransactionSubsystem().getLogManager());
            }
            this.searchPred = this.createSearchPredicate(this.indexes[0]);
            this.frameTuple = new FrameTupleReference();
            this.createFrameOpCallbacks();
            this.createTupleProcessors(this.hasSecondaries);
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void createFrameOpCallbacks() throws HyracksDataException {
        for (int i = 0; i < this.partitions.length; ++i) {
            final LSMTreeIndexAccessor lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessors[i];
            this.frameOpCallbacks[i] = new IFrameOperationCallback(){
                final IFrameOperationCallback callback;
                {
                    this.callback = LSMPrimaryUpsertOperatorNodePushable.this.frameOpCallbackFactory.createFrameOperationCallback(LSMPrimaryUpsertOperatorNodePushable.this.ctx, (ILSMIndexAccessor)lsmAccessor);
                }

                public void frameCompleted() throws HyracksDataException {
                    if (LSMPrimaryUpsertOperatorNodePushable.this.appender.getTupleCount() > 0) {
                        LSMPrimaryUpsertOperatorNodePushable.this.appender.write(LSMPrimaryUpsertOperatorNodePushable.this.writer, true);
                    }
                    this.callback.frameCompleted();
                }

                public void close() throws IOException {
                    this.callback.close();
                }

                public void fail(Throwable th) {
                    this.callback.fail(th);
                }

                public void open() throws HyracksDataException {
                    this.callback.open();
                }
            };
            this.frameOpCallbacks[i].open();
        }
    }

    protected void resetSearchPredicate(int tupleIndex) {
        this.key.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        this.searchPred.reset((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp);
    }

    protected void writeOutput(int tupleIndex, boolean recordWasInserted, boolean recordWasDeleted, ISearchOperationCallback searchCallback) throws IOException {
        if (recordWasInserted || recordWasDeleted) {
            this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
            for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
        } else {
            try {
                if (searchCallback instanceof LockThenSearchOperationCallback) {
                    ((LockThenSearchOperationCallback)searchCallback).release();
                }
            }
            catch (ACIDException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    protected static boolean isDeleteOperation(ITupleReference t1, int field) {
        return TypeTagUtil.isType((ITupleReference)t1, (int)field, (byte)ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
    }

    private void writeMissingField() throws IOException {
        this.dos.write(this.missingTupleBuilder.getByteArray());
        this.tb.addFieldEndOffset();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        int pIdx;
        this.accessor.reset(buffer);
        this.partition2TuplesMap.clear();
        int itemCount = this.accessor.getTupleCount();
        for (int i = 0; i < itemCount; ++i) {
            int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, i);
            pIdx = this.storagePartitionId2Index.get(storagePartition);
            IntSet tupleIndexes = (IntSet)this.partition2TuplesMap.computeIfAbsent(pIdx, k -> new IntOpenHashSet());
            tupleIndexes.add(i);
        }
        IntIterator intIterator = this.storagePartitionId2Index.values().iterator();
        while (intIterator.hasNext()) {
            int partition = (Integer)intIterator.next();
            this.partition2TuplesMap.computeIfAbsent(partition, k -> new IntOpenHashSet());
        }
        for (Int2ObjectMap.Entry p2tuplesMapEntry : this.partition2TuplesMap.int2ObjectEntrySet()) {
            pIdx = p2tuplesMapEntry.getIntKey();
            LSMTreeIndexAccessor lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessors[pIdx];
            IFrameOperationCallback frameOpCallback = this.frameOpCallbacks[pIdx];
            IFrameTupleProcessor processor = this.processors[pIdx];
            lsmAccessor.batchOperate(this.accessor, (FrameTupleReference)this.tuple, processor, frameOpCallback, (Set)p2tuplesMapEntry.getValue());
        }
        if (itemCount > 0) {
            this.lastRecordInTimeStamp = System.currentTimeMillis();
        }
    }

    protected void appendFilterToOutput() throws IOException {
        if (this.isFiltered) {
            this.dos.write(this.prevTuple.getFieldData(this.filterFieldIndex), this.prevTuple.getFieldStart(this.filterFieldIndex), this.prevTuple.getFieldLength(this.filterFieldIndex));
            this.tb.addFieldEndOffset();
        }
    }

    protected void appendOperationIndicator(boolean isUpsert, boolean prevTupleExists) throws IOException {
        if (isUpsert) {
            if (prevTupleExists) {
                this.recordDesc.getFields()[0].serialize((Object)UPSERT_EXISTING, this.dos);
            } else {
                this.recordDesc.getFields()[0].serialize((Object)UPSERT_NEW, this.dos);
            }
        } else {
            this.recordDesc.getFields()[0].serialize((Object)DELETE_EXISTING, this.dos);
        }
        this.tb.addFieldEndOffset();
    }

    protected void appendPrevRecord() throws IOException {
        this.dos.write(this.prevTuple.getFieldData(this.numOfPrimaryKeys), this.prevTuple.getFieldStart(this.numOfPrimaryKeys), this.prevTuple.getFieldLength(this.numOfPrimaryKeys));
        this.tb.addFieldEndOffset();
    }

    protected void appendPreviousMeta() throws IOException {
        if (this.hasMeta) {
            this.dos.write(this.prevTuple.getFieldData(this.metaFieldIndex), this.prevTuple.getFieldStart(this.metaFieldIndex), this.prevTuple.getFieldLength(this.metaFieldIndex));
            this.tb.addFieldEndOffset();
        }
    }

    protected void appendPreviousTupleAsMissing() throws IOException {
        this.prevTuple = null;
        this.writeMissingField();
        if (this.hasMeta) {
            this.writeMissingField();
        }
        if (this.isFiltered) {
            this.writeMissingField();
        }
    }

    public void flushPartialFrame() throws HyracksDataException {
        if (this.appender.getTupleCount() > 0) {
            this.appender.write(this.writer, true);
        }
    }

    protected void appendFilterToPrevTuple() throws IOException {
        if (this.isFiltered) {
            this.prevRecWithPKWithFilterValue.reset();
            for (int i = 0; i < this.prevTuple.getFieldCount(); ++i) {
                this.prevDos.write(this.prevTuple.getFieldData(i), this.prevTuple.getFieldStart(i), this.prevTuple.getFieldLength(i));
                this.prevRecWithPKWithFilterValue.addFieldEndOffset();
            }
            if (this.filterSourceIndicator == 0) {
                this.recPointable.set(this.prevTuple.getFieldData(this.numOfPrimaryKeys), this.prevTuple.getFieldStart(this.numOfPrimaryKeys), this.prevTuple.getFieldLength(this.numOfPrimaryKeys));
            } else {
                this.recPointable.set(this.prevTuple.getFieldData(this.metaFieldIndex), this.prevTuple.getFieldStart(this.metaFieldIndex), this.prevTuple.getFieldLength(this.metaFieldIndex));
            }
            byte tag = this.recPointable.getClosedFieldType(this.filterItemType, this.presetFieldIndex).getTypeTag().serialize();
            this.prevDos.write(tag);
            this.prevDos.write(this.recPointable.getByteArray(), this.recPointable.getClosedFieldOffset(this.filterItemType, this.presetFieldIndex), this.recPointable.getClosedFieldSize(this.filterItemType, this.presetFieldIndex));
            this.prevRecWithPKWithFilterValue.addFieldEndOffset();
            this.prevTupleWithFilter.reset(this.prevRecWithPKWithFilterValue.getFieldEndOffsets(), this.prevRecWithPKWithFilterValue.getByteArray());
            this.prevTuple = this.prevTupleWithFilter;
        }
    }

    private RangePredicate createSearchPredicate(IIndex index) {
        this.keySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])((ITreeIndex)index).getComparatorFactories(), (ITupleReference)this.key);
        return new RangePredicate((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp, null, null);
    }

    public void close() throws HyracksDataException {
        this.traceLastRecordIn();
        Throwable failure = CleanupUtils.close((AutoCloseable[])this.frameOpCallbacks, null);
        failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])this.cursors);
        failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        failure = this.closeIndexHelpers(failure);
        if (failure == null && !this.failed) {
            this.commitAtomicUpsert();
        } else {
            this.abortAtomicUpsert();
        }
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    private void traceLastRecordIn() {
        try {
            if (this.tracer.isEnabled(this.traceCategory) && this.lastRecordInTimeStamp > 0L && this.indexHelpers[0] != null && this.indexHelpers[0].getIndexInstance() != null) {
                this.tracer.instant("UpsertClose", this.traceCategory, ITracer.Scope.t, () -> "{\"last-record-in\":\"" + DATE_FORMAT.get().format(new Date(this.lastRecordInTimeStamp)) + "\", \"index\":" + this.indexHelpers[0].getIndexInstance().toString() + "}");
            }
        }
        catch (Throwable traceFailure) {
            try {
                LOGGER.warn("Tracing last record in failed", traceFailure);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
    }

    private void commitAtomicUpsert() throws HyracksDataException {
        HashMap<String, ILSMComponentId> componentIdMap = new HashMap<String, ILSMComponentId>();
        boolean atomic = false;
        for (IIndex index : this.indexes) {
            if (index == null || !((ILSMIndex)index).isAtomic()) continue;
            PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
            opTracker.finishAllFlush();
            for (Map.Entry entry : opTracker.getLastFlushOperation().entrySet()) {
                componentIdMap.put((String)entry.getKey(), ((FlushOperation)entry.getValue()).getFlushingComponent().getId());
            }
            atomic = true;
        }
        if (atomic) {
            AtomicJobPreparedMessage message = new AtomicJobPreparedMessage(this.ctx.getJobletContext().getJobId(), this.ctx.getJobletContext().getServiceContext().getNodeId(), componentIdMap);
            try {
                ((NodeControllerService)this.ctx.getJobletContext().getServiceContext().getControllerService()).sendRealTimeApplicationMessageToCC(this.ctx.getJobletContext().getJobId().getCcId(), JavaSerializationUtils.serialize((Serializable)message), null);
            }
            catch (Exception e) {
                throw new ACIDException((Throwable)e);
            }
        }
    }

    private void abortAtomicUpsert() throws HyracksDataException {
        for (IIndex index : this.indexes) {
            if (index == null || !((ILSMIndex)index).isAtomic()) continue;
            PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
            opTracker.abort();
        }
    }
}

