/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class FieldAccessByNameEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory recordEvalFactory;
    private final IScalarEvaluatorFactory fldNameEvalFactory;
    private final SourceLocation sourceLoc;
    private final FunctionIdentifier funID;

    public FieldAccessByNameEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fldNameEvalFactory, SourceLocation sourceLoc, FunctionIdentifier funID) {
        this.recordEvalFactory = recordEvalFactory;
        this.fldNameEvalFactory = fldNameEvalFactory;
        this.sourceLoc = sourceLoc;
        this.funID = funID;
    }

    public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final IBinaryHashFunction fieldNameHashFunction = BinaryHashFunctionFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryHashFunction();
            private final IBinaryComparator fieldNameComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
            private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput out = this.resultStorage.getDataOutput();
            private final IPointable inputArg0 = new VoidPointable();
            private final IPointable inputArg1 = new VoidPointable();
            private final IScalarEvaluator eval0;
            private final IScalarEvaluator eval1;
            {
                this.eval0 = FieldAccessByNameEvalFactory.this.recordEvalFactory.createScalarEvaluator(ctx);
                this.eval1 = FieldAccessByNameEvalFactory.this.fldNameEvalFactory.createScalarEvaluator(ctx);
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    int serFldNameOffset;
                    this.resultStorage.reset();
                    this.eval0.evaluate(tuple, this.inputArg0);
                    this.eval1.evaluate(tuple, this.inputArg1);
                    if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1)) {
                        return;
                    }
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int serRecordOffset = this.inputArg0.getStartOffset();
                    int serRecordLen = this.inputArg0.getLength();
                    if (serRecord[serRecordOffset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)FieldAccessByNameEvalFactory.this.sourceLoc, (FunctionIdentifier)FieldAccessByNameEvalFactory.this.funID, (byte)serRecord[serRecordOffset], (int)0, (ATypeTag)ATypeTag.OBJECT);
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    byte[] serFldName = this.inputArg1.getByteArray();
                    if (serFldName[serFldNameOffset = this.inputArg1.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                        ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)FieldAccessByNameEvalFactory.this.sourceLoc, (FunctionIdentifier)FieldAccessByNameEvalFactory.this.funID, (byte)serFldName[serFldNameOffset], (int)1, (ATypeTag)ATypeTag.STRING);
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    int fieldValueOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)serRecordOffset, (int)serRecordLen, (byte[])serFldName, (int)serFldNameOffset, (IBinaryHashFunction)this.fieldNameHashFunction, (IBinaryComparator)this.fieldNameComparator);
                    if (fieldValueOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    ATypeTag fieldValueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[fieldValueOffset]);
                    int fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)fieldValueOffset, (ATypeTag)fieldValueTypeTag, (boolean)true) + 1;
                    result.set(serRecord, fieldValueOffset, fieldValueLength);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

