/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.encoder.ParquetDeltaBinaryPackingValuesWriterForLong;
import org.apache.asterix.column.bytes.encoder.ParquetPlainFixedLengthValuesWriter;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.LongColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;

final class LongColumnValuesWriter
extends AbstractColumnValuesWriter {
    private final AbstractParquetValuesWriter longWriter;
    private final ATypeTag typeTag;

    public LongColumnValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef, int columnIndex, int level, boolean collection, boolean filtered, ATypeTag typeTag) {
        super(columnIndex, level, collection, filtered);
        this.longWriter = filtered ? new ParquetDeltaBinaryPackingValuesWriterForLong(multiPageOpRef) : new ParquetPlainFixedLengthValuesWriter(multiPageOpRef);
        this.typeTag = filtered ? ColumnValuesUtil.getNormalizedTypeTag(typeTag) : typeTag;
    }

    @Override
    protected void addValue(ATypeTag tag, IValueReference value) {
        long normalizedInt = this.getValue(tag, value.getByteArray(), value.getStartOffset());
        this.longWriter.writeLong(normalizedInt);
        this.filterWriter.addLong(normalizedInt);
    }

    private long getValue(ATypeTag typeTag, byte[] byteArray, int offset) {
        switch (typeTag) {
            case TINYINT: {
                return byteArray[offset];
            }
            case SMALLINT: {
                return ShortPointable.getShort((byte[])byteArray, (int)offset);
            }
            case INTEGER: {
                return IntegerPointable.getInteger((byte[])byteArray, (int)offset);
            }
            case BIGINT: {
                return LongPointable.getLong((byte[])byteArray, (int)offset);
            }
        }
        throw new IllegalAccessError(typeTag + " is not of type integer");
    }

    @Override
    protected void resetValues() throws HyracksDataException {
        this.longWriter.reset();
    }

    @Override
    protected BytesInput getBytes() throws IOException {
        return this.longWriter.getBytes();
    }

    @Override
    protected int getValuesEstimatedSize() {
        return this.longWriter.getEstimatedSize();
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return this.longWriter.calculateEstimatedSize(length);
    }

    @Override
    protected int getValuesAllocatedSize() {
        return this.longWriter.getAllocatedSize();
    }

    @Override
    protected void addValue(IColumnValuesReader reader) throws IOException {
        long value = reader.getLong();
        this.longWriter.writeLong(value);
        this.filterWriter.addLong(value);
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return new LongColumnFilterWriter();
    }

    @Override
    protected void closeValues() {
        this.longWriter.close();
    }

    @Override
    protected ATypeTag getTypeTag() {
        return this.typeTag;
    }
}

