/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.encoder.ParquetRunLengthBitPackingHybridEncoder;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.IColumnValuesWriterFactory;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.NoOpColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;

public abstract class AbstractColumnValuesWriter
implements IColumnValuesWriter {
    private static final int COUNT_DEF_SIZE_VALUE_SIZE = 12;
    protected final AbstractColumnFilterWriter filterWriter;
    protected final ParquetRunLengthBitPackingHybridEncoder definitionLevels;
    protected final int level;
    private final int columnIndex;
    private final boolean collection;
    private final int nullBitMask;
    private int count;
    private boolean writeValues;

    AbstractColumnValuesWriter(int columnIndex, int level, boolean collection, boolean filtered) {
        this.columnIndex = columnIndex;
        this.level = level;
        this.collection = collection;
        this.nullBitMask = ColumnValuesUtil.getNullMask(level);
        int width = ColumnValuesUtil.getBitWidth(level);
        this.definitionLevels = new ParquetRunLengthBitPackingHybridEncoder(width);
        this.filterWriter = filtered ? this.createFilter() : NoOpColumnFilterWriter.INSTANCE;
    }

    @Override
    public final int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public final int getEstimatedSize() {
        return this.definitionLevels.getEstimatedSize() + this.getValuesEstimatedSize() + 12;
    }

    @Override
    public int getEstimatedSize(int length) {
        return 1 + this.calculateEstimatedSize(length);
    }

    @Override
    public final int getAllocatedSpace() {
        return this.definitionLevels.getAllocatedSize() + this.getValuesAllocatedSize();
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    @Override
    public final void writeValue(ATypeTag tag, IValueReference value) throws HyracksDataException {
        this.addLevel(this.level);
        try {
            this.addValue(tag, value);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public final void writeLevel(int level) throws HyracksDataException {
        this.addLevel(level);
    }

    @Override
    public void writeLevels(int level, int count) throws HyracksDataException {
        this.writeValues = this.writeValues || this.level == level;
        this.count += count;
        try {
            for (int i = 0; i < count; ++i) {
                this.definitionLevels.writeInt(level);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public RunLengthIntArray getDefinitionLevelsIntArray() {
        return null;
    }

    @Override
    public final void writeNull(int level) throws HyracksDataException {
        this.addLevel(level | this.nullBitMask);
    }

    @Override
    public void writeValue(IColumnValuesReader reader) throws HyracksDataException {
        try {
            this.addValue(reader);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public void writeAntiMatter(ATypeTag tag, IValueReference value) throws HyracksDataException {
        this.addLevel(0);
        try {
            this.addValue(tag, value);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public final void close() {
        this.definitionLevels.close();
        this.closeValues();
    }

    @Override
    public final long getNormalizedMinValue() {
        if (!this.writeValues) {
            return Long.MAX_VALUE;
        }
        return this.filterWriter.getMinNormalizedValue();
    }

    @Override
    public final long getNormalizedMaxValue() {
        if (!this.writeValues) {
            return Long.MIN_VALUE;
        }
        return this.filterWriter.getMaxNormalizedValue();
    }

    @Override
    public final void flush(OutputStream out) throws HyracksDataException {
        try {
            BytesUtils.writeZigZagVarInt((int)this.level, (OutputStream)out);
            BytesInput defLevelBytes = this.definitionLevels.toBytes();
            BytesUtils.writeZigZagVarInt((int)((int)defLevelBytes.size()), (OutputStream)out);
            BytesUtils.writeZigZagVarInt((int)this.count, (OutputStream)out);
            defLevelBytes.writeAllTo(out);
            if (this.writeValues || this.collection) {
                BytesInput values = this.getBytes();
                int valueSize = (int)values.size();
                BytesUtils.writeZigZagVarInt((int)valueSize, (OutputStream)out);
                values.writeAllTo(out);
            } else {
                BytesUtils.writeZigZagVarInt((int)0, (OutputStream)out);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.reset();
    }

    @Override
    public final void reset() throws HyracksDataException {
        this.definitionLevels.reset();
        this.writeValues = false;
        this.count = 0;
        this.filterWriter.reset();
        this.resetValues();
    }

    @Override
    public final void serialize(DataOutput output) throws IOException {
        output.write(this.getTypeTag().serialize());
        output.writeInt(this.columnIndex);
        output.writeInt(this.level);
        output.writeBoolean(this.collection);
        output.writeBoolean(this.filterWriter != NoOpColumnFilterWriter.INSTANCE);
    }

    public static IColumnValuesWriter deserialize(DataInput input, IColumnValuesWriterFactory writerFactory) throws IOException {
        ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[input.readByte()];
        int columnIndex = input.readInt();
        int level = input.readInt();
        boolean collection = input.readBoolean();
        boolean filtered = input.readBoolean();
        return writerFactory.createValueWriter(typeTag, columnIndex, level, collection, filtered);
    }

    protected void addLevel(int level) throws HyracksDataException {
        try {
            this.writeValues = this.writeValues || this.level == level;
            this.definitionLevels.writeInt(level);
            ++this.count;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract ATypeTag getTypeTag();

    protected abstract void addValue(ATypeTag var1, IValueReference var2) throws IOException;

    protected abstract void addValue(IColumnValuesReader var1) throws IOException;

    protected abstract BytesInput getBytes() throws IOException;

    protected abstract int getValuesEstimatedSize();

    protected abstract int calculateEstimatedSize(int var1);

    protected abstract int getValuesAllocatedSize();

    protected abstract AbstractColumnFilterWriter createFilter();

    protected abstract void resetValues() throws HyracksDataException;

    protected abstract void closeValues();
}

