/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.tuple;

import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class AssembledTupleReference
implements ITupleReference {
    private final int fieldCount;
    private final int[] offsets;
    private final int[] lengths;
    private byte[] data;

    public AssembledTupleReference(int fieldCount) {
        this.fieldCount = fieldCount;
        this.offsets = new int[fieldCount];
        this.lengths = new int[fieldCount];
    }

    public ITupleReference reset(ArrayTupleBuilder tb) {
        this.data = tb.getByteArray();
        int[] fieldEndOffsets = tb.getFieldEndOffsets();
        int j = fieldEndOffsets.length - 1;
        for (int i = this.fieldCount - 1; i >= 0; --i) {
            this.offsets[i] = j == 0 ? 0 : fieldEndOffsets[j - 1];
            this.lengths[i] = fieldEndOffsets[j] - this.offsets[i];
            --j;
        }
        return this;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.data;
    }

    public int getFieldStart(int fIdx) {
        return this.offsets[fIdx];
    }

    public int getFieldLength(int fIdx) {
        return this.lengths[fIdx];
    }
}

