/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.IColumnFilterEvaluator;
import org.apache.asterix.column.filter.TrueColumnFilterEvaluator;
import org.apache.asterix.column.filter.iterable.ColumnFilterEvaluatorContext;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluator;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.visitor.SchemaClipperVisitor;
import org.apache.asterix.column.operation.query.ColumnAssembler;
import org.apache.asterix.column.operation.query.QueryColumnMetadata;
import org.apache.asterix.column.operation.query.QueryColumnTupleReader;
import org.apache.asterix.column.util.SchemaStringBuilderVisitor;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReader;

public final class QueryColumnWithMetaMetadata
extends QueryColumnMetadata {
    private final ColumnAssembler metaAssembler;

    private QueryColumnWithMetaMetadata(ARecordType datasetType, ARecordType metaType, PrimitiveColumnValuesReader[] primaryKeyReaders, IValueReference serializedMetadata, FieldNamesDictionary fieldNamesDictionary, ObjectSchemaNode root, ObjectSchemaNode metaRoot, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory, IColumnFilterEvaluator filterEvaluator, List<IColumnRangeFilterValueAccessor> filterValueAccessors, IColumnIterableFilterEvaluator columnFilterEvaluator, List<IColumnValuesReader> filterColumnReaders) throws HyracksDataException {
        super(datasetType, metaType, primaryKeyReaders, serializedMetadata, fieldNamesDictionary, root, readerFactory, valueGetterFactory, filterEvaluator, filterValueAccessors, columnFilterEvaluator, filterColumnReaders);
        this.metaAssembler = new ColumnAssembler(metaRoot, metaType, this, readerFactory, valueGetterFactory);
    }

    @Override
    public boolean containsMeta() {
        return true;
    }

    @Override
    public int getColumnIndex(int ordinal) {
        int metaColumnCount = this.metaAssembler.getNumberOfColumns();
        if (ordinal >= metaColumnCount) {
            return this.assembler.getColumnIndex(ordinal - metaColumnCount);
        }
        return this.metaAssembler.getColumnIndex(ordinal);
    }

    @Override
    public int getNumberOfProjectedColumns() {
        return this.metaAssembler.getNumberOfColumns() + this.assembler.getNumberOfColumns();
    }

    @Override
    public int getNumberOfColumns() {
        return this.getNumberOfProjectedColumns();
    }

    @Override
    public AbstractColumnTupleReader createTupleReader() {
        return new QueryColumnTupleReader(this);
    }

    public ColumnAssembler getMetaAssembler() {
        return this.metaAssembler;
    }

    public static QueryColumnWithMetaMetadata create(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, IValueReference serializedMetadata, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory, ARecordType requestedType, Map<String, FunctionCallInformation> functionCallInfo, ARecordType metaRequestedType, IColumnRangeFilterEvaluatorFactory normalizedEvaluatorFactory, IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory, IWarningCollector warningCollector, IHyracksTaskContext context) throws IOException {
        byte[] bytes = serializedMetadata.getByteArray();
        int offset = serializedMetadata.getStartOffset();
        int length = serializedMetadata.getLength();
        int fieldNamesStart = offset + IntegerPointable.getInteger((byte[])bytes, (int)(offset + 4));
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, fieldNamesStart, length));
        FieldNamesDictionary fieldNamesDictionary = FieldNamesDictionary.deserialize(input);
        ObjectSchemaNode root = (ObjectSchemaNode)AbstractSchemaNode.deserialize(input, null);
        ObjectSchemaNode metaRoot = (ObjectSchemaNode)AbstractSchemaNode.deserialize(input, null);
        SchemaClipperVisitor clipperVisitor = new SchemaClipperVisitor(fieldNamesDictionary, functionCallInfo, warningCollector);
        ObjectSchemaNode clippedRoot = QueryColumnWithMetaMetadata.clip(requestedType, root, clipperVisitor);
        ObjectSchemaNode metaClippedRoot = QueryColumnWithMetaMetadata.clip(metaRequestedType, metaRoot, clipperVisitor);
        IColumnFilterEvaluator normalizedFilterEvaluator = TrueColumnFilterEvaluator.INSTANCE;
        IColumnIterableFilterEvaluator columnFilterEvaluator = TrueColumnFilterEvaluator.INSTANCE;
        List<IColumnValuesReader> filterColumnReaders = Collections.emptyList();
        List<IColumnRangeFilterValueAccessor> filterValueAccessors = Collections.emptyList();
        String jobId = null;
        if (context != null) {
            FilterAccessorProvider accessorProvider = new FilterAccessorProvider(root, clipperVisitor, readerFactory, valueGetterFactory);
            normalizedFilterEvaluator = normalizedEvaluatorFactory.create(accessorProvider);
            filterValueAccessors = accessorProvider.getFilterAccessors();
            ColumnFilterEvaluatorContext evaluatorContext = new ColumnFilterEvaluatorContext(context, accessorProvider);
            clipperVisitor.setIgnoreFlatType(true);
            accessorProvider.reset();
            columnFilterEvaluator = columnFilterEvaluatorFactory.create(evaluatorContext);
            filterColumnReaders = accessorProvider.getFilterColumnReaders();
            jobId = context.getJobletContext().getJobId().toString();
        }
        QueryColumnWithMetaMetadata.logFilter(jobId, normalizedFilterEvaluator, normalizedEvaluatorFactory.toString());
        QueryColumnWithMetaMetadata.logSchema(jobId, clippedRoot, SchemaStringBuilderVisitor.RECORD_SCHEMA, fieldNamesDictionary);
        QueryColumnWithMetaMetadata.logSchema(jobId, metaClippedRoot, SchemaStringBuilderVisitor.META_RECORD_SCHEMA, fieldNamesDictionary);
        PrimitiveColumnValuesReader[] primaryKeyReaders = QueryColumnWithMetaMetadata.createPrimaryKeyReaders(input, readerFactory, numberOfPrimaryKeys);
        return new QueryColumnWithMetaMetadata(datasetType, metaType, primaryKeyReaders, serializedMetadata, fieldNamesDictionary, clippedRoot, metaClippedRoot, readerFactory, valueGetterFactory, normalizedFilterEvaluator, filterValueAccessors, columnFilterEvaluator, filterColumnReaders);
    }
}

