/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import java.util.Map;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.operation.query.QueryColumnTupleProjector;
import org.apache.asterix.column.operation.query.QueryColumnWithMetaTupleProjector;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.storage.common.projection.ITupleProjector;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class QueryColumnTupleProjectorFactory
implements ITupleProjectorFactory {
    private static final long serialVersionUID = 2130283796584264219L;
    private final ARecordType datasetType;
    private final ARecordType metaType;
    private final int numberOfPrimaryKeys;
    private final ARecordType requestedType;
    private final ARecordType requestedMetaType;
    private final Map<String, FunctionCallInformation> functionCallInfo;
    private final IColumnRangeFilterEvaluatorFactory rangeFilterEvaluatorFactory;
    private final IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory;

    public QueryColumnTupleProjectorFactory(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, ARecordType requestedType, Map<String, FunctionCallInformation> functionCallInfo, ARecordType requestedMetaType, IColumnRangeFilterEvaluatorFactory rangeFilterEvaluatorFactory, IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory) {
        this.datasetType = datasetType;
        this.metaType = metaType;
        this.numberOfPrimaryKeys = numberOfPrimaryKeys;
        this.requestedType = requestedType;
        this.functionCallInfo = functionCallInfo;
        this.requestedMetaType = requestedMetaType;
        this.rangeFilterEvaluatorFactory = rangeFilterEvaluatorFactory;
        this.columnFilterEvaluatorFactory = columnFilterEvaluatorFactory;
    }

    public ITupleProjector createTupleProjector(IHyracksTaskContext context) throws HyracksDataException {
        IWarningCollector warningCollector = context.getWarningCollector();
        if (this.requestedMetaType == null) {
            return new QueryColumnTupleProjector(this.datasetType, this.numberOfPrimaryKeys, this.requestedType, this.functionCallInfo, this.rangeFilterEvaluatorFactory, this.columnFilterEvaluatorFactory, warningCollector, context);
        }
        return new QueryColumnWithMetaTupleProjector(this.datasetType, this.metaType, this.numberOfPrimaryKeys, this.requestedType, this.functionCallInfo, this.requestedMetaType, this.rangeFilterEvaluatorFactory, this.columnFilterEvaluatorFactory, warningCollector, context);
    }
}

