/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes;

import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;

public class ParquetDeltaBinaryPackingConfig {
    private int blockSizeInValues;
    private int miniBlockNumInABlock;
    private int miniBlockSizeInValues;

    public ParquetDeltaBinaryPackingConfig(int blockSizeInValues, int miniBlockNumInABlock) {
        this.reset(blockSizeInValues, miniBlockNumInABlock);
    }

    private void reset(int blockSizeInValues, int miniBlockNumInABlock) {
        this.blockSizeInValues = blockSizeInValues;
        this.miniBlockNumInABlock = miniBlockNumInABlock;
        double miniSize = (double)blockSizeInValues / (double)miniBlockNumInABlock;
        Preconditions.checkArgument((miniSize % 8.0 == 0.0 ? 1 : 0) != 0, (String)("miniBlockSize must be multiple of 8, but it's " + miniSize));
        this.miniBlockSizeInValues = (int)miniSize;
    }

    public static ParquetDeltaBinaryPackingConfig readConfig(InputStream in, ParquetDeltaBinaryPackingConfig config) throws IOException {
        int blockSizeInValues = BytesUtils.readUnsignedVarInt((InputStream)in);
        int miniBlockNumInABlock = BytesUtils.readUnsignedVarInt((InputStream)in);
        if (config == null) {
            return new ParquetDeltaBinaryPackingConfig(blockSizeInValues, miniBlockNumInABlock);
        }
        config.reset(blockSizeInValues, miniBlockNumInABlock);
        return config;
    }

    public BytesInput toBytesInput() {
        return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromUnsignedVarInt((int)this.blockSizeInValues), BytesInput.fromUnsignedVarInt((int)this.miniBlockNumInABlock)});
    }

    public int getBlockSizeInValues() {
        return this.blockSizeInValues;
    }

    public int getMiniBlockNumInABlock() {
        return this.miniBlockNumInABlock;
    }

    public int getMiniBlockSizeInValues() {
        return this.miniBlockSizeInValues;
    }
}

