/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnTupleProjector;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnWriteMetadata;
import org.apache.asterix.column.values.reader.ColumnValueReaderFactory;
import org.apache.asterix.column.values.writer.ColumnValuesWriterFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnManager;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnMetadata;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnTupleProjector;

public final class ColumnManager
implements IColumnManager {
    private final ARecordType datasetType;
    private final ARecordType metaType;
    private final List<List<String>> primaryKeys;
    private final List<Integer> keySourceIndicator;
    private final MergeColumnTupleProjector mergeColumnTupleProjector;

    ColumnManager(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, List<Integer> keySourceIndicator) {
        this.datasetType = datasetType;
        this.metaType = metaType;
        this.primaryKeys = primaryKeys;
        this.keySourceIndicator = keySourceIndicator;
        ColumnValueReaderFactory readerFactory = new ColumnValueReaderFactory();
        this.mergeColumnTupleProjector = new MergeColumnTupleProjector(datasetType, metaType, primaryKeys.size(), readerFactory);
    }

    public IColumnMetadata activate() throws HyracksDataException {
        MutableObject multiPageOpRef = new MutableObject();
        ColumnValuesWriterFactory factory = new ColumnValuesWriterFactory((Mutable<IColumnWriteMultiPageOp>)multiPageOpRef);
        return new FlushColumnMetadata(this.datasetType, this.metaType, this.primaryKeys, this.keySourceIndicator, factory, (Mutable<IColumnWriteMultiPageOp>)multiPageOpRef);
    }

    public IColumnMetadata activate(IValueReference metadata) throws HyracksDataException {
        try {
            MutableObject multiPageOpRef = new MutableObject();
            ColumnValuesWriterFactory writerFactory = new ColumnValuesWriterFactory((Mutable<IColumnWriteMultiPageOp>)multiPageOpRef);
            return FlushColumnMetadata.create(this.datasetType, this.metaType, this.primaryKeys, this.keySourceIndicator, writerFactory, (Mutable<IColumnWriteMultiPageOp>)multiPageOpRef, metadata);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public IColumnMetadata createMergeColumnMetadata(IValueReference metadata, List<IColumnTupleIterator> componentsTuples) throws HyracksDataException {
        try {
            return MergeColumnWriteMetadata.create(this.datasetType, this.metaType, this.primaryKeys.size(), (Mutable<IColumnWriteMultiPageOp>)new MutableObject(), metadata, componentsTuples);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public IColumnTupleProjector getMergeColumnProjector() {
        return this.mergeColumnTupleProjector;
    }
}

