/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IWriteDataSink;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class WriteOperator
extends AbstractLogicalOperator {
    private final Mutable<ILogicalExpression> sourceExpression;
    private final Mutable<ILogicalExpression> pathExpression;
    private final List<Mutable<ILogicalExpression>> partitionExpressions;
    private final List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions;
    private final IWriteDataSink writeDataSink;

    public WriteOperator(Mutable<ILogicalExpression> sourceExpression, Mutable<ILogicalExpression> pathExpression, List<Mutable<ILogicalExpression>> partitionExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions, IWriteDataSink writeDataSink) {
        this.sourceExpression = sourceExpression;
        this.pathExpression = pathExpression;
        this.partitionExpressions = partitionExpressions;
        this.orderExpressions = orderExpressions;
        this.writeDataSink = writeDataSink;
    }

    public Mutable<ILogicalExpression> getSourceExpression() {
        return this.sourceExpression;
    }

    public LogicalVariable getSourceVariable() {
        return VariableUtilities.getVariable((ILogicalExpression)this.sourceExpression.getValue());
    }

    public Mutable<ILogicalExpression> getPathExpression() {
        return this.pathExpression;
    }

    public List<Mutable<ILogicalExpression>> getPartitionExpressions() {
        return this.partitionExpressions;
    }

    public List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> getOrderExpressions() {
        return this.orderExpressions;
    }

    public List<LogicalVariable> getPartitionVariables() {
        ArrayList<LogicalVariable> partitionVariables = new ArrayList<LogicalVariable>();
        for (Mutable<ILogicalExpression> partitionExpression : this.partitionExpressions) {
            partitionVariables.add(VariableUtilities.getVariable((ILogicalExpression)partitionExpression.getValue()));
        }
        return partitionVariables;
    }

    public List<OrderColumn> getOrderColumns() {
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> orderExpressionPair : this.orderExpressions) {
            LogicalVariable variable = VariableUtilities.getVariable((ILogicalExpression)((Mutable)orderExpressionPair.getSecond()).getValue());
            OrderOperator.IOrder.OrderKind kind = ((OrderOperator.IOrder)orderExpressionPair.first).getKind();
            orderColumns.add(new OrderColumn(variable, kind));
        }
        return orderColumns;
    }

    public IWriteDataSink getWriteDataSink() {
        return this.writeDataSink;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.WRITE;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitWriteOperator(this, arg);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean changed = visitor.transform(this.sourceExpression);
        changed |= visitor.transform(this.pathExpression);
        for (Mutable<ILogicalExpression> mutable : this.partitionExpressions) {
            changed |= visitor.transform(mutable);
        }
        for (Pair pair : this.orderExpressions) {
            changed |= visitor.transform((Mutable<ILogicalExpression>)((Mutable)pair.second));
        }
        return changed;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.NONE;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList<LogicalVariable>(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }
}

