/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobSerializerDeserializer;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.deployment.ClassLoaderJobSerializerDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentUtils {
    public static final String DEPLOYMENT = "applications";
    private static final Logger LOGGER = LogManager.getLogger();

    public static void undeploy(DeploymentId deploymentId, ConcurrentMap<DeploymentId, IJobSerializerDeserializer> container, ServerContext ctx) throws HyracksException {
        container.remove(deploymentId);
        String rootDir = ctx.getBaseDir().toString();
        String deploymentDir = rootDir.endsWith(File.separator) ? rootDir + DEPLOYMENT + File.separator + deploymentId : rootDir + File.separator + DEPLOYMENT + File.separator + deploymentId;
        try {
            File dFile = new File(deploymentDir);
            if (dFile.exists()) {
                FileUtils.forceDelete((File)dFile);
            }
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public static void deploy(DeploymentId deploymentId, List<URL> urls, ConcurrentMap<DeploymentId, IJobSerializerDeserializer> container, ServerContext ctx, boolean isNC) throws HyracksException {
        IJobSerializerDeserializer jobSerDe = container.computeIfAbsent(deploymentId, d -> new ClassLoaderJobSerializerDeserializer());
        String rootDir = ctx.getBaseDir().toString();
        String deploymentDir = rootDir.endsWith(File.separator) ? rootDir + DEPLOYMENT + File.separator + deploymentId : rootDir + File.separator + DEPLOYMENT + File.separator + deploymentId;
        jobSerDe.addClassPathURLs(DeploymentUtils.downloadURLs(urls, deploymentDir, isNC));
    }

    public static Object deserialize(byte[] bytes, DeploymentId deploymentId, IServiceContext serviceCtx) throws HyracksException {
        try {
            IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : (IJobSerializerDeserializer)serviceCtx.getJobSerializerDeserializerContainer().get(deploymentId);
            return jobSerDe == null ? JavaSerializationUtils.deserialize((byte[])bytes) : jobSerDe.deserialize(bytes);
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public static Class<?> loadClass(String className, DeploymentId deploymentId, IServiceContext serviceCtx) throws HyracksException {
        try {
            IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : (IJobSerializerDeserializer)serviceCtx.getJobSerializerDeserializerContainer().get(deploymentId);
            return jobSerDe == null ? JavaSerializationUtils.loadClass((String)className) : jobSerDe.loadClass(className);
        }
        catch (IOException | ClassNotFoundException e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public static ClassLoader getClassLoader(DeploymentId deploymentId, IServiceContext appCtx) throws HyracksException {
        IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : (IJobSerializerDeserializer)appCtx.getJobSerializerDeserializerContainer().get(deploymentId);
        return jobSerDe == null ? DeploymentUtils.class.getClassLoader() : jobSerDe.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URL> downloadURLs(List<URL> urls, String deploymentDir, boolean isNC) throws HyracksException {
        int retryCount = 10;
        int tried = 0;
        Exception trace = null;
        while (tried < retryCount) {
            try {
                ++tried;
                ArrayList<URL> downloadedFileURLs = new ArrayList<URL>();
                File dir = new File(deploymentDir);
                if (!dir.exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
                for (URL url : urls) {
                    String urlString = url.toString();
                    int slashIndex = urlString.lastIndexOf(47);
                    String fileName = urlString.substring(slashIndex + 1).split("&")[1];
                    String filePath = deploymentDir + File.separator + fileName;
                    File targetFile = new File(filePath);
                    if (isNC) {
                        CloseableHttpClient hc = HttpClientBuilder.create().build();
                        HttpGet get = new HttpGet(url.toString());
                        HttpResponse response = hc.execute((HttpUriRequest)get);
                        HttpEntity e = response.getEntity();
                        try (FileOutputStream os = new FileOutputStream(targetFile);){
                            e.writeTo((OutputStream)os);
                        }
                    }
                    downloadedFileURLs.add(targetFile.toURI().toURL());
                }
                return downloadedFileURLs;
            }
            catch (Exception e) {
                LOGGER.error("Unable to fetch binaries from URL", (Throwable)e);
                trace = e;
            }
        }
        throw HyracksException.create(trace);
    }
}

