/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.util;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MutableArrayValueReference MARKER_LSN_KEY = new MutableArrayValueReference("Marker".getBytes());
    public static final long NOT_FOUND = -1L;

    private ComponentUtils() {
    }

    public static long getLong(IComponentMetadata metadata, IValueReference key, long defaultValue, ArrayBackedValueStorage value) throws HyracksDataException {
        metadata.get(key, value);
        return value.getLength() == 0 ? defaultValue : LongPointable.getLong((byte[])value.getByteArray(), (int)value.getStartOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        boolean loggable = LOGGER.isDebugEnabled();
        value.reset();
        if (loggable) {
            LOGGER.log(Level.DEBUG, "Getting " + key + " from index " + index);
        }
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            ILSMMemoryComponent cmc = index.getCurrentMemoryComponent();
            if (cmc.isReadable()) {
                index.getCurrentMemoryComponent().getMetadata().get(key, value);
            }
            if (value.getLength() == 0) {
                if (loggable) {
                    LOGGER.log(Level.DEBUG, key + " was not found in mutable memory component of " + index);
                }
                ComponentUtils.fromImmutableMemoryComponents(index, key, value);
                if (value.getLength() == 0) {
                    if (loggable) {
                        LOGGER.log(Level.DEBUG, key + " was not found in all immmutable memory components of " + index);
                    }
                    ComponentUtils.fromDiskComponents(index, key, value);
                    if (loggable) {
                        if (value.getLength() == 0) {
                            LOGGER.log(Level.DEBUG, key + " was not found in all disk components of " + index);
                        } else {
                            LOGGER.log(Level.DEBUG, key + " was found in disk components of " + index);
                        }
                    }
                } else if (loggable) {
                    LOGGER.log(Level.DEBUG, key + " was found in the immutable memory components of " + index);
                }
            } else if (loggable) {
                LOGGER.log(Level.DEBUG, key + " was found in mutable memory component of " + index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ILSMIndex index, IValueReference key, IPointable pointable) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            index.getCurrentMemoryComponent().getMetadata().put(key, (IValueReference)pointable);
        }
    }

    private static void fromDiskComponents(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        boolean loggable = LOGGER.isDebugEnabled();
        if (loggable) {
            LOGGER.log(Level.DEBUG, "Getting " + key + " from disk components of " + index);
        }
        for (ILSMDiskComponent c : index.getDiskComponents()) {
            if (loggable) {
                LOGGER.log(Level.DEBUG, "Getting " + key + " from disk components " + c);
            }
            c.getMetadata().get(key, value);
            if (value.getLength() == 0) continue;
            return;
        }
    }

    private static void fromImmutableMemoryComponents(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        boolean loggable = LOGGER.isDebugEnabled();
        if (loggable) {
            LOGGER.log(Level.DEBUG, "Getting " + key + " from immutable memory components of " + index);
        }
        List<ILSMMemoryComponent> memComponents = index.getMemoryComponents();
        int numOtherMemComponents = memComponents.size() - 1;
        int next = index.getCurrentMemoryComponentIndex();
        if (loggable) {
            LOGGER.log(Level.DEBUG, index + " has " + numOtherMemComponents + " immutable memory components");
        }
        for (int i = 0; i < numOtherMemComponents; ++i) {
            ILSMMemoryComponent c;
            if (loggable) {
                LOGGER.log(Level.DEBUG, "trying to get " + key + " from immutable memory components number: " + (i + 1));
            }
            if (--next < 0) {
                next = memComponents.size() - 1;
            }
            if (!(c = index.getMemoryComponents().get(next)).isReadable()) continue;
            c.getMetadata().get(key, value);
            if (value.getLength() == 0) continue;
            return;
        }
    }

    public static void markAsValid(ITreeIndex treeIndex, boolean forceToDisk, IPageWriteFailureCallback callback) throws HyracksDataException {
        int fileId = treeIndex.getFileId();
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.getPageManager().close(callback);
        if (callback.hasFailed()) {
            throw HyracksDataException.create((Throwable)callback.getFailure());
        }
        if (forceToDisk) {
            bufferCache.force(fileId, true);
        }
    }

    public static void markAsValid(IBufferCache bufferCache, BloomFilter filter, boolean forceToDisk) throws HyracksDataException {
        if (forceToDisk) {
            bufferCache.force(filter.getFileId(), true);
        }
    }
}

