/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordConcatEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 2L;
    private final IScalarEvaluatorFactory[] args;
    private final ARecordType[] argTypes;
    private final ARecordType listItemRecordType;
    private final boolean failOnArgTypeMismatch;
    private final SourceLocation sourceLoc;

    RecordConcatEvalFactory(IScalarEvaluatorFactory[] args, ARecordType[] argTypes, ARecordType listItemRecordType, boolean failOnArgTypeMismatch, SourceLocation sourceLoc) {
        this.args = args;
        this.argTypes = argTypes;
        this.listItemRecordType = listItemRecordType;
        this.failOnArgTypeMismatch = failOnArgTypeMismatch;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
        IScalarEvaluator[] argEvals = new IScalarEvaluator[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            argEvals[i] = this.args[i].createScalarEvaluator(ctx);
        }
        return new RecordConcatEvaluator(argEvals);
    }

    private static enum ArgKind {
        SINGLE_ARG_LIST,
        SINGLE_ARG,
        MULTIPLE_ARGS;

    }

    private final class RecordConcatEvaluator
    implements IScalarEvaluator {
        private static final int TABLE_FRAME_SIZE = 32768;
        private static final int TABLE_SIZE = 100;
        private ListAccessor listAccessor;
        private ARecordVisitablePointable itemRecordPointable;
        private final ArrayBackedValueStorage itemRecordStorage;
        private boolean itemRecordCastRequired;
        private ArgKind argKind;
        private final IPointable firstArg;
        private final IScalarEvaluator[] argEvals;
        private IPointable[] argPointables;
        private ARecordVisitablePointable[] argRecordPointables;
        private final ARecordVisitablePointable openRecordPointable;
        private final BitSet castRequired;
        private ACastVisitor castVisitor;
        private Triple<IVisitablePointable, IAType, Boolean> castVisitorArg;
        private final RecordBuilder outRecordBuilder;
        private final ArrayBackedValueStorage resultStorage;
        private final DataOutput resultOutput;
        private final BinaryHashMap fieldMap;
        private final BinaryEntry keyEntry;
        private final BinaryEntry valEntry;
        private int numRecords;

        private RecordConcatEvaluator(IScalarEvaluator[] argEvals) {
            this.argEvals = argEvals;
            this.firstArg = new VoidPointable();
            this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            this.resultStorage = new ArrayBackedValueStorage();
            this.resultOutput = this.resultStorage.getDataOutput();
            this.outRecordBuilder = new RecordBuilder();
            this.outRecordBuilder.reset(this.openRecordPointable.getInputRecordType());
            this.fieldMap = new BinaryHashMap(100, 32768, this.outRecordBuilder.getFieldNameHashFunction(), this.outRecordBuilder.getFieldNameHashFunction(), this.outRecordBuilder.getFieldNameComparator());
            this.keyEntry = new BinaryEntry();
            this.valEntry = new BinaryEntry();
            this.valEntry.set(new byte[0], 0, 0);
            this.castRequired = new BitSet();
            this.itemRecordStorage = new ArrayBackedValueStorage();
            if (RecordConcatEvalFactory.this.listItemRecordType != null) {
                this.itemRecordPointable = new ARecordVisitablePointable(RecordConcatEvalFactory.this.listItemRecordType);
                if (this.hasDerivedType(RecordConcatEvalFactory.this.listItemRecordType.getFieldTypes())) {
                    this.itemRecordCastRequired = true;
                    this.initCastVisitor();
                }
            } else {
                this.argPointables = new IPointable[RecordConcatEvalFactory.this.args.length];
                this.argRecordPointables = new ARecordVisitablePointable[RecordConcatEvalFactory.this.args.length];
                for (int i = 0; i < RecordConcatEvalFactory.this.args.length; ++i) {
                    this.argPointables[i] = new VoidPointable();
                    ARecordType argType = RecordConcatEvalFactory.this.argTypes[i];
                    if (argType == null) continue;
                    this.argRecordPointables[i] = new ARecordVisitablePointable(argType);
                    if (!this.hasDerivedType(argType.getFieldTypes())) continue;
                    this.castRequired.set(i);
                    this.initCastVisitor();
                }
            }
        }

        private void initCastVisitor() {
            if (this.castVisitor == null) {
                this.castVisitor = new ACastVisitor();
                this.castVisitorArg = new Triple((Object)this.openRecordPointable, (Object)this.openRecordPointable.getInputRecordType(), (Object)Boolean.FALSE);
            }
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.resultStorage.reset();
            if (RecordConcatEvalFactory.this.args.length == 0) {
                this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG, result);
                return;
            }
            if (!this.validateArgs(tuple, result)) {
                return;
            }
            this.processArgs();
            result.set((IValueReference)this.resultStorage);
        }

        private boolean validateArgs(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            if (this.argEvals.length == 1) {
                this.argEvals[0].evaluate(tuple, this.firstArg);
                byte[] data = this.firstArg.getByteArray();
                int offset = this.firstArg.getStartOffset();
                ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[data[offset]];
                if (typeTag.isListType()) {
                    if (this.listAccessor == null) {
                        this.listAccessor = new ListAccessor();
                    }
                    this.listAccessor.reset(data, offset);
                    this.argKind = ArgKind.SINGLE_ARG_LIST;
                    this.numRecords = this.listAccessor.size();
                    if (this.numRecords == 0) {
                        this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG, result);
                        return false;
                    }
                } else {
                    this.argKind = ArgKind.SINGLE_ARG;
                    this.numRecords = 1;
                }
            } else {
                this.argKind = ArgKind.MULTIPLE_ARGS;
                this.numRecords = this.argEvals.length;
            }
            return this.validateRecords(tuple, result, this.argKind);
        }

        private boolean validateRecords(IFrameTupleReference tuple, IPointable result, ArgKind argKind) throws HyracksDataException {
            boolean returnMissing = false;
            boolean returnNull = false;
            for (int i = 0; i < this.numRecords; ++i) {
                IPointable argPtr;
                byte typeTag;
                if (argKind == ArgKind.SINGLE_ARG_LIST) {
                    typeTag = this.listAccessor.getItemTypeAt(i).serialize();
                } else if (argKind == ArgKind.SINGLE_ARG) {
                    argPtr = this.argPointables[i];
                    argPtr.set((IValueReference)this.firstArg);
                    typeTag = argPtr.getByteArray()[argPtr.getStartOffset()];
                } else {
                    argPtr = this.argPointables[i];
                    this.argEvals[i].evaluate(tuple, argPtr);
                    typeTag = argPtr.getByteArray()[argPtr.getStartOffset()];
                }
                if (typeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                    returnMissing = true;
                    if (RecordConcatEvalFactory.this.failOnArgTypeMismatch) continue;
                    break;
                }
                if (typeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                    returnNull = true;
                    continue;
                }
                if (typeTag == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) continue;
                if (RecordConcatEvalFactory.this.failOnArgTypeMismatch) {
                    throw new TypeMismatchException(RecordConcatEvalFactory.this.sourceLoc, BuiltinFunctions.RECORD_CONCAT, i, typeTag, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                }
                returnNull = true;
            }
            if (returnMissing) {
                this.writeTypeTag(ATypeTag.SERIALIZED_MISSING_TYPE_TAG, result);
                return false;
            }
            if (returnNull) {
                this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG, result);
                return false;
            }
            return true;
        }

        private void processArgs() throws HyracksDataException {
            this.outRecordBuilder.init();
            this.fieldMap.clear();
            if (this.argKind == ArgKind.SINGLE_ARG_LIST) {
                this.processListRecords();
            } else {
                this.processArgsRecords();
            }
            this.outRecordBuilder.write(this.resultOutput, true);
        }

        private void processListRecords() throws HyracksDataException {
            for (int i = this.numRecords - 1; i >= 0; --i) {
                try {
                    this.itemRecordStorage.reset();
                    this.listAccessor.writeItem(i, this.itemRecordStorage.getDataOutput());
                    this.appendRecord((IPointable)this.itemRecordStorage, this.itemRecordPointable, this.itemRecordCastRequired);
                    continue;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }

        private void processArgsRecords() throws HyracksDataException {
            for (int i = this.numRecords - 1; i >= 0; --i) {
                try {
                    this.appendRecord(this.argPointables[i], this.argRecordPointables[i], this.castRequired.get(i));
                    continue;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }

        private void appendRecord(IPointable recordPtr, ARecordVisitablePointable argVisitablePointable, boolean argCastRequired) throws IOException {
            ARecordVisitablePointable recordPointable;
            if (argVisitablePointable != null) {
                argVisitablePointable.set((IValueReference)recordPtr);
                if (argCastRequired) {
                    argVisitablePointable.accept((IVisitablePointableVisitor)this.castVisitor, this.castVisitorArg);
                    recordPointable = this.openRecordPointable;
                } else {
                    recordPointable = argVisitablePointable;
                }
            } else {
                this.openRecordPointable.set((IValueReference)recordPtr);
                recordPointable = this.openRecordPointable;
            }
            List fieldNames = recordPointable.getFieldNames();
            List fieldValues = recordPointable.getFieldValues();
            int fieldCount = fieldNames.size();
            for (int i = 0; i < fieldCount; ++i) {
                IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
                if (!this.canAppendField(fieldName.getByteArray(), fieldName.getStartOffset() + 1, fieldName.getLength() - 1)) continue;
                this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValues.get(i));
            }
        }

        private boolean canAppendField(byte[] buf, int offset, int length) throws HyracksDataException {
            this.keyEntry.set(buf, offset, length);
            return this.fieldMap.put(this.keyEntry, this.valEntry) == null;
        }

        private boolean hasDerivedType(IAType[] types) {
            for (IAType type : types) {
                if (!type.getTypeTag().isDerivedType()) continue;
                return true;
            }
            return false;
        }

        private void writeTypeTag(byte typeTag, IPointable result) throws HyracksDataException {
            try {
                this.resultOutput.writeByte(typeTag);
                result.set((IValueReference)this.resultStorage);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

