/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ACircleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class CircleCenterAccessor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final FunctionIdentifier FID = BuiltinFunctions.GET_CIRCLE_CENTER_ACCESSOR;
    public static final IFunctionDescriptorFactory FACTORY = CircleCenterAccessor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final AMutablePoint aPoint;
                    private final ISerializerDeserializer<APoint> pointSerde;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aPoint = new AMutablePoint(0.0, 0.0);
                        this.pointSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.eval.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                            return;
                        }
                        byte[] bytes = this.argPtr.getByteArray();
                        int startOffset = this.argPtr.getStartOffset();
                        this.resultStorage.reset();
                        try {
                            if (bytes[startOffset] != ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG) {
                                throw new TypeMismatchException(CircleCenterAccessor.this.sourceLoc, CircleCenterAccessor.this.getIdentifier(), 0, bytes[startOffset], ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG);
                            }
                            double cX = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                            double cY = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y)));
                            this.aPoint.setValue(cX, cY);
                            this.pointSerde.serialize((Object)this.aPoint, this.out);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

