/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STLineFromMultiPointDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = STLineFromMultiPointDescriptor::new;

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        if (geometry instanceof OGCMultiPoint) {
            Polyline polyline = new Polyline();
            OGCMultiPoint multiPoint = (OGCMultiPoint)geometry;
            int numPoints = multiPoint.numGeometries();
            polyline.startPath((Point)multiPoint.geometryN(0).getEsriGeometry());
            for (int i = 1; i < numPoints; ++i) {
                polyline.lineTo((Point)multiPoint.geometryN(i).getEsriGeometry());
            }
            return new OGCLineString((MultiPath)polyline, 0, SpatialReference.create((int)4326));
        }
        throw new UnsupportedOperationException("The operation " + this.getIdentifier() + " is not supported for the type " + geometry.geometryType());
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_LINE_FROM_MULTIPOINT;
    }
}

