/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.ogc.OGCCurve;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCGeometryCollection;
import com.esri.core.geometry.ogc.OGCMultiCurve;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STIsClosedDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = STIsClosedDescriptor::new;

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        return this.isClosed(geometry);
    }

    private boolean isClosed(OGCGeometry geometry) {
        if (geometry instanceof OGCCurve) {
            return ((OGCCurve)geometry).isClosed();
        }
        if (geometry instanceof OGCMultiCurve) {
            return ((OGCMultiCurve)geometry).isClosed();
        }
        if (geometry instanceof OGCMultiPoint || geometry instanceof OGCMultiPolygon || geometry instanceof OGCPolygon || geometry instanceof OGCPoint) {
            return true;
        }
        if (geometry instanceof OGCGeometryCollection) {
            OGCGeometryCollection geometryCollection = (OGCGeometryCollection)geometry;
            int num = geometryCollection.numGeometries();
            for (int i = 0; i < num; ++i) {
                if (this.isClosed(geometryCollection.geometryN(i))) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException("The operation " + this.getIdentifier() + " is not supported for the type " + geometry.geometryType());
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_IS_CLOSED;
    }
}

