/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.CardinalityInferenceVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;

public class OperatorPropertiesUtil {
    public static final String MOVABLE = "isMovable";

    private OperatorPropertiesUtil() {
    }

    public static <T> boolean disjoint(Collection<T> c1, Collection<T> c2) {
        for (T m : c1) {
            if (!c2.contains(m)) continue;
            return false;
        }
        return true;
    }

    public static void getFreeVariablesInOp(ILogicalOperator op, Set<LogicalVariable> freeVars) throws AlgebricksException {
        VariableUtilities.getUsedVariables(op, freeVars);
        HashSet<LogicalVariable> produced = new HashSet<LogicalVariable>();
        VariableUtilities.getProducedVariables(op, produced);
        for (LogicalVariable v : produced) {
            freeVars.remove(v);
        }
    }

    public static void getFreeVariablesInSelfOrDesc(AbstractLogicalOperator op, Set<LogicalVariable> freeVars) throws AlgebricksException {
        HashSet<LogicalVariable> produced = new HashSet<LogicalVariable>();
        VariableUtilities.getProducedVariables(op, produced);
        for (LogicalVariable logicalVariable : produced) {
            freeVars.remove(logicalVariable);
        }
        HashSet<LogicalVariable> used = new HashSet<LogicalVariable>();
        VariableUtilities.getUsedVariables(op, used);
        for (LogicalVariable v : used) {
            freeVars.add(v);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans abstractOperatorWithNestedPlans = (AbstractOperatorWithNestedPlans)op;
            OperatorPropertiesUtil.getFreeVariablesInSubplans(abstractOperatorWithNestedPlans, freeVars);
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)i.getValue(), freeVars);
        }
    }

    public static void getFreeVariablesInPath(ILogicalOperator op, ILogicalOperator dest, Set<LogicalVariable> freeVars) throws AlgebricksException {
        ListSet producedVars = new ListSet();
        VariableUtilities.getLiveVariables(op, freeVars);
        OperatorPropertiesUtil.collectUsedAndProducedVariablesInPath(op, dest, freeVars, (Set<LogicalVariable>)producedVars);
        freeVars.removeAll((Collection<?>)producedVars);
    }

    private static boolean collectUsedAndProducedVariablesInPath(ILogicalOperator op, ILogicalOperator dest, Set<LogicalVariable> usedVars, Set<LogicalVariable> producedVars) throws AlgebricksException {
        if (op == dest) {
            return true;
        }
        if (((AbstractLogicalOperator)op).hasNestedPlans()) {
            AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : a.getNestedPlans()) {
                for (Mutable<ILogicalOperator> r : p.getRoots()) {
                    if (!OperatorPropertiesUtil.collectUsedAndProducedVariablesInPath((ILogicalOperator)r.getValue(), dest, usedVars, producedVars)) continue;
                    VariableUtilities.getUsedVariables((ILogicalOperator)r.getValue(), usedVars);
                    VariableUtilities.getProducedVariables((ILogicalOperator)r.getValue(), producedVars);
                    return true;
                }
            }
        }
        for (Mutable<ILogicalOperator> childRef : op.getInputs()) {
            if (!OperatorPropertiesUtil.collectUsedAndProducedVariablesInPath((ILogicalOperator)childRef.getValue(), dest, usedVars, producedVars)) continue;
            VariableUtilities.getUsedVariables(op, usedVars);
            VariableUtilities.getProducedVariables(op, producedVars);
            return true;
        }
        return false;
    }

    public static void getFreeVariablesInSubplans(AbstractOperatorWithNestedPlans op, Set<LogicalVariable> freeVars) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)r.getValue(), freeVars);
            }
        }
    }

    public static boolean hasFreeVariablesInSelfOrDesc(AbstractLogicalOperator op) throws AlgebricksException {
        HashSet<LogicalVariable> free = new HashSet<LogicalVariable>();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc(op, free);
        return !free.isEmpty();
    }

    public static boolean hasFreeVariables(ILogicalOperator op) throws AlgebricksException {
        HashSet<LogicalVariable> free = new HashSet<LogicalVariable>();
        OperatorPropertiesUtil.getFreeVariablesInOp(op, free);
        return !free.isEmpty();
    }

    public static void computeSchemaAndPropertiesRecIfNull(AbstractLogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        if (op.getSchema() == null) {
            for (Mutable<ILogicalOperator> i : op.getInputs()) {
                OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)i.getValue(), context);
            }
            if (op.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
                for (ILogicalPlan p : a.getNestedPlans()) {
                    for (Mutable<ILogicalOperator> r : p.getRoots()) {
                        OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)r.getValue(), context);
                    }
                }
            }
            op.recomputeSchema();
            op.computeDeliveredPhysicalProperties(context);
        }
    }

    public static void computeSchemaRecIfNull(AbstractLogicalOperator op) throws AlgebricksException {
        if (op.getSchema() == null) {
            for (Mutable<ILogicalOperator> i : op.getInputs()) {
                OperatorPropertiesUtil.computeSchemaRecIfNull((AbstractLogicalOperator)i.getValue());
            }
            if (op.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
                for (ILogicalPlan p : a.getNestedPlans()) {
                    for (Mutable<ILogicalOperator> r : p.getRoots()) {
                        OperatorPropertiesUtil.computeSchemaRecIfNull((AbstractLogicalOperator)r.getValue());
                    }
                }
            }
            op.recomputeSchema();
        }
    }

    public static void typePlan(ILogicalPlan p, IOptimizationContext context) throws AlgebricksException {
        for (Mutable<ILogicalOperator> r : p.getRoots()) {
            OperatorPropertiesUtil.typeOpRec(r, context);
        }
    }

    public static void typeOpRec(Mutable<ILogicalOperator> r, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)r.getValue();
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            OperatorPropertiesUtil.typeOpRec(i, context);
        }
        if (op.hasNestedPlans()) {
            for (ILogicalPlan p : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                OperatorPropertiesUtil.typePlan(p, context);
            }
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
    }

    public static boolean isAlwaysTrueCond(ILogicalExpression cond) {
        if (cond.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return ((ConstantExpression)cond).getValue().isTrue();
        }
        return false;
    }

    public static boolean isCardinalityExactOne(ILogicalOperator operator) throws AlgebricksException {
        return CardinalityInferenceVisitor.isCardinalityExactOne(operator);
    }

    public static boolean isCardinalityZeroOrOne(ILogicalOperator operator) throws AlgebricksException {
        return CardinalityInferenceVisitor.isCardinalityZeroOrOne(operator);
    }

    public static boolean isMovable(ILogicalOperator op) {
        Object annotation = op.getAnnotations().get(MOVABLE);
        if (annotation != null) {
            return (Boolean)annotation;
        }
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                for (Mutable<ILogicalExpression> expr : assign.getExpressions()) {
                    if (((ILogicalExpression)expr.getValue()).isFunctional()) continue;
                    return false;
                }
                break;
            }
            case RUNNINGAGGREGATE: 
            case WINDOW: {
                return false;
            }
        }
        return true;
    }

    public static void markMovable(ILogicalOperator op, boolean movable) {
        op.getAnnotations().put(MOVABLE, movable);
    }

    public static StructuralPropertiesVector checkUnpartitionedAndGetPropertiesVector(ILogicalOperator op, StructuralPropertiesVector partitionedPropertiesVector) {
        ILogicalOperator leftChild = (ILogicalOperator)op.getInputs().get(0).getValue();
        ILogicalOperator rightChild = (ILogicalOperator)op.getInputs().get(1).getValue();
        boolean unPartitioned = leftChild.getExecutionMode().equals((Object)AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) && rightChild.getExecutionMode().equals((Object)AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
        return unPartitioned ? StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR : partitionedPropertiesVector;
    }

    public static boolean isMultiOutputOperator(ILogicalOperator op) {
        LogicalOperatorTag opTag = op.getOperatorTag();
        return opTag == LogicalOperatorTag.REPLICATE || opTag == LogicalOperatorTag.SPLIT;
    }

    public static <T> List<T> unionAll(List<T> list1, List<T> list2) {
        if (list2 == null || list2.isEmpty()) {
            return list1 == null ? Collections.emptyList() : list1;
        }
        if (list1 == null || list1.isEmpty()) {
            return list2;
        }
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    public static FunctionIdentifier getIsMissingNullFunction(IAlgebricksConstantValue value) {
        return value.isMissing() ? AlgebricksBuiltinFunctions.IS_MISSING : (value.isNull() ? AlgebricksBuiltinFunctions.IS_NULL : null);
    }
}

