/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamLimitRuntimeFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class StreamLimitPOperator
extends AbstractPhysicalOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.STREAM_LIMIT;
    }

    @Override
    public boolean isMicroOperator() {
        return true;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator limitOp = (AbstractLogicalOperator)op;
        ILogicalOperator op2 = (ILogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = limitOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED ? new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, op2.getDeliveredPhysicalProperties().getLocalProperties()) : op2.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        AbstractLogicalOperator limitOp = (AbstractLogicalOperator)op;
        if (limitOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
            IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, null)};
            return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return this.emptyUnaryRequirements();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        LimitOperator limit = (LimitOperator)op;
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        IScalarEvaluatorFactory maxObjectsFact = limit.hasMaxObjects() ? expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)limit.getMaxObjects().getValue(), env, inputSchemas, context) : null;
        IScalarEvaluatorFactory offsetFact = limit.hasOffset() ? expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)limit.getOffset().getValue(), env, inputSchemas, context) : null;
        RecordDescriptor recDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        StreamLimitRuntimeFactory runtime = new StreamLimitRuntimeFactory(maxObjectsFact, offsetFact, null, context.getBinaryIntegerInspectorFactory());
        runtime.setSourceLocation(limit.getSourceLocation());
        builder.contributeMicroOperator(limit, (IPushRuntimeFactory)runtime, recDesc);
        ILogicalOperator src = (ILogicalOperator)limit.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, limit, 0);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }
}

