/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitter;
import org.apache.hadoop.fs.s3a.commit.CommitOperations;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.commit.MagicCommitPaths;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MagicS3GuardCommitter
extends AbstractS3ACommitter {
    private static final Logger LOG = LoggerFactory.getLogger(MagicS3GuardCommitter.class);
    public static final String NAME = "magic";

    public MagicS3GuardCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.setWorkPath(this.getTaskAttemptPath(context));
        CommitUtils.verifyIsMagicCommitPath(this.getDestS3AFS(), this.getWorkPath());
        LOG.debug("Task attempt {} has work path {}", (Object)context.getTaskAttemptID(), (Object)this.getWorkPath());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean requiresDelayedCommitOutputInFileSystem() {
        return true;
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Setup Job %s", new Object[]{CommitUtilsWithMR.jobIdString(context)});){
            super.setupJob(context);
            Path jobAttemptPath = this.getJobAttemptPath(context);
            this.getDestinationFS(jobAttemptPath, context.getConfiguration()).mkdirs(jobAttemptPath);
        }
    }

    @Override
    protected AbstractS3ACommitter.ActiveCommit listPendingUploadsToCommit(JobContext context) throws IOException {
        FileSystem fs = this.getDestFS();
        return AbstractS3ACommitter.ActiveCommit.fromStatusList(fs, S3AUtils.listAndFilter(fs, this.getJobAttemptPath(context), false, CommitOperations.PENDINGSET_FILTER));
    }

    @Override
    public void cleanupStagingDirs() {
        Path path = MagicCommitPaths.magicSubdir(this.getOutputPath());
        try (DurationInfo ignored = new DurationInfo(LOG, true, "Deleting magic directory %s", new Object[]{path});){
            Invoker.ignoreIOExceptions(LOG, "cleanup magic directory", path.toString(), () -> S3AUtils.deleteWithWarning(this.getDestFS(), path, true));
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        Path taskAttemptPath = this.getTaskAttemptPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "needsTaskCommit task %s", new Object[]{context.getTaskAttemptID()});){
            boolean bl = taskAttemptPath.getFileSystem(context.getConfiguration()).exists(taskAttemptPath);
            return bl;
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Commit task %s", new Object[]{context.getTaskAttemptID()});){
            PendingSet commits = this.innerCommitTask(context);
            LOG.info("Task {} committed {} files", (Object)context.getTaskAttemptID(), (Object)commits.size());
        }
        catch (IOException e) {
            this.getCommitOperations().taskCompleted(false);
            throw e;
        }
        finally {
            this.deleteTaskAttemptPathQuietly(context);
            this.destroyThreadPool();
        }
        this.getCommitOperations().taskCompleted(true);
        LOG.debug("aggregate statistics\n{}", IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)this.getIOStatistics()));
    }

    private PendingSet innerCommitTask(TaskAttemptContext context) throws IOException {
        Path taskAttemptPath = this.getTaskAttemptPath(context);
        CommitOperations actions = this.getCommitOperations();
        Pair<PendingSet, List<Pair<LocatedFileStatus, IOException>>> loaded = actions.loadSinglePendingCommits(taskAttemptPath, true);
        PendingSet pendingSet = (PendingSet)loaded.getKey();
        List failures = (List)loaded.getValue();
        if (!failures.isEmpty()) {
            LOG.error("At least one commit file could not be read: failing");
            this.abortPendingUploads((JobContext)context, pendingSet.getCommits(), true);
            throw (IOException)((Pair)failures.get(0)).getValue();
        }
        String jobId = this.getUUID();
        String taskId = String.valueOf(context.getTaskAttemptID());
        for (SinglePendingCommit commit : pendingSet.getCommits()) {
            commit.setJobId(jobId);
            commit.setTaskId(taskId);
        }
        pendingSet.putExtraData("task.attempt.id", taskId);
        pendingSet.setJobId(jobId);
        Path jobAttemptPath = this.getJobAttemptPath((JobContext)context);
        TaskAttemptID taskAttemptID = context.getTaskAttemptID();
        Path taskOutcomePath = new Path(jobAttemptPath, taskAttemptID.getTaskID().toString() + ".pendingset");
        LOG.info("Saving work of {} to {}", (Object)taskAttemptID, (Object)taskOutcomePath);
        LOG.debug("task statistics\n{}", IOStatisticsLogging.demandStringifyIOStatisticsSource((IOStatisticsSource)pendingSet));
        try {
            pendingSet.save(this.getDestFS(), taskOutcomePath, true);
        }
        catch (IOException e) {
            LOG.warn("Failed to save task commit data to {} ", (Object)taskOutcomePath, (Object)e);
            this.abortPendingUploads((JobContext)context, pendingSet.getCommits(), true);
            throw e;
        }
        return pendingSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTask(TaskAttemptContext context) throws IOException {
        Path attemptPath = this.getTaskAttemptPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "Abort task %s", new Object[]{context.getTaskAttemptID()});){
            this.getCommitOperations().abortAllSinglePendingCommits(attemptPath, true);
        }
        finally {
            S3AUtils.deleteQuietly(attemptPath.getFileSystem(context.getConfiguration()), attemptPath, true);
            this.destroyThreadPool();
        }
    }

    @Override
    protected Path getJobAttemptPath(int appAttemptId) {
        return CommitUtilsWithMR.getMagicJobAttemptPath(this.getUUID(), this.getOutputPath());
    }

    @Override
    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getMagicTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    protected Path getBaseTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    public Path getTempTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getTempTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitter{");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

