/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentation;
import org.apache.hadoop.fs.s3a.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.ChangeTrackerStatistics;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.s3a.statistics.CountersAndGauges;
import org.apache.hadoop.fs.s3a.statistics.DelegationTokenStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.StatisticTypeEnum;
import org.apache.hadoop.fs.s3a.statistics.impl.AbstractS3AStatisticsSource;
import org.apache.hadoop.fs.s3a.statistics.impl.CountingChangeTracker;
import org.apache.hadoop.fs.s3a.statistics.impl.ForwardingIOStatisticsStore;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricStringBuilder;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AInstrumentation
implements Closeable,
MetricsSource,
CountersAndGauges,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(S3AInstrumentation.class);
    private static final String METRICS_SOURCE_BASENAME = "S3AMetrics";
    public static final String METRICS_SYSTEM_NAME = "s3a-file-system";
    public static final String CONTEXT = "s3aFileSystem";
    public static final String METRIC_TAG_FILESYSTEM_ID = "s3aFileSystemId";
    public static final String METRIC_TAG_BUCKET = "bucket";
    private static final Object METRICS_SYSTEM_LOCK = new Object();
    private static MetricsSystem metricsSystem = null;
    private static int metricsSourceNameCounter = 0;
    private static int metricsSourceActiveCounter = 0;
    private final DurationTrackerFactory durationTrackerFactory;
    private String metricsSourceName;
    private final MetricsRegistry registry = new MetricsRegistry("s3aFileSystem").setContext("s3aFileSystem");
    private final MutableQuantiles putLatencyQuantile;
    private final MutableQuantiles throttleRateQuantile;
    private final MutableQuantiles s3GuardThrottleRateQuantile;
    private final S3GuardInstrumentation s3GuardInstrumentation = new S3GuardInstrumentation();
    private final IOStatisticsStore instanceIOStatistics;

    public S3AInstrumentation(URI name) {
        UUID fileSystemInstanceId = UUID.randomUUID();
        this.registry.tag(METRIC_TAG_FILESYSTEM_ID, "A unique identifier for the instance", fileSystemInstanceId.toString());
        this.registry.tag(METRIC_TAG_BUCKET, "Hostname from the FS URL", name.getHost());
        IOStatisticsStoreBuilder storeBuilder = IOStatisticsBinding.iostatisticsStore();
        EnumSet.allOf(Statistic.class).stream().filter(statistic -> statistic.getType() == StatisticTypeEnum.TYPE_COUNTER).forEach(stat -> {
            this.counter((Statistic)((Object)stat));
            storeBuilder.withCounters(new String[]{stat.getSymbol()});
        });
        EnumSet.allOf(Statistic.class).stream().filter(statistic -> statistic.getType() == StatisticTypeEnum.TYPE_GAUGE).forEach(stat -> {
            this.gauge((Statistic)((Object)stat));
            storeBuilder.withGauges(new String[]{stat.getSymbol()});
        });
        EnumSet.allOf(Statistic.class).stream().filter(statistic -> statistic.getType() == StatisticTypeEnum.TYPE_DURATION).forEach(stat -> {
            this.duration((Statistic)((Object)stat));
            storeBuilder.withDurationTracking(new String[]{stat.getSymbol()});
        });
        int interval = 1;
        this.putLatencyQuantile = this.quantiles(Statistic.S3GUARD_METADATASTORE_PUT_PATH_LATENCY, "ops", "latency", interval);
        this.s3GuardThrottleRateQuantile = this.quantiles(Statistic.S3GUARD_METADATASTORE_THROTTLE_RATE, "events", "frequency (Hz)", interval);
        this.throttleRateQuantile = this.quantiles(Statistic.STORE_IO_THROTTLE_RATE, "events", "frequency (Hz)", interval);
        this.registerAsMetricsSource(name);
        this.instanceIOStatistics = storeBuilder.build();
        this.durationTrackerFactory = IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)this.instanceIOStatistics, (DurationTrackerFactory)new MetricDurationTrackerFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public MetricsSystem getMetricsSystem() {
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            if (metricsSystem == null) {
                metricsSystem = new MetricsSystemImpl();
                metricsSystem.init(METRICS_SYSTEM_NAME);
            }
        }
        return metricsSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAsMetricsSource(URI name) {
        int number;
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            this.getMetricsSystem();
            ++metricsSourceActiveCounter;
            number = ++metricsSourceNameCounter;
        }
        String msName = METRICS_SOURCE_BASENAME + number;
        this.metricsSourceName = msName + "-" + name.getHost();
        metricsSystem.register(this.metricsSourceName, "", (Object)this);
    }

    protected final MutableCounterLong counter(String name, String desc) {
        return this.registry.newCounter(name, desc, 0L);
    }

    protected final MutableCounterLong counter(Statistic op) {
        return this.counter(op.getSymbol(), op.getDescription());
    }

    protected final void duration(Statistic op) {
        this.counter(op.getSymbol(), op.getDescription());
        this.counter(op.getSymbol() + ".failures", op.getDescription());
    }

    protected final MutableGaugeLong gauge(String name, String desc) {
        return this.registry.newGauge(name, desc, 0L);
    }

    protected final MutableGaugeLong gauge(Statistic op) {
        return this.gauge(op.getSymbol(), op.getDescription());
    }

    protected final MutableQuantiles quantiles(Statistic op, String sampleName, String valueName, int interval) {
        return this.registry.newQuantiles(op.getSymbol(), op.getDescription(), sampleName, valueName, interval);
    }

    public MetricsRegistry getRegistry() {
        return this.registry;
    }

    public String dump(String prefix, String separator, String suffix, boolean all) {
        MetricStringBuilder metricBuilder = new MetricStringBuilder(null, prefix, separator, suffix);
        this.registry.snapshot((MetricsRecordBuilder)metricBuilder, all);
        return metricBuilder.toString();
    }

    public long getCounterValue(Statistic statistic) {
        return this.getCounterValue(statistic.getSymbol());
    }

    public long getCounterValue(String name) {
        MutableCounterLong counter = this.lookupCounter(name);
        return counter == null ? 0L : counter.value();
    }

    private MutableCounterLong lookupCounter(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            return null;
        }
        if (!(metric instanceof MutableCounterLong)) {
            throw new IllegalStateException("Metric " + name + " is not a MutableCounterLong: " + metric + " (type: " + metric.getClass() + ")");
        }
        return (MutableCounterLong)metric;
    }

    public MutableGaugeLong lookupGauge(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            LOG.debug("No gauge {}", (Object)name);
        }
        return (MutableGaugeLong)metric;
    }

    public MutableQuantiles lookupQuantiles(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            LOG.debug("No quantiles {}", (Object)name);
        }
        return (MutableQuantiles)metric;
    }

    public MutableMetric lookupMetric(String name) {
        MutableMetric metric = this.getRegistry().get(name);
        return metric;
    }

    public IOStatisticsStore getIOStatistics() {
        return this.instanceIOStatistics;
    }

    public DurationTrackerFactory getDurationTrackerFactory() {
        return this.durationTrackerFactory;
    }

    public DurationTracker trackDuration(String key, long count) {
        return this.durationTrackerFactory.trackDuration(key, count);
    }

    public IOStatisticsStore createMetricsUpdatingStore() {
        return new MetricsUpdatingIOStatisticsStore();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AInstrumentation{");
        if (LOG.isDebugEnabled()) {
            sb.append("instanceIOStatistics=").append(this.instanceIOStatistics);
        }
        sb.append('}');
        return sb.toString();
    }

    public void fileCreated() {
        this.incrementCounter(Statistic.FILES_CREATED, 1L);
    }

    public void fileDeleted(int count) {
        this.incrementCounter(Statistic.FILES_DELETED, count);
    }

    public void fakeDirsDeleted(int count) {
        this.incrementCounter(Statistic.FAKE_DIRECTORIES_DELETED, count);
    }

    public void directoryCreated() {
        this.incrementCounter(Statistic.DIRECTORIES_CREATED, 1L);
    }

    public void directoryDeleted() {
        this.incrementCounter(Statistic.DIRECTORIES_DELETED, 1L);
    }

    public void filesCopied(int files, long size) {
        this.incrementCounter(Statistic.FILES_COPIED, files);
        this.incrementCounter(Statistic.FILES_COPIED_BYTES, size);
    }

    public void errorIgnored() {
        this.incrementCounter(Statistic.IGNORED_ERRORS, 1L);
    }

    @Override
    public void incrementCounter(Statistic op, long count) {
        this.incrementNamedCounter(op.getSymbol(), count);
    }

    private long incrementNamedCounter(String name, long count) {
        if (count != 0L) {
            this.incrementMutableCounter(name, count);
            return this.instanceIOStatistics.incrementCounter(name, count);
        }
        return 0L;
    }

    private void incrementMutableCounter(String name, long count) {
        MutableCounterLong counter;
        if (count > 0L && (counter = this.lookupCounter(name)) != null) {
            counter.incr(count);
        }
    }

    @Override
    public void addValueToQuantiles(Statistic op, long value) {
        MutableQuantiles quantiles = this.lookupQuantiles(op.getSymbol());
        if (quantiles != null) {
            quantiles.add(value);
        }
    }

    public void incrementCounter(Statistic op, AtomicLong count) {
        this.incrementCounter(op, count.get());
    }

    @Override
    public void incrementGauge(Statistic op, long count) {
        MutableGaugeLong gauge = this.lookupGauge(op.getSymbol());
        if (gauge != null) {
            gauge.incr(count);
        } else {
            LOG.debug("No Gauge: " + (Object)((Object)op));
        }
    }

    @Override
    public void decrementGauge(Statistic op, long count) {
        MutableGaugeLong gauge = this.lookupGauge(op.getSymbol());
        if (gauge != null) {
            gauge.decr(count);
        } else {
            LOG.debug("No Gauge: {}", (Object)op);
        }
    }

    @Override
    public void recordDuration(Statistic op, boolean success, Duration duration) {
        String name = op.getSymbol() + (success ? "" : ".failures");
        this.instanceIOStatistics.addTimedOperation(name, duration);
    }

    public S3AInputStreamStatistics newInputStreamStatistics(@Nullable FileSystem.Statistics filesystemStatistics) {
        return new InputStreamStatistics(filesystemStatistics);
    }

    public MetastoreInstrumentation getS3GuardInstrumentation() {
        return this.s3GuardInstrumentation;
    }

    public CommitterStatistics newCommitterStatistics() {
        return new CommitterStatisticsImpl();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info().name()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = METRICS_SYSTEM_LOCK;
        synchronized (object) {
            this.putLatencyQuantile.stop();
            this.throttleRateQuantile.stop();
            this.s3GuardThrottleRateQuantile.stop();
            metricsSystem.unregisterSource(this.metricsSourceName);
            int activeSources = --metricsSourceActiveCounter;
            if (activeSources == 0) {
                LOG.debug("Shutting down metrics publisher");
                metricsSystem.publishMetricsNow();
                metricsSystem.shutdown();
                metricsSystem = null;
            }
        }
    }

    public BlockOutputStreamStatistics newOutputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
        return new OutputStreamStatistics(filesystemStatistics);
    }

    private void mergeOutputStreamStatistics(OutputStreamStatistics source) {
        this.incrementCounter(Statistic.STREAM_WRITE_TOTAL_TIME, source.totalUploadDuration());
        this.incrementCounter(Statistic.STREAM_WRITE_QUEUE_DURATION, source.queueDuration);
        this.incrementCounter(Statistic.STREAM_WRITE_TOTAL_DATA, source.bytesUploaded);
        this.incrementCounter(Statistic.STREAM_WRITE_BLOCK_UPLOADS, source.blockUploadsCompleted);
        this.incrementCounter(Statistic.STREAM_WRITE_EXCEPTIONS, source.lookupCounterValue("stream_write_exceptions"));
        this.getIOStatistics().aggregate((IOStatistics)source.getIOStatistics());
    }

    public DelegationTokenStatistics newDelegationTokenStatistics() {
        return new DelegationTokenStatisticsImpl();
    }

    public Map<String, Long> toMap() {
        MetricsToMap metricBuilder = new MetricsToMap(null);
        this.registry.snapshot((MetricsRecordBuilder)metricBuilder, true);
        return metricBuilder.getMap();
    }

    private final class MetricsUpdatingIOStatisticsStore
    extends ForwardingIOStatisticsStore {
        private MetricsUpdatingIOStatisticsStore() {
            super(S3AInstrumentation.this.getIOStatistics());
        }

        @Override
        public long incrementCounter(String key, long value) {
            S3AInstrumentation.this.incrementMutableCounter(key, value);
            return super.incrementCounter(key, value);
        }

        public DurationTracker trackDuration(String key, long count) {
            return S3AInstrumentation.this.trackDuration(key, count);
        }

        public DurationTracker trackDuration(String key) {
            return S3AInstrumentation.this.trackDuration(key);
        }
    }

    private static class MetricsToMap
    extends MetricsRecordBuilder {
        private final MetricsCollector parent;
        private final Map<String, Long> map = new HashMap<String, Long>();

        MetricsToMap(MetricsCollector parent) {
            this.parent = parent;
        }

        public MetricsRecordBuilder tag(MetricsInfo info, String value) {
            return this;
        }

        public MetricsRecordBuilder add(MetricsTag tag) {
            return this;
        }

        public MetricsRecordBuilder add(AbstractMetric metric) {
            return this;
        }

        public MetricsRecordBuilder setContext(String value) {
            return this;
        }

        public MetricsRecordBuilder addCounter(MetricsInfo info, int value) {
            return this.tuple(info, (long)value);
        }

        public MetricsRecordBuilder addCounter(MetricsInfo info, long value) {
            return this.tuple(info, value);
        }

        public MetricsRecordBuilder addGauge(MetricsInfo info, int value) {
            return this.tuple(info, (long)value);
        }

        public MetricsRecordBuilder addGauge(MetricsInfo info, long value) {
            return this.tuple(info, value);
        }

        public MetricsToMap tuple(MetricsInfo info, long value) {
            return this.tuple(info.name(), value);
        }

        public MetricsToMap tuple(String name, long value) {
            this.map.put(name, value);
            return this;
        }

        public MetricsRecordBuilder addGauge(MetricsInfo info, float value) {
            return this.tuple(info, (long)value);
        }

        public MetricsRecordBuilder addGauge(MetricsInfo info, double value) {
            return this.tuple(info, (long)value);
        }

        public MetricsCollector parent() {
            return this.parent;
        }

        public Map<String, Long> getMap() {
            return this.map;
        }
    }

    private final class DelegationTokenStatisticsImpl
    implements DelegationTokenStatistics {
        private DelegationTokenStatisticsImpl() {
        }

        @Override
        public void tokenIssued() {
        }

        public DurationTracker trackDuration(String key, long count) {
            return S3AInstrumentation.this.getDurationTrackerFactory().trackDuration(key, count);
        }
    }

    private final class CommitterStatisticsImpl
    extends AbstractS3AStatisticsSource
    implements CommitterStatistics {
        private CommitterStatisticsImpl() {
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{Statistic.COMMITTER_BYTES_COMMITTED.getSymbol(), Statistic.COMMITTER_BYTES_UPLOADED.getSymbol(), Statistic.COMMITTER_COMMITS_CREATED.getSymbol(), Statistic.COMMITTER_COMMITS_ABORTED.getSymbol(), Statistic.COMMITTER_COMMITS_COMPLETED.getSymbol(), Statistic.COMMITTER_COMMITS_FAILED.getSymbol(), Statistic.COMMITTER_COMMITS_REVERTED.getSymbol(), Statistic.COMMITTER_JOBS_FAILED.getSymbol(), Statistic.COMMITTER_JOBS_SUCCEEDED.getSymbol(), Statistic.COMMITTER_TASKS_FAILED.getSymbol(), Statistic.COMMITTER_TASKS_SUCCEEDED.getSymbol()}).withDurationTracking(new String[]{Statistic.COMMITTER_COMMIT_JOB.getSymbol(), Statistic.COMMITTER_MATERIALIZE_FILE.getSymbol(), Statistic.COMMITTER_STAGE_FILE_UPLOAD.getSymbol()}).build();
            this.setIOStatistics(st);
        }

        private long increment(Statistic stat, long value) {
            S3AInstrumentation.this.incrementCounter(stat, value);
            return this.incCounter(stat.getSymbol(), value);
        }

        @Override
        public void commitCreated() {
            this.increment(Statistic.COMMITTER_COMMITS_CREATED, 1L);
        }

        @Override
        public void commitUploaded(long size) {
            this.increment(Statistic.COMMITTER_BYTES_UPLOADED, size);
        }

        @Override
        public void commitCompleted(long size) {
            this.increment(Statistic.COMMITTER_COMMITS_COMPLETED, 1L);
            this.increment(Statistic.COMMITTER_BYTES_COMMITTED, size);
        }

        @Override
        public void commitAborted() {
            this.increment(Statistic.COMMITTER_COMMITS_ABORTED, 1L);
        }

        @Override
        public void commitReverted() {
            this.increment(Statistic.COMMITTER_COMMITS_REVERTED, 1L);
        }

        @Override
        public void commitFailed() {
            this.increment(Statistic.COMMITTER_COMMITS_FAILED, 1L);
        }

        @Override
        public void taskCompleted(boolean success) {
            this.increment(success ? Statistic.COMMITTER_TASKS_SUCCEEDED : Statistic.COMMITTER_TASKS_FAILED, 1L);
        }

        @Override
        public void jobCompleted(boolean success) {
            this.increment(success ? Statistic.COMMITTER_JOBS_SUCCEEDED : Statistic.COMMITTER_JOBS_FAILED, 1L);
        }
    }

    private final class S3GuardInstrumentation
    implements MetastoreInstrumentation {
        private S3GuardInstrumentation() {
        }

        @Override
        public void initialized() {
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_INITIALIZATION, 1L);
        }

        @Override
        public void storeClosed() {
        }

        @Override
        public void throttled() {
        }

        @Override
        public void retrying() {
        }

        @Override
        public void recordsDeleted(int count) {
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_RECORD_DELETES, count);
        }

        @Override
        public void recordsRead(int count) {
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_RECORD_READS, count);
        }

        @Override
        public void recordsWritten(int count) {
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_RECORD_WRITES, count);
        }

        @Override
        public void directoryMarkedAuthoritative() {
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_AUTHORITATIVE_DIRECTORIES_UPDATED, 1L);
        }

        @Override
        public void entryAdded(long durationNanos) {
            S3AInstrumentation.this.addValueToQuantiles(Statistic.S3GUARD_METADATASTORE_PUT_PATH_LATENCY, durationNanos);
            S3AInstrumentation.this.incrementCounter(Statistic.S3GUARD_METADATASTORE_PUT_PATH_REQUEST, 1L);
        }
    }

    private final class OutputStreamStatistics
    extends AbstractS3AStatisticsSource
    implements BlockOutputStreamStatistics {
        private final AtomicLong blocksActive = new AtomicLong(0L);
        private final AtomicLong blockUploadsCompleted = new AtomicLong(0L);
        private final AtomicLong bytesWritten;
        private final AtomicLong bytesUploaded;
        private final AtomicLong transferDuration = new AtomicLong(0L);
        private final AtomicLong queueDuration = new AtomicLong(0L);
        private final AtomicInteger blocksAllocated = new AtomicInteger(0);
        private final AtomicInteger blocksReleased = new AtomicInteger(0);
        private final FileSystem.Statistics filesystemStatistics;

        private OutputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
            this.filesystemStatistics = filesystemStatistics;
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{Statistic.STREAM_WRITE_BLOCK_UPLOADS.getSymbol(), Statistic.STREAM_WRITE_BYTES.getSymbol(), Statistic.STREAM_WRITE_EXCEPTIONS.getSymbol(), Statistic.STREAM_WRITE_EXCEPTIONS_COMPLETING_UPLOADS.getSymbol(), Statistic.STREAM_WRITE_QUEUE_DURATION.getSymbol(), Statistic.STREAM_WRITE_TOTAL_DATA.getSymbol(), Statistic.STREAM_WRITE_TOTAL_TIME.getSymbol(), Statistic.INVOCATION_HFLUSH.getSymbol(), Statistic.INVOCATION_HSYNC.getSymbol()}).withGauges(new String[]{Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING.getSymbol(), Statistic.STREAM_WRITE_BLOCK_UPLOADS_BYTES_PENDING.getSymbol()}).withDurationTracking(new String[]{"action_executor_acquired", Statistic.INVOCATION_ABORT.getSymbol(), Statistic.OBJECT_MULTIPART_UPLOAD_ABORTED.getSymbol(), Statistic.MULTIPART_UPLOAD_COMPLETED.getSymbol()}).build();
            this.setIOStatistics(st);
            this.bytesUploaded = st.getCounterReference(Statistic.STREAM_WRITE_TOTAL_DATA.getSymbol());
            this.bytesWritten = st.getCounterReference("stream_write_bytes");
        }

        private long incAllGauges(Statistic statistic, long v) {
            S3AInstrumentation.this.incrementGauge(statistic, v);
            return this.incGauge(statistic.getSymbol(), v);
        }

        @Override
        public void blockAllocated() {
            this.blocksAllocated.incrementAndGet();
        }

        @Override
        public void blockReleased() {
            this.blocksReleased.incrementAndGet();
        }

        @Override
        public void blockUploadQueued(int blockSize) {
            this.incCounter("stream_write_block_uploads");
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING, 1L);
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_BYTES_PENDING, blockSize);
        }

        @Override
        public void blockUploadStarted(Duration timeInQueue, int blockSize) {
            this.queueDuration.addAndGet(timeInQueue.toMillis());
            this.localIOStatistics().addTimedOperation("action_executor_acquired", timeInQueue);
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING, -1L);
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_ACTIVE, 1L);
        }

        private IOStatisticsStore localIOStatistics() {
            return OutputStreamStatistics.super.getIOStatistics();
        }

        @Override
        public void blockUploadCompleted(Duration timeSinceUploadStarted, int blockSize) {
            this.transferDuration.addAndGet(timeSinceUploadStarted.toMillis());
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_ACTIVE, -1L);
            this.blockUploadsCompleted.incrementAndGet();
        }

        @Override
        public void blockUploadFailed(Duration timeSinceUploadStarted, int blockSize) {
            this.incCounter("stream_write_exceptions");
        }

        @Override
        public void bytesTransferred(long byteCount) {
            this.bytesUploaded.addAndGet(byteCount);
            this.incAllGauges(Statistic.STREAM_WRITE_BLOCK_UPLOADS_BYTES_PENDING, -byteCount);
        }

        @Override
        public void exceptionInMultipartComplete(int count) {
            if (count > 0) {
                this.incCounter(Statistic.STREAM_WRITE_EXCEPTIONS_COMPLETING_UPLOADS.getSymbol(), count);
            }
        }

        @Override
        public void exceptionInMultipartAbort() {
            this.incCounter(Statistic.STREAM_WRITE_EXCEPTIONS_COMPLETING_UPLOADS.getSymbol());
        }

        @Override
        public long getBytesPendingUpload() {
            return this.lookupGaugeValue(Statistic.STREAM_WRITE_BLOCK_UPLOADS_BYTES_PENDING.getSymbol());
        }

        @Override
        public void commitUploaded(long size) {
            S3AInstrumentation.this.incrementCounter(Statistic.COMMITTER_BYTES_UPLOADED, size);
        }

        @Override
        public void hflushInvoked() {
            this.incCounter(Statistic.INVOCATION_HFLUSH.getSymbol(), 1L);
        }

        @Override
        public void hsyncInvoked() {
            this.incCounter(Statistic.INVOCATION_HSYNC.getSymbol(), 1L);
        }

        @Override
        public void close() {
            if (this.getBytesPendingUpload() > 0L) {
                LOG.warn("Closing output stream statistics while data is still marked as pending upload in {}", (Object)this);
            }
            S3AInstrumentation.this.mergeOutputStreamStatistics(this);
            if (this.filesystemStatistics != null) {
                this.filesystemStatistics.incrementBytesWritten(this.bytesUploaded.get());
            }
        }

        private double effectiveBandwidth() {
            double duration = (double)this.totalUploadDuration() / 1000.0;
            return duration > 0.0 ? (double)this.bytesUploaded.get() / duration : 0.0;
        }

        private long totalUploadDuration() {
            return this.queueDuration.get() + this.transferDuration.get();
        }

        @Override
        public int getBlocksAllocated() {
            return this.blocksAllocated.get();
        }

        @Override
        public int getBlocksReleased() {
            return this.blocksReleased.get();
        }

        @Override
        public int getBlocksActivelyAllocated() {
            return this.blocksAllocated.get() - this.blocksReleased.get();
        }

        @Override
        public void writeBytes(long count) {
            this.bytesWritten.addAndGet(count);
        }

        @Override
        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("OutputStreamStatistics{");
            sb.append(this.localIOStatistics().toString());
            sb.append(", blocksActive=").append(this.blocksActive);
            sb.append(", blockUploadsCompleted=").append(this.blockUploadsCompleted);
            sb.append(", blocksAllocated=").append(this.blocksAllocated);
            sb.append(", blocksReleased=").append(this.blocksReleased);
            sb.append(", blocksActivelyAllocated=").append(this.getBlocksActivelyAllocated());
            sb.append(", transferDuration=").append(this.transferDuration).append(" ms");
            sb.append(", totalUploadDuration=").append(this.totalUploadDuration()).append(" ms");
            sb.append(", effectiveBandwidth=").append(this.effectiveBandwidth()).append(" bytes/s");
            sb.append('}');
            return sb.toString();
        }
    }

    private final class InputStreamStatistics
    extends AbstractS3AStatisticsSource
    implements S3AInputStreamStatistics {
        private static final int DISTANCE = 5;
        private final FileSystem.Statistics filesystemStatistics;
        private IOStatisticsSnapshot mergedStats;
        private final AtomicLong aborted;
        private final AtomicLong backwardSeekOperations;
        private final AtomicLong bytesBackwardsOnSeek;
        private final AtomicLong bytesDiscardedInAbort;
        private final AtomicLong bytesRead;
        private final AtomicLong bytesDiscardedInClose;
        private final AtomicLong bytesDiscardedOnSeek;
        private final AtomicLong bytesSkippedOnSeek;
        private final AtomicLong closed;
        private final AtomicLong forwardSeekOperations;
        private final AtomicLong openOperations;
        private final AtomicLong readExceptions;
        private final AtomicLong readsIncomplete;
        private final AtomicLong readOperations;
        private final AtomicLong readFullyOperations;
        private final AtomicLong seekOperations;
        private final AtomicLong totalBytesRead;

        private InputStreamStatistics(FileSystem.Statistics filesystemStatistics) {
            this.filesystemStatistics = filesystemStatistics;
            IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{"stream_aborted", "stream_read_bytes_discarded_in_abort", "stream_read_closed", "stream_read_bytes_discarded_in_close", "stream_read_close_operations", "stream_read_opened", "stream_read_bytes", "stream_read_exceptions", "stream_read_fully_operations", "stream_read_operations", "stream_read_operations_incomplete", "stream_read_seek_operations", "stream_read_seek_policy_changed", "stream_read_seek_backward_operations", "stream_read_seek_forward_operations", "stream_read_bytes_backwards_on_seek", "stream_read_seek_bytes_discarded", "stream_read_seek_bytes_skipped", "stream_read_total_bytes", "stream_read_unbuffered", "stream_read_version_mismatches"}).withGauges(new String[]{"stream_read_gauge_input_policy"}).withDurationTracking(new String[]{"action_http_get_request"}).build();
            this.setIOStatistics(st);
            this.aborted = st.getCounterReference("stream_aborted");
            this.backwardSeekOperations = st.getCounterReference("stream_read_seek_backward_operations");
            this.bytesBackwardsOnSeek = st.getCounterReference("stream_read_bytes_backwards_on_seek");
            this.bytesDiscardedInAbort = st.getCounterReference("stream_read_bytes_discarded_in_abort");
            this.bytesRead = st.getCounterReference("stream_read_bytes");
            this.bytesDiscardedInClose = st.getCounterReference("stream_read_bytes_discarded_in_close");
            this.bytesDiscardedOnSeek = st.getCounterReference("stream_read_seek_bytes_discarded");
            this.bytesSkippedOnSeek = st.getCounterReference("stream_read_seek_bytes_skipped");
            this.closed = st.getCounterReference("stream_read_closed");
            this.forwardSeekOperations = st.getCounterReference("stream_read_seek_forward_operations");
            this.openOperations = st.getCounterReference("stream_read_opened");
            this.readExceptions = st.getCounterReference("stream_read_exceptions");
            this.readsIncomplete = st.getCounterReference("stream_read_operations_incomplete");
            this.readOperations = st.getCounterReference("stream_read_operations");
            this.readFullyOperations = st.getCounterReference("stream_read_fully_operations");
            this.seekOperations = st.getCounterReference("stream_read_seek_operations");
            this.totalBytesRead = st.getCounterReference("stream_read_total_bytes");
            this.setIOStatistics(st);
            this.mergedStats = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)st);
        }

        private long increment(String name) {
            return this.increment(name, 1L);
        }

        private long increment(String name, long value) {
            return this.incCounter(name, value);
        }

        @Override
        public void seekBackwards(long negativeOffset) {
            this.seekOperations.incrementAndGet();
            this.backwardSeekOperations.incrementAndGet();
            this.bytesBackwardsOnSeek.addAndGet(-negativeOffset);
        }

        @Override
        public void seekForwards(long skipped, long bytesReadInSeek) {
            this.seekOperations.incrementAndGet();
            this.forwardSeekOperations.incrementAndGet();
            if (skipped > 0L) {
                this.bytesSkippedOnSeek.addAndGet(skipped);
            }
            if (bytesReadInSeek > 0L) {
                this.bytesDiscardedOnSeek.addAndGet(bytesReadInSeek);
                this.totalBytesRead.addAndGet(bytesReadInSeek);
            }
        }

        @Override
        public long streamOpened() {
            return this.openOperations.getAndIncrement();
        }

        @Override
        public void streamClose(boolean abortedConnection, long remainingInCurrentRequest) {
            if (abortedConnection) {
                this.aborted.incrementAndGet();
                this.bytesDiscardedInAbort.addAndGet(remainingInCurrentRequest);
            } else {
                this.closed.incrementAndGet();
                this.bytesDiscardedInClose.addAndGet(remainingInCurrentRequest);
                this.totalBytesRead.addAndGet(remainingInCurrentRequest);
                this.filesystemStatistics.incrementBytesRead(remainingInCurrentRequest);
            }
        }

        @Override
        public void readException() {
            this.readExceptions.incrementAndGet();
        }

        @Override
        public void bytesRead(long bytes) {
            if (bytes > 0L) {
                this.bytesRead.addAndGet(bytes);
                this.totalBytesRead.addAndGet(bytes);
            }
        }

        @Override
        public void readOperationStarted(long pos, long len) {
            this.readOperations.incrementAndGet();
        }

        @Override
        public void readFullyOperationStarted(long pos, long len) {
            this.readFullyOperations.incrementAndGet();
        }

        @Override
        public void readOperationCompleted(int requested, int actual) {
            if (requested > actual) {
                this.readsIncomplete.incrementAndGet();
            }
        }

        @Override
        public void close() {
            this.increment("stream_read_close_operations");
            this.merge(true);
        }

        @Override
        public void inputPolicySet(int updatedPolicy) {
            this.increment("stream_read_seek_policy_changed");
            this.localIOStatistics().setGauge("stream_read_gauge_input_policy", (long)updatedPolicy);
        }

        private IOStatisticsStore localIOStatistics() {
            return InputStreamStatistics.super.getIOStatistics();
        }

        @Override
        public ChangeTrackerStatistics getChangeTrackerStatistics() {
            return new CountingChangeTracker(this.localIOStatistics().getCounterReference("stream_read_version_mismatches"));
        }

        @Override
        @InterfaceStability.Unstable
        public String toString() {
            StringBuilder sb = new StringBuilder("StreamStatistics{");
            sb.append(IOStatisticsLogging.ioStatisticsToString((IOStatistics)this.localIOStatistics()));
            sb.append('}');
            return sb.toString();
        }

        @Override
        public void unbuffered() {
            this.increment("stream_read_unbuffered");
            this.merge(false);
        }

        private void merge(boolean isClosed) {
            IOStatisticsStore ioStatistics = this.localIOStatistics();
            LOG.debug("Merging statistics into FS statistics in {}: {}", (Object)(isClosed ? "close()" : "unbuffer()"), IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)ioStatistics));
            this.promoteInputStreamCountersToMetrics();
            this.mergedStats = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)this.localIOStatistics());
            if (isClosed) {
                S3AInstrumentation.this.getIOStatistics().aggregate((IOStatistics)ioStatistics);
                if (this.filesystemStatistics != null) {
                    long t = this.getTotalBytesRead();
                    this.filesystemStatistics.incrementBytesReadByDistance(5, t);
                }
            }
        }

        void promoteIOCounter(String name) {
            S3AInstrumentation.this.incrementMutableCounter(name, this.lookupCounterValue(name) - (Long)this.mergedStats.counters().get(name));
        }

        private void promoteInputStreamCountersToMetrics() {
            this.localIOStatistics().counters().keySet().stream().forEach(e -> this.promoteIOCounter((String)e));
        }

        @Override
        public long getCloseOperations() {
            return this.lookupCounterValue("stream_read_close_operations");
        }

        @Override
        public long getClosed() {
            return this.lookupCounterValue("stream_read_closed");
        }

        @Override
        public long getAborted() {
            return this.lookupCounterValue("stream_aborted");
        }

        @Override
        public long getForwardSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_forward_operations");
        }

        @Override
        public long getBackwardSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_backward_operations");
        }

        @Override
        public long getBytesRead() {
            return this.lookupCounterValue("stream_read_bytes");
        }

        @Override
        public long getTotalBytesRead() {
            return this.lookupCounterValue("stream_read_total_bytes");
        }

        @Override
        public long getBytesSkippedOnSeek() {
            return this.lookupCounterValue("stream_read_seek_bytes_skipped");
        }

        @Override
        public long getBytesBackwardsOnSeek() {
            return this.lookupCounterValue("stream_read_bytes_backwards_on_seek");
        }

        @Override
        public long getBytesReadInClose() {
            return this.lookupCounterValue("stream_read_bytes_discarded_in_close");
        }

        @Override
        public long getBytesDiscardedInAbort() {
            return this.lookupCounterValue("stream_read_bytes_discarded_in_abort");
        }

        @Override
        public long getOpenOperations() {
            return this.lookupCounterValue("stream_read_opened");
        }

        @Override
        public long getSeekOperations() {
            return this.lookupCounterValue("stream_read_seek_operations");
        }

        @Override
        public long getReadExceptions() {
            return this.lookupCounterValue("stream_read_exceptions");
        }

        @Override
        public long getReadOperations() {
            return this.lookupCounterValue("stream_read_operations");
        }

        @Override
        public long getReadFullyOperations() {
            return this.lookupCounterValue("stream_read_fully_operations");
        }

        @Override
        public long getReadsIncomplete() {
            return this.lookupCounterValue("stream_read_operations_incomplete");
        }

        @Override
        public long getPolicySetCount() {
            return this.lookupCounterValue("stream_read_seek_policy_changed");
        }

        @Override
        public long getVersionMismatches() {
            return this.lookupCounterValue("stream_read_version_mismatches");
        }

        @Override
        public long getInputPolicy() {
            return (Long)this.localIOStatistics().gauges().get("stream_read_gauge_input_policy");
        }

        @Override
        public DurationTracker initiateGetRequest() {
            return this.trackDuration("action_http_get_request");
        }
    }

    private final class MetricDurationTrackerFactory
    implements DurationTrackerFactory {
        private MetricDurationTrackerFactory() {
        }

        public DurationTracker trackDuration(String key, long count) {
            return new MetricUpdatingDurationTracker(key, count);
        }
    }

    private final class MetricUpdatingDurationTracker
    implements DurationTracker {
        private final String symbol;
        private boolean failed;

        private MetricUpdatingDurationTracker(String symbol, long count) {
            this.symbol = symbol;
            S3AInstrumentation.this.incrementMutableCounter(symbol, count);
        }

        public void failed() {
            this.failed = true;
        }

        public void close() {
            if (this.failed) {
                S3AInstrumentation.this.incrementMutableCounter(this.symbol + ".failures", 1L);
            }
        }
    }
}

