/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.ListingOperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStoreListFilesIterator;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class Listing
extends AbstractStoreOperation {
    private static final Logger LOG = S3AFileSystem.LOG;
    private final boolean isCSEEnabled;
    static final FileStatusAcceptor ACCEPT_ALL_BUT_S3N = new AcceptAllButS3nDirs();
    private final ListingOperationCallbacks listingOperationCallbacks;

    public Listing(ListingOperationCallbacks listingOperationCallbacks, StoreContext storeContext) {
        super(storeContext);
        this.listingOperationCallbacks = listingOperationCallbacks;
        this.isCSEEnabled = storeContext.isCSEEnabled();
    }

    RemoteIterator<S3AFileStatus> createProvidedFileStatusIterator(S3AFileStatus[] fileStatuses, PathFilter filter, FileStatusAcceptor acceptor) {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)RemoteIterators.remoteIteratorFromArray((Object[])fileStatuses), status -> filter.accept(status.getPath()) && acceptor.accept((FileStatus)status));
    }

    @VisibleForTesting
    public static RemoteIterator<S3AFileStatus> toProvidedFileStatusIterator(S3AFileStatus[] fileStatuses) {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)RemoteIterators.remoteIteratorFromArray((Object[])fileStatuses), ACCEPT_ALL_BUT_S3N::accept);
    }

    public FileStatusListingIterator createFileStatusListingIterator(Path listPath, S3ListRequest request, PathFilter filter, FileStatusAcceptor acceptor, AuditSpan span) throws IOException {
        return this.createFileStatusListingIterator(listPath, request, filter, acceptor, null, span);
    }

    public FileStatusListingIterator createFileStatusListingIterator(Path listPath, S3ListRequest request, PathFilter filter, FileStatusAcceptor acceptor, RemoteIterator<S3AFileStatus> providedStatus, AuditSpan span) throws IOException {
        return new FileStatusListingIterator(this.createObjectListingIterator(listPath, request, span), filter, acceptor, providedStatus);
    }

    private ObjectListingIterator createObjectListingIterator(Path listPath, S3ListRequest request, AuditSpan span) throws IOException {
        return new ObjectListingIterator(listPath, request, span);
    }

    @VisibleForTesting
    public RemoteIterator<S3ALocatedFileStatus> createLocatedFileStatusIterator(RemoteIterator<S3AFileStatus> statusIterator) {
        return RemoteIterators.mappingRemoteIterator(statusIterator, this.listingOperationCallbacks::toLocatedFileStatus);
    }

    @VisibleForTesting
    RemoteIterator<S3ALocatedFileStatus> createTombstoneReconcilingIterator(RemoteIterator<S3ALocatedFileStatus> iterator, @Nullable Set<Path> tombstones) {
        if (tombstones == null || tombstones.isEmpty()) {
            return iterator;
        }
        return RemoteIterators.filteringRemoteIterator(iterator, candidate -> !tombstones.contains(candidate.getPath()));
    }

    public RemoteIterator<S3ALocatedFileStatus> createSingleStatusIterator(S3ALocatedFileStatus status) {
        return RemoteIterators.remoteIteratorFromSingleton((Object)((Object)status));
    }

    public RemoteIterator<S3ALocatedFileStatus> getListFilesAssumingDir(Path path, boolean recursive, FileStatusAcceptor acceptor, boolean collectTombstones, boolean forceNonAuthoritativeMS, AuditSpan span) throws IOException {
        MetadataStoreListFilesIterator cachedFilesIterator;
        Set<Path> tombstones;
        String delimiter;
        String key = S3AUtils.maybeAddTrailingSlash(RoleModel.pathToKey(path));
        String string = delimiter = recursive ? null : "/";
        if (recursive) {
            LOG.debug("Recursive list of all entries under {}", (Object)key);
        } else {
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
        }
        boolean allowAuthoritative = this.listingOperationCallbacks.allowAuthoritative(path);
        if (recursive) {
            PathMetadata pm = this.getStoreContext().getMetadataStore().get(path, true);
            if (pm != null && pm.isDeleted()) {
                OffsetDateTime deletedAt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(pm.getFileStatus().getModificationTime()), ZoneOffset.UTC);
                throw new FileNotFoundException("Path " + path + " is recorded as deleted by S3Guard at " + deletedAt);
            }
            MetadataStoreListFilesIterator metadataStoreListFilesIterator = new MetadataStoreListFilesIterator(this.getStoreContext().getMetadataStore(), pm, allowAuthoritative);
            tombstones = metadataStoreListFilesIterator.listTombstones();
            if (!forceNonAuthoritativeMS && allowAuthoritative && metadataStoreListFilesIterator.isRecursivelyAuthoritative()) {
                S3AFileStatus[] statuses = S3AUtils.iteratorToStatuses(metadataStoreListFilesIterator, tombstones);
                RemoteIterator<S3AFileStatus> cachedFilesIterator2 = this.createProvidedFileStatusIterator(statuses, S3AUtils.ACCEPT_ALL, acceptor);
                return this.createLocatedFileStatusIterator(cachedFilesIterator2);
            }
            cachedFilesIterator = metadataStoreListFilesIterator;
        } else {
            DirListingMetadata meta = S3Guard.listChildrenWithTtl(this.getStoreContext().getMetadataStore(), path, this.listingOperationCallbacks.getUpdatedTtlTimeProvider(), allowAuthoritative);
            tombstones = meta != null ? meta.listTombstones() : null;
            cachedFilesIterator = this.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), S3AUtils.ACCEPT_ALL, acceptor);
            if (allowAuthoritative && meta != null && meta.isAuthoritative()) {
                return this.createLocatedFileStatusIterator(cachedFilesIterator);
            }
        }
        return this.createTombstoneReconcilingIterator(this.createLocatedFileStatusIterator(this.createFileStatusListingIterator(path, this.listingOperationCallbacks.createListObjectsRequest(key, delimiter, span), S3AUtils.ACCEPT_ALL, acceptor, cachedFilesIterator, span)), collectTombstones ? tombstones : null);
    }

    public RemoteIterator<S3ALocatedFileStatus> getLocatedFileStatusIteratorForDir(Path dir, PathFilter filter, AuditSpan span) throws IOException {
        span.activate();
        String key = S3AUtils.maybeAddTrailingSlash(RoleModel.pathToKey(dir));
        AcceptAllButSelfAndS3nDirs acceptor = new AcceptAllButSelfAndS3nDirs(dir);
        boolean allowAuthoritative = this.listingOperationCallbacks.allowAuthoritative(dir);
        DirListingMetadata meta = S3Guard.listChildrenWithTtl(this.getStoreContext().getMetadataStore(), dir, this.listingOperationCallbacks.getUpdatedTtlTimeProvider(), allowAuthoritative);
        if (meta != null) {
            RemoteIterator<S3AFileStatus> cachedFileStatusIterator = this.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), filter, acceptor);
            if (allowAuthoritative && meta.isAuthoritative()) {
                return this.createLocatedFileStatusIterator(cachedFileStatusIterator);
            }
            return this.createTombstoneReconcilingIterator(this.createLocatedFileStatusIterator(this.createFileStatusListingIterator(dir, this.listingOperationCallbacks.createListObjectsRequest(key, "/", span), filter, acceptor, cachedFileStatusIterator, span)), meta.listTombstones());
        }
        return this.createLocatedFileStatusIterator(this.createFileStatusListingIterator(dir, this.listingOperationCallbacks.createListObjectsRequest(key, "/", span), filter, acceptor, span));
    }

    public Triple<RemoteIterator<S3AFileStatus>, DirListingMetadata, Boolean> getFileStatusesAssumingNonEmptyDir(Path path, AuditSpan span) throws IOException {
        String key = RoleModel.pathToKey(path);
        if (!key.isEmpty()) {
            key = key + '/';
        }
        boolean allowAuthoritative = this.listingOperationCallbacks.allowAuthoritative(path);
        DirListingMetadata dirMeta = S3Guard.listChildrenWithTtl(this.getStoreContext().getMetadataStore(), path, this.listingOperationCallbacks.getUpdatedTtlTimeProvider(), allowAuthoritative);
        if (allowAuthoritative && dirMeta != null && dirMeta.isAuthoritative()) {
            RemoteIterator<S3AFileStatus> mfsItr = this.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(dirMeta), S3AUtils.ACCEPT_ALL, ACCEPT_ALL_BUT_S3N);
            return Triple.of(mfsItr, (Object)dirMeta, (Object)Boolean.TRUE);
        }
        S3ListRequest request = this.createListObjectsRequest(key, "/", span);
        LOG.debug("listStatus: doing listObjects for directory {}", (Object)key);
        FileStatusListingIterator filesItr = this.createFileStatusListingIterator(path, request, S3AUtils.ACCEPT_ALL, new AcceptAllButSelfAndS3nDirs(path), span);
        return Triple.of((Object)filesItr, (Object)dirMeta, (Object)Boolean.FALSE);
    }

    public S3ListRequest createListObjectsRequest(String key, String delimiter, AuditSpan span) {
        return this.listingOperationCallbacks.createListObjectsRequest(key, delimiter, span);
    }

    public static RemoteIterator<LocatedFileStatus> toLocatedFileStatusIterator(RemoteIterator<? extends LocatedFileStatus> iterator) {
        return iterator;
    }

    public static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelfAndS3nDirs(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals((Object)this.qualifiedPath);
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && !status.getPath().equals((Object)this.qualifiedPath);
        }
    }

    static class AcceptAllButS3nDirs
    implements FileStatusAcceptor {
        AcceptAllButS3nDirs() {
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !summary.getKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.toString().endsWith("_$folder$");
        }

        @Override
        public boolean accept(FileStatus status) {
            return !status.getPath().toString().endsWith("_$folder$");
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getKey().endsWith("_$folder$") && !S3AUtils.objectRepresentsDirectory(summary.getKey());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && status.isFile();
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<S3ListResult>,
    IOStatisticsSource,
    Closeable {
        private final Path listPath;
        private final AuditSpan span;
        private S3ListResult objects;
        private S3ListRequest request;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;
        private final IOStatisticsStore iostats;
        private CompletableFuture<S3ListResult> s3ListResultFuture;
        private S3ListResult objectsPrev;

        ObjectListingIterator(Path listPath, S3ListRequest request, AuditSpan span) throws IOException {
            this.listPath = listPath;
            this.maxKeys = Listing.this.listingOperationCallbacks.getMaxKeys();
            this.request = request;
            this.objectsPrev = null;
            this.iostats = IOStatisticsBinding.iostatisticsStore().withDurationTracking(new String[]{"object_list_request"}).withDurationTracking(new String[]{"object_continue_list_request"}).build();
            this.span = span;
            this.s3ListResultFuture = Listing.this.listingOperationCallbacks.listObjectsAsync(request, (DurationTrackerFactory)this.iostats, span);
        }

        public boolean hasNext() throws IOException {
            return this.firstListing || this.objectsPrev != null && this.objectsPrev.isTruncated();
        }

        public S3ListResult next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
                this.objects = (S3ListResult)FutureIOSupport.awaitFuture(this.s3ListResultFuture);
                this.fetchNextBatchAsyncIfPresent();
            } else {
                try {
                    if (this.objectsPrev != null && !this.objectsPrev.isTruncated()) {
                        throw new NoSuchElementException("No more results in listing of " + this.listPath);
                    }
                    this.objects = (S3ListResult)FutureIOSupport.awaitFuture(this.s3ListResultFuture);
                    this.fetchNextBatchAsyncIfPresent();
                    ++this.listingCount;
                    LOG.debug("New listing status: {}", (Object)this);
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("listObjects()", this.listPath, e);
                }
            }
            this.objectsPrev = this.objects;
            return this.objectsPrev;
        }

        private void fetchNextBatchAsyncIfPresent() throws IOException {
            if (this.objects.isTruncated()) {
                LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                this.s3ListResultFuture = Listing.this.listingOperationCallbacks.continueListObjectsAsync(this.request, this.objects, (DurationTrackerFactory)this.iostats, this.span);
            }
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated() + "; " + this.iostats;
        }

        public IOStatistics getIOStatistics() {
            return this.iostats;
        }

        public Path getListPath() {
            return this.listPath;
        }

        public int getListingCount() {
            return this.listingCount;
        }

        @Override
        public void close() {
        }
    }

    class FileStatusListingIterator
    implements RemoteIterator<S3AFileStatus>,
    IOStatisticsSource {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<S3AFileStatus> statusBatchIterator;
        private final Map<Path, S3AFileStatus> providedStatus;
        private Iterator<S3AFileStatus> providedStatusIterator;

        FileStatusListingIterator(ObjectListingIterator source, PathFilter filter, @Nullable FileStatusAcceptor acceptor, RemoteIterator<S3AFileStatus> providedStatus) throws IOException {
            this.source = source;
            this.filter = filter;
            this.acceptor = acceptor;
            this.providedStatus = new HashMap<Path, S3AFileStatus>();
            while (providedStatus != null && providedStatus.hasNext()) {
                S3AFileStatus status = (S3AFileStatus)((Object)providedStatus.next());
                Path path = status.getPath();
                if (!filter.accept(path) || !acceptor.accept(status)) continue;
                this.providedStatus.put(path, status);
            }
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.sourceHasNext() || this.providedStatusIterator.hasNext();
        }

        private boolean sourceHasNext() throws IOException {
            if (this.statusBatchIterator.hasNext() || this.requestNextBatch()) {
                return true;
            }
            if (this.providedStatusIterator == null) {
                LOG.debug("Start iterating the provided status.");
                this.providedStatusIterator = this.providedStatus.values().iterator();
            }
            return false;
        }

        public S3AFileStatus next() throws IOException {
            S3AFileStatus status;
            if (this.sourceHasNext()) {
                status = this.statusBatchIterator.next();
                S3AFileStatus provided = this.providedStatus.remove(status.getPath());
                if (provided != null) {
                    LOG.debug("Removed and returned the status from provided file status {}", (Object)status);
                    return provided;
                }
            } else if (this.providedStatusIterator.hasNext()) {
                status = this.providedStatusIterator.next();
                LOG.debug("Returning provided file status {}", (Object)status);
            } else {
                throw new NoSuchElementException();
            }
            return status;
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(S3ListResult objects) {
            int added = 0;
            int ignored = 0;
            ArrayList<S3AFileStatus> stats = new ArrayList<S3AFileStatus>(objects.getObjectSummaries().size() + objects.getCommonPrefixes().size());
            for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                String key = summary.getKey();
                Path keyPath = Listing.this.getStoreContext().getContextAccessors().keyToPath(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)S3AUtils.stringify(summary));
                }
                if (this.acceptor.accept(keyPath, summary) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = S3AUtils.createFileStatus(keyPath, summary, Listing.this.listingOperationCallbacks.getDefaultBlockSize(keyPath), Listing.this.getStoreContext().getUsername(), summary.getETag(), null, Listing.this.isCSEEnabled);
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (String prefix : objects.getCommonPrefixes()) {
                Path keyPath = Listing.this.getStoreContext().getContextAccessors().keyToPath(prefix);
                if (this.acceptor.accept(keyPath, prefix) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = new S3AFileStatus(Tristate.FALSE, keyPath, Listing.this.getStoreContext().getUsername());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public IOStatistics getIOStatistics() {
            return this.source.getIOStatistics();
        }

        public String toString() {
            return new StringJoiner(", ", FileStatusListingIterator.class.getSimpleName() + "[", "]").add(this.source.toString()).toString();
        }
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, S3ObjectSummary var2);

        public boolean accept(Path var1, String var2);

        public boolean accept(FileStatus var1);
    }
}

