/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractWindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.BulkloadPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.DataSourceScanPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.DistributeResultPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.EmptyTupleSourcePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IndexBulkloadPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IndexInsertDeleteUpsertPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InsertDeleteUpsertPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.IntersectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.LeftOuterUnnestPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroPreSortedDistinctByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroPreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroStableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.MicroUnionAllPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.NestedTupleSourcePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PreSortedDistinctByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RunningAggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SinkPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SinkWritePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SortForwardPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SplitPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamLimitPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamSelectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StringStreamingScriptPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SubplanPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.TokenizePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.UnionAllPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.UnnestPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WriteResultPOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.rewriter.util.JoinUtils;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;

public class SetAlgebricksPhysicalOperatorsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getPhysicalOperator() != null) {
            return false;
        }
        SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp(op, true, this.createPhysicalOperatorFactoryVisitor(context));
        return true;
    }

    private static void computeDefaultPhysicalOp(AbstractLogicalOperator op, boolean topLevelOp, ILogicalOperatorVisitor<IPhysicalOperator, Boolean> physOpFactory) throws AlgebricksException {
        if (op.getPhysicalOperator() == null) {
            IPhysicalOperator physOp = (IPhysicalOperator)op.accept(physOpFactory, (Object)topLevelOp);
            if (physOp == null) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.PHYS_OPERATOR_NOT_SET, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
            }
            op.setPhysicalOperator(physOp);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                for (Mutable root : p.getRoots()) {
                    SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)root.getValue(), false, physOpFactory);
                }
            }
        }
        for (Mutable opRef : op.getInputs()) {
            SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)opRef.getValue(), topLevelOp, physOpFactory);
        }
    }

    protected ILogicalOperatorVisitor<IPhysicalOperator, Boolean> createPhysicalOperatorFactoryVisitor(IOptimizationContext context) {
        return new AlgebricksPhysicalOperatorFactoryVisitor(context);
    }

    protected static class AlgebricksPhysicalOperatorFactoryVisitor
    implements ILogicalOperatorVisitor<IPhysicalOperator, Boolean> {
        protected final IOptimizationContext context;
        protected final PhysicalOptimizationConfig physConfig;

        protected AlgebricksPhysicalOperatorFactoryVisitor(IOptimizationContext context) {
            this.context = context;
            this.physConfig = context.getPhysicalOptimizationConfig();
        }

        public IPhysicalOperator visitAggregateOperator(AggregateOperator op, Boolean topLevelOp) {
            return new AggregatePOperator();
        }

        public IPhysicalOperator visitAssignOperator(AssignOperator op, Boolean topLevelOp) throws AlgebricksException {
            return new AssignPOperator();
        }

        public IPhysicalOperator visitDistinctOperator(DistinctOperator distinct, Boolean topLevelOp) {
            if (topLevelOp.booleanValue()) {
                return new PreSortedDistinctByPOperator(distinct.getDistinctByVarList());
            }
            return new MicroPreSortedDistinctByPOperator(distinct.getDistinctByVarList());
        }

        public IPhysicalOperator visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Boolean topLevelOp) {
            return new EmptyTupleSourcePOperator();
        }

        public final IPhysicalOperator visitGroupByOperator(GroupByOperator gby, Boolean topLevelOp) throws AlgebricksException {
            AlgebricksPhysicalOperatorFactoryVisitor.ensureAllVariables(gby.getGroupByList(), Pair::getSecond);
            if (gby.getNestedPlans().size() == 1 && ((ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().size() == 1 && topLevelOp.booleanValue() && (gby.getAnnotations().get("USE_HASH_GROUP_BY") == Boolean.TRUE || gby.getAnnotations().get("USE_EXTERNAL_GROUP_BY") == Boolean.TRUE)) {
                IWarningCollector warningCollector;
                ExternalGroupByPOperator extGby = this.createExternalGroupByPOperator(gby);
                if (extGby != null) {
                    return extGby;
                }
                if (gby.getSourceLocation() != null && (warningCollector = this.context.getWarningCollector()).shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)gby.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"Group By", "hash"}));
                }
            }
            if (topLevelOp.booleanValue()) {
                return new PreclusteredGroupByPOperator(gby.getGroupByVarList(), gby.isGroupAll());
            }
            return new MicroPreclusteredGroupByPOperator(gby.getGroupByVarList());
        }

        protected ExternalGroupByPOperator createExternalGroupByPOperator(GroupByOperator gby) throws AlgebricksException {
            boolean hasIntermediateAgg = this.generateMergeAggregationExpressions(gby);
            if (!hasIntermediateAgg) {
                return null;
            }
            return new ExternalGroupByPOperator(gby.getGroupByVarList());
        }

        public IPhysicalOperator visitInnerJoinOperator(InnerJoinOperator op, Boolean topLevelOp) throws AlgebricksException {
            return this.visitAbstractBinaryJoinOperator((AbstractBinaryJoinOperator)op, topLevelOp);
        }

        public IPhysicalOperator visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Boolean topLevelOp) throws AlgebricksException {
            return this.visitAbstractBinaryJoinOperator((AbstractBinaryJoinOperator)op, topLevelOp);
        }

        protected IPhysicalOperator visitAbstractBinaryJoinOperator(AbstractBinaryJoinOperator op, Boolean topLevelOp) throws AlgebricksException {
            if (!topLevelOp.booleanValue()) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.OPERATOR_NOT_IMPLEMENTED, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag().toString() + " (micro)"});
            }
            JoinUtils.setJoinAlgorithmAndExchangeAlgo(op, topLevelOp, this.context);
            return op.getPhysicalOperator();
        }

        public IPhysicalOperator visitLimitOperator(LimitOperator op, Boolean topLevelOp) {
            return new StreamLimitPOperator();
        }

        public IPhysicalOperator visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Boolean topLevelOp) {
            return new NestedTupleSourcePOperator();
        }

        public IPhysicalOperator visitOrderOperator(OrderOperator oo, Boolean topLevelOp) throws AlgebricksException {
            AlgebricksPhysicalOperatorFactoryVisitor.ensureAllVariables(oo.getOrderExpressions(), Pair::getSecond);
            if (topLevelOp.booleanValue()) {
                return new StableSortPOperator(oo.getTopK());
            }
            return new MicroStableSortPOperator();
        }

        public IPhysicalOperator visitProjectOperator(ProjectOperator op, Boolean topLevelOp) {
            return new StreamProjectPOperator();
        }

        public IPhysicalOperator visitRunningAggregateOperator(RunningAggregateOperator op, Boolean topLevelOp) {
            return new RunningAggregatePOperator();
        }

        public IPhysicalOperator visitReplicateOperator(ReplicateOperator op, Boolean topLevelOp) {
            return new ReplicatePOperator();
        }

        public IPhysicalOperator visitSplitOperator(SplitOperator op, Boolean topLevelOp) {
            return new SplitPOperator();
        }

        public IPhysicalOperator visitScriptOperator(ScriptOperator op, Boolean topLevelOp) {
            return new StringStreamingScriptPOperator();
        }

        public IPhysicalOperator visitSelectOperator(SelectOperator op, Boolean topLevelOp) {
            return new StreamSelectPOperator();
        }

        public IPhysicalOperator visitSubplanOperator(SubplanOperator op, Boolean topLevelOp) {
            return new SubplanPOperator();
        }

        public IPhysicalOperator visitUnionOperator(UnionAllOperator op, Boolean topLevelOp) {
            if (topLevelOp.booleanValue()) {
                return new UnionAllPOperator();
            }
            return new MicroUnionAllPOperator();
        }

        public IPhysicalOperator visitIntersectOperator(IntersectOperator op, Boolean topLevelOp) throws AlgebricksException {
            if (topLevelOp.booleanValue()) {
                return new IntersectPOperator();
            }
            throw AlgebricksException.create((ErrorCode)ErrorCode.OPERATOR_NOT_IMPLEMENTED, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag().toString() + " (micro)"});
        }

        public IPhysicalOperator visitUnnestOperator(UnnestOperator op, Boolean topLevelOp) {
            return new UnnestPOperator();
        }

        public IPhysicalOperator visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Boolean topLevelOp) {
            return new LeftOuterUnnestPOperator();
        }

        public IPhysicalOperator visitDataScanOperator(DataSourceScanOperator scan, Boolean topLevelOp) {
            IDataSource dataSource = scan.getDataSource();
            DataSourceScanPOperator dss = new DataSourceScanPOperator(dataSource);
            if (dataSource.isScanAccessPathALeaf()) {
                dss.disableJobGenBelowMe();
            }
            return dss;
        }

        public IPhysicalOperator visitWriteOperator(WriteOperator op, Boolean topLevelOp) {
            return new SinkWritePOperator();
        }

        public IPhysicalOperator visitDistributeResultOperator(DistributeResultOperator op, Boolean topLevelOp) {
            return new DistributeResultPOperator();
        }

        public IPhysicalOperator visitWriteResultOperator(WriteResultOperator opLoad, Boolean topLevelOp) {
            ArrayList<LogicalVariable> keys = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> additionalFilteringKeys = null;
            LogicalVariable payload = AlgebricksPhysicalOperatorFactoryVisitor.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getKeyExpressions(), keys);
            if (opLoad.getAdditionalFilteringExpressions() != null) {
                additionalFilteringKeys = new ArrayList<LogicalVariable>();
                AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opLoad.getAdditionalFilteringExpressions(), additionalFilteringKeys);
            }
            return new WriteResultPOperator(opLoad.getDataSource(), payload, keys, additionalFilteringKeys);
        }

        public IPhysicalOperator visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator opLoad, Boolean topLevelOp) {
            ArrayList<LogicalVariable> keys = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> additionalFilteringKeys = null;
            ArrayList<LogicalVariable> additionalNonFilterVariables = null;
            if (opLoad.getAdditionalNonFilteringExpressions() != null) {
                additionalNonFilterVariables = new ArrayList<LogicalVariable>();
                AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opLoad.getAdditionalNonFilteringExpressions(), additionalNonFilterVariables);
            }
            LogicalVariable payload = AlgebricksPhysicalOperatorFactoryVisitor.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getPrimaryKeyExpressions(), keys);
            if (opLoad.getAdditionalFilteringExpressions() != null) {
                additionalFilteringKeys = new ArrayList<LogicalVariable>();
                AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opLoad.getAdditionalFilteringExpressions(), additionalFilteringKeys);
            }
            if (opLoad.isBulkload()) {
                return new BulkloadPOperator(payload, keys, additionalFilteringKeys, additionalNonFilterVariables, opLoad.getDataSource());
            }
            return new InsertDeleteUpsertPOperator(payload, keys, additionalFilteringKeys, opLoad.getDataSource(), opLoad.getOperation(), additionalNonFilterVariables);
        }

        public IPhysicalOperator visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator opInsDel, Boolean topLevelOp) {
            ArrayList<LogicalVariable> primaryKeys = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> secondaryKeys = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> additionalFilteringKeys = null;
            AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opInsDel.getPrimaryKeyExpressions(), primaryKeys);
            AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opInsDel.getSecondaryKeyExpressions(), secondaryKeys);
            if (opInsDel.getAdditionalFilteringExpressions() != null) {
                additionalFilteringKeys = new ArrayList<LogicalVariable>();
                AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opInsDel.getAdditionalFilteringExpressions(), additionalFilteringKeys);
            }
            if (opInsDel.isBulkload()) {
                return new IndexBulkloadPOperator(primaryKeys, secondaryKeys, additionalFilteringKeys, opInsDel.getFilterExpression(), opInsDel.getDataSourceIndex());
            }
            LogicalVariable operationVar = null;
            ArrayList<LogicalVariable> prevSecondaryKeys = null;
            LogicalVariable prevAdditionalFilteringKey = null;
            if (opInsDel.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                operationVar = AlgebricksPhysicalOperatorFactoryVisitor.getKey((ILogicalExpression)opInsDel.getOperationExpr().getValue());
                prevSecondaryKeys = new ArrayList<LogicalVariable>();
                AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opInsDel.getPrevSecondaryKeyExprs(), prevSecondaryKeys);
                if (opInsDel.getPrevAdditionalFilteringExpression() != null) {
                    prevAdditionalFilteringKey = ((VariableReferenceExpression)opInsDel.getPrevAdditionalFilteringExpression().getValue()).getVariableReference();
                }
            }
            return new IndexInsertDeleteUpsertPOperator(primaryKeys, secondaryKeys, additionalFilteringKeys, opInsDel.getFilterExpression(), opInsDel.getBeforeOpFilterExpression(), opInsDel.getDataSourceIndex(), operationVar, prevSecondaryKeys, prevAdditionalFilteringKey, opInsDel.getNumberOfAdditionalNonFilteringFields());
        }

        public IPhysicalOperator visitTokenizeOperator(TokenizeOperator opTokenize, Boolean topLevelOp) throws AlgebricksException {
            ArrayList<LogicalVariable> primaryKeys = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> secondaryKeys = new ArrayList<LogicalVariable>();
            AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opTokenize.getPrimaryKeyExpressions(), primaryKeys);
            AlgebricksPhysicalOperatorFactoryVisitor.getKeys(opTokenize.getSecondaryKeyExpressions(), secondaryKeys);
            if (!opTokenize.isBulkload()) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.OPERATOR_NOT_IMPLEMENTED, (SourceLocation)opTokenize.getSourceLocation(), (Serializable[])new Serializable[]{opTokenize.getOperatorTag().toString() + " (no bulkload)"});
            }
            return new TokenizePOperator(primaryKeys, secondaryKeys, opTokenize.getDataSourceIndex());
        }

        public IPhysicalOperator visitSinkOperator(SinkOperator op, Boolean topLevelOp) {
            return new SinkPOperator();
        }

        public IPhysicalOperator visitForwardOperator(ForwardOperator op, Boolean topLevelOp) {
            return new SortForwardPOperator();
        }

        public final IPhysicalOperator visitWindowOperator(WindowOperator op, Boolean topLevelOp) throws AlgebricksException {
            AlgebricksPhysicalOperatorFactoryVisitor.ensureAllVariables(op.getPartitionExpressions(), v -> v);
            AlgebricksPhysicalOperatorFactoryVisitor.ensureAllVariables(op.getOrderExpressions(), Pair::getSecond);
            return this.createWindowPOperator(op);
        }

        protected AbstractWindowPOperator createWindowPOperator(WindowOperator op) throws AlgebricksException {
            return new WindowPOperator(op.getPartitionVarList(), op.getOrderColumnList(), false, false, false);
        }

        public IPhysicalOperator visitDelegateOperator(DelegateOperator op, Boolean topLevelOp) throws AlgebricksException {
            throw AlgebricksException.create((ErrorCode)ErrorCode.PHYS_OPERATOR_NOT_SET, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }

        public IPhysicalOperator visitExchangeOperator(ExchangeOperator op, Boolean topLevelOp) throws AlgebricksException {
            throw AlgebricksException.create((ErrorCode)ErrorCode.PHYS_OPERATOR_NOT_SET, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }

        public IPhysicalOperator visitMaterializeOperator(MaterializeOperator op, Boolean topLevelOp) throws AlgebricksException {
            throw AlgebricksException.create((ErrorCode)ErrorCode.PHYS_OPERATOR_NOT_SET, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }

        public IPhysicalOperator visitUnnestMapOperator(UnnestMapOperator op, Boolean topLevelOp) throws AlgebricksException {
            throw AlgebricksException.create((ErrorCode)ErrorCode.OPERATOR_NOT_IMPLEMENTED, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }

        public IPhysicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Boolean topLevelOp) throws AlgebricksException {
            throw AlgebricksException.create((ErrorCode)ErrorCode.OPERATOR_NOT_IMPLEMENTED, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }

        private static void getKeys(List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
            for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
                keys.add(AlgebricksPhysicalOperatorFactoryVisitor.getKey((ILogicalExpression)kExpr.getValue()));
            }
        }

        private static LogicalVariable getKey(ILogicalExpression keyExpression) {
            if (keyExpression.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new NotImplementedException();
            }
            return ((VariableReferenceExpression)keyExpression).getVariableReference();
        }

        private static LogicalVariable getKeysAndLoad(Mutable<ILogicalExpression> payloadExpr, List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
            if (((ILogicalExpression)payloadExpr.getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new NotImplementedException();
            }
            LogicalVariable payload = ((VariableReferenceExpression)payloadExpr.getValue()).getVariableReference();
            for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
                ILogicalExpression e = (ILogicalExpression)kExpr.getValue();
                if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    throw new NotImplementedException();
                }
                keys.add(((VariableReferenceExpression)e).getVariableReference());
            }
            return payload;
        }

        private boolean generateMergeAggregationExpressions(GroupByOperator gby) throws AlgebricksException {
            if (gby.getNestedPlans().size() != 1) {
                throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
            }
            ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
            if (p0.getRoots().size() != 1) {
                throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
            }
            IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = this.context.getMergeAggregationExpressionFactory();
            Mutable r0 = (Mutable)p0.getRoots().get(0);
            AbstractLogicalOperator r0Logical = (AbstractLogicalOperator)r0.getValue();
            if (r0Logical.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
                return false;
            }
            AbstractLogicalOperator r1Logical = r0Logical;
            while (r1Logical.hasInputs()) {
                if ((r1Logical = (ILogicalOperator)((Mutable)r1Logical.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) continue;
                return false;
            }
            AggregateOperator aggOp = (AggregateOperator)r0.getValue();
            List aggFuncRefs = aggOp.getExpressions();
            List originalAggVars = aggOp.getVariables();
            int n = aggOp.getExpressions().size();
            ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
            for (int i = 0; i < n; ++i) {
                ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)originalAggVars.get(i), (ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue(), this.context);
                if (mergeExpr == null) {
                    return false;
                }
                mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
            }
            aggOp.setMergeExpressions(mergeExpressionRefs);
            return true;
        }

        static <E> void ensureAllVariables(Collection<E> exprList, Function<E, Mutable<ILogicalExpression>> accessor) throws AlgebricksException {
            for (E item : exprList) {
                ILogicalExpression e = (ILogicalExpression)accessor.apply(item).getValue();
                if (e.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
                throw AlgebricksException.create((ErrorCode)ErrorCode.EXPR_NOT_NORMALIZED, (SourceLocation)e.getSourceLocation(), (Serializable[])new Serializable[0]);
            }
        }
    }
}

