/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.Objects;
import java.util.Optional;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.struct.UnaryExprType;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class UnaryExpr
extends AbstractExpression {
    private UnaryExprType unaryExprType;
    private Expression expr;

    public UnaryExpr() {
    }

    public UnaryExpr(UnaryExprType type, Expression expr) {
        this.unaryExprType = type;
        this.expr = expr;
    }

    public UnaryExprType getExprType() {
        return this.unaryExprType;
    }

    public void setExprType(String strType) throws CompilationException {
        Optional<UnaryExprType> exprType = UnaryExprType.fromSymbol(strType);
        if (!exprType.isPresent()) {
            throw new CompilationException("Unsupported operator: " + strType);
        }
        this.unaryExprType = exprType.get();
    }

    public Expression getExpr() {
        return this.expr;
    }

    public void setExpr(Expression expr) {
        this.expr = expr;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.UNARY_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expr, this.unaryExprType});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr target = (UnaryExpr)object;
        return Objects.equals(this.expr, target.expr) && Objects.equals((Object)this.unaryExprType, (Object)target.unaryExprType);
    }
}

