/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers.json.losslessadm;

import java.io.PrintStream;
import java.util.List;
import org.apache.asterix.formats.nontagged.LosslessADMJSONPrinterFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AUnionPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    private final AUnionType unionType;

    public AUnionPrinterFactory(AUnionType unionType) {
        this.unionType = unionType;
    }

    public IPrinter createPrinter() {
        return new IPrinter(){
            private IPrinter[] printers;
            private List<IAType> unionList;

            public void init() throws HyracksDataException {
                this.unionList = AUnionPrinterFactory.this.unionType.getUnionList();
                this.printers = new IPrinter[AUnionPrinterFactory.this.unionType.getUnionList().size()];
                for (int i = 0; i < this.printers.length; ++i) {
                    this.printers[i] = LosslessADMJSONPrinterFactoryProvider.INSTANCE.getPrinterFactory(AUnionPrinterFactory.this.unionType.getUnionList().get(i)).createPrinter();
                    this.printers[i].init();
                }
            }

            public void print(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
                ATypeTag tag = this.unionList.get(b[s + 1]).getTypeTag();
                if (tag == ATypeTag.UNION) {
                    this.printers[b[s + 1]].print(b, s + 1, l, ps);
                } else if (tag == ATypeTag.ANY) {
                    this.printers[b[s + 1]].print(b, s + 2, l, ps);
                } else {
                    this.printers[b[s + 1]].print(b, s + 1, l, ps);
                }
            }
        };
    }
}

