/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.function.BiFunction;

@FunctionalInterface
public interface ThrowingBiFunction<I, J, R> {
    public R process(I var1, J var2) throws Exception;

    public static <I, J, R> BiFunction<I, J, R> asUnchecked(ThrowingBiFunction<I, J, R> function) {
        return (p1, p2) -> {
            try {
                return function.process(p1, p2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
        };
    }
}

