/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAclOperationException;
import org.apache.hadoop.fs.permission.FsAction;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AbfsAclHelper {
    private AbfsAclHelper() {
    }

    public static Map<String, String> deserializeAclSpec(String aclSpecString) throws AzureBlobFileSystemException {
        String[] aceArray;
        HashMap<String, String> aclEntries = new HashMap<String, String>();
        for (String ace : aceArray = aclSpecString.split(",")) {
            int idx = ace.lastIndexOf(":");
            String key = ace.substring(0, idx);
            String val = ace.substring(idx + 1);
            if (aclEntries.containsKey(key)) {
                throw new InvalidAclOperationException("Duplicate acl entries are not allowed.");
            }
            aclEntries.put(key, val);
        }
        return aclEntries;
    }

    public static String serializeAclSpec(Map<String, String> aclEntries) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
            sb.append(aclEntry.getKey() + ":" + aclEntry.getValue() + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String processAclString(String aclSpecString) {
        List<String> aclEntries = Arrays.asList(aclSpecString.split(","));
        StringBuilder sb = new StringBuilder();
        boolean containsMask = false;
        for (int i = aclEntries.size() - 1; i >= 0; --i) {
            String ace = aclEntries.get(i);
            if (ace.startsWith("other:") || ace.startsWith("user::")) continue;
            if (ace.startsWith("mask:")) {
                containsMask = true;
                continue;
            }
            if (ace.startsWith("group::") && !containsMask) continue;
            sb.insert(0, ace + ",");
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    public static void removeAclEntriesInternal(Map<String, String> aclEntries, Map<String, String> toRemoveEntries) throws AzureBlobFileSystemException {
        boolean accessAclTouched = false;
        boolean defaultAclTouched = false;
        HashSet<String> removeIndicationSet = new HashSet<String>();
        for (String entryKey : toRemoveEntries.keySet()) {
            boolean isDefaultAcl;
            if (!AbfsAclHelper.removeNamedAceAndUpdateSet(entryKey, isDefaultAcl = AbfsAclHelper.isDefaultAce(entryKey), removeIndicationSet, aclEntries)) continue;
            if (isDefaultAcl) {
                defaultAclTouched = true;
                continue;
            }
            accessAclTouched = true;
        }
        if (removeIndicationSet.contains("mask:") && AbfsAclHelper.containsNamedAce(aclEntries, false)) {
            throw new InvalidAclOperationException("Access mask is required when a named access acl is present.");
        }
        if (accessAclTouched) {
            if (removeIndicationSet.contains("mask:")) {
                aclEntries.remove("mask:");
            }
            AbfsAclHelper.recalculateMask(aclEntries, false);
        }
        if (removeIndicationSet.contains("default:mask:") && AbfsAclHelper.containsNamedAce(aclEntries, true)) {
            throw new InvalidAclOperationException("Default mask is required when a named default acl is present.");
        }
        if (defaultAclTouched) {
            if (removeIndicationSet.contains("default:mask:")) {
                aclEntries.remove("default:mask:");
            }
            if (removeIndicationSet.contains("default:user:")) {
                aclEntries.put("default:user:", aclEntries.get("user:"));
            }
            if (removeIndicationSet.contains("default:group:")) {
                aclEntries.put("default:group:", aclEntries.get("group:"));
            }
            if (removeIndicationSet.contains("default:other:")) {
                aclEntries.put("default:other:", aclEntries.get("other:"));
            }
            AbfsAclHelper.recalculateMask(aclEntries, true);
        }
    }

    public static void modifyAclEntriesInternal(Map<String, String> aclEntries, Map<String, String> toModifyEntries) throws AzureBlobFileSystemException {
        boolean namedAccessAclTouched = false;
        boolean namedDefaultAclTouched = false;
        for (Map.Entry<String, String> toModifyEntry : toModifyEntries.entrySet()) {
            aclEntries.put(toModifyEntry.getKey(), toModifyEntry.getValue());
            if (!AbfsAclHelper.isNamedAce(toModifyEntry.getKey())) continue;
            if (AbfsAclHelper.isDefaultAce(toModifyEntry.getKey())) {
                namedDefaultAclTouched = true;
                continue;
            }
            namedAccessAclTouched = true;
        }
        if (!toModifyEntries.containsKey("mask:") && namedAccessAclTouched) {
            aclEntries.remove("mask:");
        }
        if (!toModifyEntries.containsKey("default:mask:") && namedDefaultAclTouched) {
            aclEntries.remove("default:mask:");
        }
    }

    public static void setAclEntriesInternal(Map<String, String> aclEntries, Map<String, String> getAclEntries) throws AzureBlobFileSystemException {
        boolean defaultAclTouched = false;
        for (String string : aclEntries.keySet()) {
            if (!AbfsAclHelper.isDefaultAce(string)) continue;
            defaultAclTouched = true;
            break;
        }
        for (Map.Entry entry : getAclEntries.entrySet()) {
            if (!AbfsAclHelper.isDefaultAce((String)entry.getKey()) || entry.getKey() == "default:mask:" && defaultAclTouched || aclEntries.containsKey(entry.getKey())) continue;
            aclEntries.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static boolean isUpnFormatAclEntries(Map<String, String> aclEntries) {
        for (Map.Entry<String, String> entry : aclEntries.entrySet()) {
            if (!entry.getKey().contains("@")) continue;
            return true;
        }
        return false;
    }

    private static boolean removeNamedAceAndUpdateSet(String entry, boolean isDefaultAcl, Set<String> removeIndicationSet, Map<String, String> aclEntries) throws AzureBlobFileSystemException {
        String tag;
        int startIndex = isDefaultAcl ? 1 : 0;
        String[] entryParts = entry.split(":");
        String string = tag = isDefaultAcl ? "default:" + entryParts[startIndex] + ":" : entryParts[startIndex] + ":";
        if (entry.equals("user:") || entry.equals("group:") || entry.equals("other:")) {
            throw new InvalidAclOperationException("Cannot remove user, group or other entry from access ACL.");
        }
        boolean touched = false;
        if (!AbfsAclHelper.isNamedAce(entry)) {
            removeIndicationSet.add(tag);
            touched = true;
        } else if (aclEntries.remove(entry) != null) {
            touched = true;
        }
        return touched;
    }

    private static void recalculateMask(Map<String, String> aclEntries, boolean isDefaultMask) {
        FsAction mask = FsAction.NONE;
        if (!AbfsAclHelper.isExtendAcl(aclEntries, isDefaultMask)) {
            return;
        }
        for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
            if (isDefaultMask) {
                if ((!AbfsAclHelper.isDefaultAce(aclEntry.getKey()) || !AbfsAclHelper.isNamedAce(aclEntry.getKey())) && !aclEntry.getKey().equals("default:group:")) continue;
                mask = mask.or(FsAction.getFsAction((String)aclEntry.getValue()));
                continue;
            }
            if ((AbfsAclHelper.isDefaultAce(aclEntry.getKey()) || !AbfsAclHelper.isNamedAce(aclEntry.getKey())) && !aclEntry.getKey().equals("group:")) continue;
            mask = mask.or(FsAction.getFsAction((String)aclEntry.getValue()));
        }
        aclEntries.put(isDefaultMask ? "default:mask:" : "mask:", mask.SYMBOL);
    }

    private static boolean isExtendAcl(Map<String, String> aclEntries, boolean checkDefault) {
        for (String entryKey : aclEntries.keySet()) {
            if (checkDefault && !entryKey.equals("default:user:") && !entryKey.equals("default:group:") && !entryKey.equals("default:other:") && AbfsAclHelper.isDefaultAce(entryKey)) {
                return true;
            }
            if (checkDefault || entryKey.equals("user:") || entryKey.equals("group:") || entryKey.equals("other:") || AbfsAclHelper.isDefaultAce(entryKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsNamedAce(Map<String, String> aclEntries, boolean checkDefault) {
        for (String entryKey : aclEntries.keySet()) {
            if (!AbfsAclHelper.isNamedAce(entryKey) || checkDefault != AbfsAclHelper.isDefaultAce(entryKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultAce(String entry) {
        return entry.startsWith("default:");
    }

    private static boolean isNamedAce(String entry) {
        return entry.charAt(entry.length() - 1) != ":".charAt(0);
    }
}

