/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.util.RangeMapBuilder;
import org.apache.asterix.lang.common.visitor.base.AbstractQueryExpressionVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.LoadableDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.functions.ExternalFunctionCompilerUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ConstantHelper;
import org.apache.asterix.translator.TranslationContext;
import org.apache.asterix.translator.util.PlanTranslationUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorDelegate;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.ManagedFileSplit;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

abstract class LangExpressionToPlanTranslator
extends AbstractQueryExpressionVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>>
implements ILangExpressionToPlanTranslator {
    protected final MetadataProvider metadataProvider;
    protected final TranslationContext context;
    private static final AtomicLong outputFileID = new AtomicLong(0L);
    private static final String OUTPUT_FILE_PREFIX = "OUTPUT_";

    public LangExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounterValue) throws AlgebricksException {
        this(metadataProvider, new Counter(currentVarCounterValue));
    }

    public LangExpressionToPlanTranslator(MetadataProvider metadataProvider, Counter currentVarCounter) throws AlgebricksException {
        this.context = new TranslationContext(currentVarCounter);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public int getVarCounter() {
        return this.context.getVarCounter();
    }

    @Override
    public ILogicalPlan translateLoad(CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        LoadableDataSource lds;
        CompiledStatements.CompiledLoadFromFileStatement clffs = (CompiledStatements.CompiledLoadFromFileStatement)stmt;
        SourceLocation sourceLoc = stmt.getSourceLocation();
        Dataset dataset = this.metadataProvider.findDataset(clffs.getDataverseName(), clffs.getDatasetName());
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{clffs.getDatasetName(), clffs.getDataverseName()});
        }
        IAType itemType = this.metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        IAType metaItemType = this.metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        DatasetDataSource targetDatasource = this.validateDatasetInfo(this.metadataProvider, stmt.getDataverseName(), stmt.getDatasetName(), sourceLoc);
        List partitionKeys = targetDatasource.getDataset().getPrimaryKeys();
        if (dataset.hasMetaPart()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{dataset.getDatasetName() + ": load " + IdentifierUtil.dataset() + " is not supported on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with meta records"});
        }
        try {
            lds = new LoadableDataSource(dataset, itemType, metaItemType, clffs.getAdapter(), clffs.getProperties());
        }
        catch (IOException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{e.toString(), e});
        }
        EmptyTupleSourceOperator etsOp = new EmptyTupleSourceOperator();
        ArrayList<LogicalVariable> payloadVars = new ArrayList<LogicalVariable>();
        payloadVars.add(this.context.newVar());
        DataSourceScanOperator dssOp = new DataSourceScanOperator(payloadVars, (IDataSource)lds);
        dssOp.getInputs().add(new MutableObject((Object)etsOp));
        dssOp.setSourceLocation(sourceLoc);
        VariableReferenceExpression payloadExpr = new VariableReferenceExpression((LogicalVariable)payloadVars.get(0));
        payloadExpr.setSourceLocation(sourceLoc);
        MutableObject payloadRef = new MutableObject((Object)payloadExpr);
        ArrayList<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> pkExprs = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> varRefsForLoading = new ArrayList<Mutable<ILogicalExpression>>();
        LogicalVariable payloadVar = (LogicalVariable)payloadVars.get(0);
        for (List keyFieldName : partitionKeys) {
            PlanTranslationUtil.prepareVarAndExpression(keyFieldName, payloadVar, pkVars, pkExprs, varRefsForLoading, this.context, sourceLoc);
        }
        AssignOperator assign = new AssignOperator(pkVars, pkExprs);
        assign.getInputs().add(new MutableObject((Object)dssOp));
        assign.setSourceLocation(sourceLoc);
        if (clffs.alreadySorted()) {
            ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
            for (int i = 0; i < pkVars.size(); ++i) {
                orderColumns.add(new OrderColumn(pkVars.get(i), OrderOperator.IOrder.OrderKind.ASC));
            }
            assign.setExplicitOrderingProperty(new LocalOrderProperty(orderColumns));
        }
        List additionalFilteringField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
        ArrayList<Mutable<ILogicalExpression>> additionalFilteringExpressions = null;
        AssignOperator additionalFilteringAssign = null;
        if (additionalFilteringField != null) {
            ArrayList<LogicalVariable> additionalFilteringVars = new ArrayList<LogicalVariable>();
            ArrayList<Mutable<ILogicalExpression>> additionalFilteringAssignExpressions = new ArrayList<Mutable<ILogicalExpression>>();
            additionalFilteringExpressions = new ArrayList<Mutable<ILogicalExpression>>();
            PlanTranslationUtil.prepareVarAndExpression(additionalFilteringField, payloadVar, additionalFilteringVars, additionalFilteringAssignExpressions, additionalFilteringExpressions, this.context, sourceLoc);
            additionalFilteringAssign = new AssignOperator(additionalFilteringVars, additionalFilteringAssignExpressions);
            additionalFilteringAssign.setSourceLocation(sourceLoc);
        }
        InsertDeleteUpsertOperator insertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, (Mutable)payloadRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.INSERT, true);
        insertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        insertOp.setSourceLocation(sourceLoc);
        if (additionalFilteringAssign != null) {
            additionalFilteringAssign.getInputs().add(new MutableObject((Object)assign));
            insertOp.getInputs().add(new MutableObject((Object)additionalFilteringAssign));
        } else {
            insertOp.getInputs().add(new MutableObject((Object)assign));
        }
        SinkOperator leafOperator = new SinkOperator();
        leafOperator.getInputs().add(new MutableObject((Object)insertOp));
        leafOperator.setSourceLocation(sourceLoc);
        return new ALogicalPlanImpl((Mutable)new MutableObject((Object)leafOperator));
    }

    @Override
    public ILogicalPlan translate(Query expr, String outputDatasetName, CompiledStatements.ICompiledDmlStatement stmt, IResultMetadata resultMetadata) throws AlgebricksException {
        return this.translate(expr, outputDatasetName, stmt, null, resultMetadata);
    }

    public ILogicalPlan translate(Query expr, String outputDatasetName, CompiledStatements.ICompiledDmlStatement stmt, ILogicalOperator baseOp, IResultMetadata resultMetadata) throws AlgebricksException {
        LogicalVariable unnestVar;
        MutableObject base = new MutableObject((Object)new EmptyTupleSourceOperator());
        if (baseOp != null) {
            base = new MutableObject((Object)baseOp);
        }
        SourceLocation sourceLoc = expr.getSourceLocation();
        Pair p = (Pair)expr.accept((ILangVisitor)this, (Object)base);
        ArrayList<MutableObject> globalPlanRoots = new ArrayList<MutableObject>();
        ILogicalOperator topOp = (ILogicalOperator)p.first;
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)topOp, liveVars);
        LogicalVariable resVar = unnestVar = (LogicalVariable)liveVars.get(0);
        if (outputDatasetName == null) {
            FileSplit outputFileSplit = this.metadataProvider.getOutputFile();
            if (outputFileSplit == null) {
                outputFileSplit = this.getDefaultOutputFileLocation(this.metadataProvider.getApplicationContext());
            }
            this.metadataProvider.setOutputFile(outputFileSplit);
            ArrayList<MutableObject> writeExprList = new ArrayList<MutableObject>(1);
            VariableReferenceExpression resVarRef = new VariableReferenceExpression(resVar);
            resVarRef.setSourceLocation(sourceLoc);
            writeExprList.add(new MutableObject((Object)resVarRef));
            ResultSetSinkId rssId = new ResultSetSinkId(this.metadataProvider.getResultSetId());
            ResultSetDataSink sink = new ResultSetDataSink(rssId, null);
            DistributeResultOperator newTop = new DistributeResultOperator(writeExprList, (IDataSink)sink, resultMetadata);
            newTop.setSourceLocation(sourceLoc);
            newTop.getInputs().add(new MutableObject((Object)topOp));
            topOp = newTop;
            ARecordType outputRecordType = this.metadataProvider.findOutputRecordType();
            if (outputRecordType != null) {
                topOp.getAnnotations().put("output-record-type", outputRecordType);
            }
        } else {
            ILogicalOperator leafOperator;
            LogicalVariable seqVar = this.context.newVar();
            VariableReferenceExpression resVarRef = new VariableReferenceExpression(resVar);
            resVarRef.setSourceLocation(sourceLoc);
            ScalarFunctionCallExpression collectionToSequenceExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.COLLECTION_TO_SEQUENCE), new Mutable[]{new MutableObject((Object)resVarRef)});
            collectionToSequenceExpr.setSourceLocation(sourceLoc);
            AssignOperator assignCollectionToSequence = new AssignOperator(seqVar, (Mutable)new MutableObject((Object)collectionToSequenceExpr));
            assignCollectionToSequence.setSourceLocation(sourceLoc);
            assignCollectionToSequence.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)topOp.getInputs().get(0)).getValue())));
            ((Mutable)topOp.getInputs().get(0)).setValue((Object)assignCollectionToSequence);
            ProjectOperator projectOperator = (ProjectOperator)topOp;
            projectOperator.getVariables().set(0, seqVar);
            DatasetDataSource targetDatasource = this.validateDatasetInfo(this.metadataProvider, stmt.getDataverseName(), stmt.getDatasetName(), sourceLoc);
            List keySourceIndicator = ((InternalDatasetDetails)targetDatasource.getDataset().getDatasetDetails()).getKeySourceIndicator();
            ArrayList<LogicalVariable> pkeyVars = new ArrayList<LogicalVariable>();
            ArrayList<Mutable<ILogicalExpression>> pkeyExprs = new ArrayList<Mutable<ILogicalExpression>>();
            ArrayList<Mutable<ILogicalExpression>> varRefsForLoading = new ArrayList<Mutable<ILogicalExpression>>();
            List partitionKeys = targetDatasource.getDataset().getPrimaryKeys();
            int numOfPrimaryKeys = partitionKeys.size();
            for (int i = 0; i < numOfPrimaryKeys; ++i) {
                if (keySourceIndicator == null || (Integer)keySourceIndicator.get(i) == 0) {
                    PlanTranslationUtil.prepareVarAndExpression((List)partitionKeys.get(i), seqVar, pkeyVars, pkeyExprs, varRefsForLoading, this.context, sourceLoc);
                    continue;
                }
                PlanTranslationUtil.prepareMetaKeyAccessExpression((List)partitionKeys.get(i), unnestVar, pkeyExprs, pkeyVars, varRefsForLoading, this.context, sourceLoc);
            }
            AssignOperator pkeyAssignOp = new AssignOperator(pkeyVars, pkeyExprs);
            pkeyAssignOp.setSourceLocation(sourceLoc);
            pkeyAssignOp.getInputs().add(new MutableObject((Object)topOp));
            VariableReferenceExpression seqVarRef = new VariableReferenceExpression(seqVar);
            seqVarRef.setSourceLocation(sourceLoc);
            MutableObject seqRef = new MutableObject((Object)seqVarRef);
            switch (stmt.getKind()) {
                case INSERT: {
                    leafOperator = this.translateInsert(targetDatasource, (Mutable<ILogicalExpression>)seqRef, varRefsForLoading, seqVar, (ILogicalOperator)pkeyAssignOp, stmt, resultMetadata);
                    break;
                }
                case UPSERT: {
                    leafOperator = this.translateUpsert(targetDatasource, (Mutable<ILogicalExpression>)seqRef, varRefsForLoading, (ILogicalOperator)pkeyAssignOp, unnestVar, topOp, pkeyExprs, seqVar, stmt, resultMetadata);
                    break;
                }
                case DELETE: {
                    leafOperator = this.translateDelete(targetDatasource, (Mutable<ILogicalExpression>)seqRef, varRefsForLoading, seqVar, (ILogicalOperator)pkeyAssignOp, stmt);
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unsupported statement kind " + stmt.getKind()});
                }
            }
            topOp = leafOperator;
        }
        globalPlanRoots.add(new MutableObject((Object)topOp));
        ALogicalPlanImpl plan = new ALogicalPlanImpl(globalPlanRoots);
        this.eliminateSharedOperatorReferenceForPlan((ILogicalPlan)plan);
        return plan;
    }

    protected ILogicalOperator translateDelete(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, LogicalVariable seqVar, ILogicalOperator pkeyAssignOp, CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        SourceLocation sourceLoc = stmt.getSourceLocation();
        if (targetDatasource.getDataset().hasMetaPart()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{targetDatasource.getDataset().getDatasetName() + ": delete from " + IdentifierUtil.dataset() + " is not supported on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with meta records"});
        }
        List filterField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
        List<Mutable<ILogicalExpression>> filterExprs = null;
        if (filterField != null) {
            filterExprs = this.generatedFilterExprs(pkeyAssignOp, filterField, seqVar, sourceLoc);
        }
        InsertDeleteUpsertOperator deleteOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.DELETE, false);
        deleteOp.setAdditionalFilteringExpressions(filterExprs);
        deleteOp.getInputs().add(new MutableObject((Object)pkeyAssignOp));
        deleteOp.setSourceLocation(sourceLoc);
        DelegateOperator leafOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(true));
        leafOperator.getInputs().add(new MutableObject((Object)deleteOp));
        leafOperator.setSourceLocation(sourceLoc);
        return leafOperator;
    }

    protected ILogicalOperator translateUpsert(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> payloadVarRef, List<Mutable<ILogicalExpression>> varRefsForLoading, ILogicalOperator pkeyAssignOp, LogicalVariable unnestVar, ILogicalOperator topOp, List<Mutable<ILogicalExpression>> pkeyExprs, LogicalVariable seqVar, CompiledStatements.ICompiledDmlStatement stmt, IResultMetadata resultMetadata) throws AlgebricksException {
        InsertDeleteUpsertOperator upsertOp;
        SourceLocation sourceLoc = stmt.getSourceLocation();
        if (!targetDatasource.getDataset().allow(topOp, (byte)3)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{targetDatasource.getDataset().getDatasetName() + ": upsert into " + IdentifierUtil.dataset() + " is not supported on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with meta records"});
        }
        ProjectOperator project = (ProjectOperator)topOp;
        CompiledStatements.CompiledUpsertStatement compiledUpsert = (CompiledStatements.CompiledUpsertStatement)stmt;
        Expression returnExpression = compiledUpsert.getReturnExpression();
        List filterField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
        if (targetDatasource.getDataset().hasMetaPart()) {
            if (returnExpression != null) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Returning not allowed on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with meta records"});
            }
            ArrayList<LogicalVariable> metaAndKeysVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> metaAndKeysExprs = new ArrayList<MutableObject>();
            BuiltinFunctionInfo finfoMeta = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.META);
            VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
            unnestVarRef.setSourceLocation(sourceLoc);
            ScalarFunctionCallExpression metaFunction = new ScalarFunctionCallExpression((IFunctionInfo)finfoMeta, new Mutable[]{new MutableObject((Object)unnestVarRef)});
            metaFunction.setSourceLocation(sourceLoc);
            LogicalVariable metaVar = this.context.newVar();
            VariableReferenceExpression metaVarRef = new VariableReferenceExpression(metaVar);
            metaVarRef.setSourceLocation(sourceLoc);
            metaAndKeysVars.add(metaVar);
            metaAndKeysExprs.add(new MutableObject((Object)metaFunction));
            project.getVariables().add(metaVar);
            varRefsForLoading.clear();
            for (Mutable<ILogicalExpression> assignExpr : pkeyExprs) {
                if (((ILogicalExpression)assignExpr.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression funcCall = (AbstractFunctionCallExpression)assignExpr.getValue();
                funcCall.substituteVar(seqVar, unnestVar);
                LogicalVariable pkVar = this.context.newVar();
                metaAndKeysVars.add(pkVar);
                metaAndKeysExprs.add(new MutableObject((Object)((ILogicalExpression)assignExpr.getValue())));
                project.getVariables().add(pkVar);
                varRefsForLoading.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(pkVar)));
            }
            upsertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, payloadVarRef, varRefsForLoading, Collections.singletonList(new MutableObject((Object)metaVarRef)), InsertDeleteUpsertOperator.Kind.UPSERT, false);
            upsertOp.setOperationVar(this.context.newVar());
            upsertOp.setOperationVarType((Object)BuiltinType.AINT8);
            upsertOp.setPrevRecordVar(this.context.newVar());
            upsertOp.setPrevRecordType((Object)targetDatasource.getItemType());
            upsertOp.setSourceLocation(sourceLoc);
            ArrayList<LogicalVariable> metaVars = new ArrayList<LogicalVariable>();
            metaVars.add(this.context.newVar());
            upsertOp.setPrevAdditionalNonFilteringVars(metaVars);
            ArrayList<IAType> metaTypes = new ArrayList<IAType>();
            metaTypes.add(targetDatasource.getMetaItemType());
            upsertOp.setPrevAdditionalNonFilteringTypes(metaTypes);
            AssignOperator metaAndKeysAssign = new AssignOperator(metaAndKeysVars, metaAndKeysExprs);
            metaAndKeysAssign.getInputs().add((Mutable)topOp.getInputs().get(0));
            metaAndKeysAssign.setSourceLocation(sourceLoc);
            topOp.getInputs().set(0, new MutableObject((Object)metaAndKeysAssign));
            if (filterField != null) {
                LogicalVariable filterSourceVar = DatasetUtil.getFilterSourceIndicator((Dataset)targetDatasource.getDataset()) == 0 ? seqVar : metaVar;
                ARecordType filterSourceType = DatasetUtil.getFilterSourceIndicator((Dataset)targetDatasource.getDataset()) == 0 ? (ARecordType)targetDatasource.getItemType() : (ARecordType)targetDatasource.getMetaItemType();
                List<Mutable<ILogicalExpression>> filterExprs = this.generatedFilterExprs(pkeyAssignOp, filterField, filterSourceVar, sourceLoc);
                upsertOp.setPrevFilterVar(this.context.newVar());
                upsertOp.setPrevFilterType((Object)filterSourceType.getFieldType((String)filterField.get(0)));
                upsertOp.setAdditionalFilteringExpressions(filterExprs);
                upsertOp.getInputs().add((Mutable)pkeyAssignOp.getInputs().get(0));
            } else {
                upsertOp.getInputs().add(new MutableObject((Object)topOp));
                upsertOp.setAdditionalFilteringExpressions(null);
            }
        } else {
            ARecordType recordType = (ARecordType)targetDatasource.getItemType();
            List<Mutable<ILogicalExpression>> filterExprs = null;
            upsertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, payloadVarRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.UPSERT, false);
            if (filterField != null) {
                filterExprs = this.generatedFilterExprs(pkeyAssignOp, filterField, seqVar, sourceLoc);
                upsertOp.setPrevFilterVar(this.context.newVar());
                upsertOp.setPrevFilterType((Object)recordType.getFieldType((String)filterField.get(0)));
            }
            upsertOp.getInputs().add(new MutableObject((Object)pkeyAssignOp));
            upsertOp.setAdditionalFilteringExpressions(filterExprs);
            upsertOp.setSourceLocation(sourceLoc);
            upsertOp.setOperationVar(this.context.newVar());
            upsertOp.setOperationVarType((Object)BuiltinType.AINT8);
            upsertOp.setPrevRecordVar(this.context.newVar());
            upsertOp.setPrevRecordType((Object)recordType);
        }
        DelegateOperator delegateOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(returnExpression == null));
        delegateOperator.getInputs().add(new MutableObject((Object)upsertOp));
        delegateOperator.setSourceLocation(sourceLoc);
        DelegateOperator rootOperator = delegateOperator;
        return this.processReturningExpression((ILogicalOperator)rootOperator, upsertOp, compiledUpsert, resultMetadata);
    }

    protected ILogicalOperator translateInsert(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, LogicalVariable seqVar, ILogicalOperator pkeyAssignOp, CompiledStatements.ICompiledDmlStatement stmt, IResultMetadata resultMetadata) throws AlgebricksException {
        SourceLocation sourceLoc = stmt.getSourceLocation();
        if (targetDatasource.getDataset().hasMetaPart()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{targetDatasource.getDataset().getDatasetName() + ": insert into " + IdentifierUtil.dataset() + " is not supported on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with meta records"});
        }
        List filterField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
        List<Mutable<ILogicalExpression>> filterExprs = null;
        if (filterField != null) {
            filterExprs = this.generatedFilterExprs(pkeyAssignOp, filterField, seqVar, sourceLoc);
        }
        InsertDeleteUpsertOperator insertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.INSERT, false);
        insertOp.setAdditionalFilteringExpressions(filterExprs);
        insertOp.getInputs().add(new MutableObject((Object)pkeyAssignOp));
        insertOp.setSourceLocation(sourceLoc);
        CompiledStatements.CompiledInsertStatement compiledInsert = (CompiledStatements.CompiledInsertStatement)stmt;
        Expression returnExpression = compiledInsert.getReturnExpression();
        DelegateOperator rootOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(returnExpression == null));
        rootOperator.getInputs().add(new MutableObject((Object)insertOp));
        rootOperator.setSourceLocation(sourceLoc);
        return this.processReturningExpression((ILogicalOperator)rootOperator, insertOp, compiledInsert, resultMetadata);
    }

    protected List<Mutable<ILogicalExpression>> generatedFilterExprs(ILogicalOperator pkeyAssignOp, List<String> filterField, LogicalVariable seqVar, SourceLocation sourceLoc) {
        ArrayList<LogicalVariable> filterVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> filterAssignExprs = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> filterExprs = new ArrayList<Mutable<ILogicalExpression>>();
        PlanTranslationUtil.prepareVarAndExpression(filterField, seqVar, filterVars, filterAssignExprs, filterExprs, this.context, sourceLoc);
        AssignOperator additionalFilteringAssign = new AssignOperator(filterVars, filterAssignExprs);
        additionalFilteringAssign.getInputs().add((Mutable)pkeyAssignOp.getInputs().get(0));
        additionalFilteringAssign.setSourceLocation(sourceLoc);
        pkeyAssignOp.getInputs().set(0, new MutableObject((Object)additionalFilteringAssign));
        return filterExprs;
    }

    protected ILogicalOperator processReturningExpression(ILogicalOperator inputOperator, InsertDeleteUpsertOperator insertOp, CompiledStatements.CompiledInsertStatement compiledInsert, IResultMetadata resultMetadata) throws AlgebricksException {
        Expression returnExpression = compiledInsert.getReturnExpression();
        if (returnExpression == null) {
            return inputOperator;
        }
        SourceLocation sourceLoc = compiledInsert.getSourceLocation();
        LogicalVariable insertedVar = this.context.newVar();
        AssignOperator insertedVarAssignOperator = new AssignOperator(insertedVar, (Mutable)new MutableObject((Object)((ILogicalExpression)insertOp.getPayloadExpression().getValue()).cloneExpression()));
        insertedVarAssignOperator.getInputs().add((Mutable)insertOp.getInputs().get(0));
        insertedVarAssignOperator.setSourceLocation(sourceLoc);
        insertOp.getInputs().set(0, new MutableObject((Object)insertedVarAssignOperator));
        this.context.newVarFromExpression((Expression)compiledInsert.getVar());
        this.context.setVar(compiledInsert.getVar(), insertedVar);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(returnExpression, (Mutable<ILogicalOperator>)new MutableObject((Object)inputOperator));
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator createResultAssignOperator = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)((ILogicalExpression)p.first)));
        createResultAssignOperator.getInputs().add((Mutable)p.second);
        createResultAssignOperator.setSourceLocation(sourceLoc);
        ArrayList<MutableObject> expressions = new ArrayList<MutableObject>();
        expressions.add(new MutableObject((Object)new VariableReferenceExpression(resultVar)));
        ResultSetSinkId rssId = new ResultSetSinkId(this.metadataProvider.getResultSetId());
        ResultSetDataSink sink = new ResultSetDataSink(rssId, null);
        DistributeResultOperator distResultOperator = new DistributeResultOperator(expressions, (IDataSink)sink, resultMetadata);
        distResultOperator.getInputs().add(new MutableObject((Object)createResultAssignOperator));
        distResultOperator.setSourceLocation(sourceLoc);
        return distResultOperator;
    }

    protected DatasetDataSource validateDatasetInfo(MetadataProvider metadataProvider, DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) throws AlgebricksException {
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, dataverseName});
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Cannot write output to an external " + IdentifierUtil.dataset()});
        }
        DataSourceId sourceId = new DataSourceId(dataverseName, datasetName);
        IAType itemType = metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        IAType metaItemType = metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        INodeDomain domain = metadataProvider.findNodeDomain(dataset.getNodeGroupName());
        return new DatasetDataSource(sourceId, dataset, itemType, metaItemType, 0, dataset.getDatasetDetails(), domain);
    }

    protected FileSplit getDefaultOutputFileLocation(ICcApplicationContext appCtx) throws AlgebricksException {
        String outputDir = System.getProperty("java.io.tmpDir");
        String filePath = outputDir + System.getProperty("file.separator") + OUTPUT_FILE_PREFIX + outputFileID.incrementAndGet();
        MetadataProperties metadataProperties = appCtx.getMetadataProperties();
        return new ManagedFileSplit(metadataProperties.getMetadataNodeName(), filePath);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LetClause lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        AssignOperator returnedOp;
        LogicalVariable v;
        Expression bindingExpr = lc.getBindingExpr();
        SourceLocation sourceLoc = bindingExpr.getSourceLocation();
        if (bindingExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            VariableExpr bindingVarExpr = (VariableExpr)bindingExpr;
            ILogicalExpression prevVarRef = this.translateVariableRef(bindingVarExpr);
            v = this.context.newVarFromExpression((Expression)lc.getVarExpr());
            returnedOp = new AssignOperator(v, (Mutable)new MutableObject((Object)prevVarRef));
            returnedOp.getInputs().add(tupSource);
            returnedOp.setSourceLocation(sourceLoc);
        } else {
            v = this.context.newVarFromExpression((Expression)lc.getVarExpr());
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(bindingExpr, tupSource);
            returnedOp = new AssignOperator(v, (Mutable)new MutableObject((Object)((ILogicalExpression)eo.first)));
            returnedOp.getInputs().add((Mutable)eo.second);
            returnedOp.setSourceLocation(sourceLoc);
        }
        return new Pair((Object)returnedOp, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FieldAccessor fa, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SourceLocation sourceLoc = fa.getSourceLocation();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(fa.getExpr(), tupSource);
        LogicalVariable v = this.context.newVarFromExpression((Expression)fa);
        ScalarFunctionCallExpression fldAccess = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME));
        fldAccess.setSourceLocation(sourceLoc);
        fldAccess.getArguments().add(new MutableObject((Object)((ILogicalExpression)p.first)));
        ConstantExpression faExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(fa.getIdent().getValue())));
        faExpr.setSourceLocation(sourceLoc);
        fldAccess.getArguments().add(new MutableObject((Object)faExpr));
        AssignOperator a = new AssignOperator(v, (Mutable)new MutableObject((Object)fldAccess));
        a.getInputs().add((Mutable)p.second);
        a.setSourceLocation(sourceLoc);
        return new Pair((Object)a, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(IndexAccessor ia, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Mutable assignInput;
        ILogicalExpression farg0;
        FunctionIdentifier fid;
        SourceLocation sourceLoc = ia.getSourceLocation();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> expressionPair = this.langExprToAlgExpression(ia.getExpr(), tupSource);
        LogicalVariable v = this.context.newVar();
        ILogicalExpression farg1 = null;
        switch (ia.getIndexKind()) {
            case ANY: {
                fid = BuiltinFunctions.ANY_COLLECTION_MEMBER;
                farg0 = (ILogicalExpression)expressionPair.first;
                assignInput = (Mutable)expressionPair.second;
                break;
            }
            case STAR: {
                fid = BuiltinFunctions.ARRAY_STAR;
                farg0 = (ILogicalExpression)expressionPair.first;
                assignInput = (Mutable)expressionPair.second;
                break;
            }
            case ELEMENT: {
                Pair<ILogicalExpression, Mutable<ILogicalOperator>> indexPair = this.langExprToAlgExpression(ia.getIndexExpr(), (Mutable<ILogicalOperator>)((Mutable)expressionPair.second));
                fid = BuiltinFunctions.GET_ITEM;
                farg0 = (ILogicalExpression)expressionPair.first;
                farg1 = (ILogicalExpression)indexPair.first;
                assignInput = (Mutable)indexPair.second;
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, ia.getSourceLocation(), new Serializable[]{ia.getIndexKind()});
            }
        }
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fid));
        f.setSourceLocation(sourceLoc);
        f.getArguments().add(new MutableObject((Object)farg0));
        if (farg1 != null) {
            f.getArguments().add(new MutableObject((Object)farg1));
        }
        AssignOperator a = new AssignOperator(v, (Mutable)new MutableObject((Object)f));
        a.setSourceLocation(sourceLoc);
        a.getInputs().add(assignInput);
        return new Pair((Object)a, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(ListSliceExpression expression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ScalarFunctionCallExpression functionCallExpression;
        SourceLocation sourceLoc = expression.getSourceLocation();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> expressionPair = this.langExprToAlgExpression(expression.getExpr(), tupSource);
        LogicalVariable variable = this.context.newVar();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> startIndexPair = this.langExprToAlgExpression(expression.getStartIndexExpression(), (Mutable<ILogicalOperator>)((Mutable)expressionPair.second));
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> endIndexPair = null;
        if (expression.hasEndExpression()) {
            endIndexPair = this.langExprToAlgExpression(expression.getEndIndexExpression(), (Mutable<ILogicalOperator>)((Mutable)startIndexPair.second));
            functionCallExpression = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.ARRAY_SLICE_WITH_END_POSITION));
            functionCallExpression.getArguments().add(new MutableObject((Object)((ILogicalExpression)expressionPair.first)));
            functionCallExpression.getArguments().add(new MutableObject((Object)((ILogicalExpression)startIndexPair.first)));
            functionCallExpression.getArguments().add(new MutableObject((Object)((ILogicalExpression)endIndexPair.first)));
            functionCallExpression.setSourceLocation(sourceLoc);
        } else {
            functionCallExpression = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.ARRAY_SLICE_WITHOUT_END_POSITION));
            functionCallExpression.getArguments().add(new MutableObject((Object)((ILogicalExpression)expressionPair.first)));
            functionCallExpression.getArguments().add(new MutableObject((Object)((ILogicalExpression)startIndexPair.first)));
            functionCallExpression.setSourceLocation(sourceLoc);
        }
        AssignOperator assignOperator = new AssignOperator(variable, (Mutable)new MutableObject((Object)functionCallExpression));
        if (expression.hasEndExpression()) {
            assignOperator.getInputs().add((Mutable)endIndexPair.second);
        } else {
            assignOperator.getInputs().add((Mutable)startIndexPair.second);
        }
        assignOperator.setSourceLocation(sourceLoc);
        return new Pair((Object)assignOperator, (Object)variable);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(CallExpr fcall, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        LogicalVariable v = this.context.newVar();
        FunctionSignature signature = fcall.getFunctionSignature();
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        Mutable topOp = tupSource;
        block4: for (Expression expr : fcall.getExprList()) {
            switch (expr.getKind()) {
                case VARIABLE_EXPRESSION: {
                    VariableExpr varExpr = (VariableExpr)expr;
                    ILogicalExpression varRefExpr = this.translateVariableRef(varExpr);
                    args.add((Mutable<ILogicalExpression>)new MutableObject((Object)varRefExpr));
                    continue block4;
                }
                case LITERAL_EXPRESSION: {
                    LiteralExpr val = (LiteralExpr)expr;
                    AsterixConstantValue cValue = new AsterixConstantValue(ConstantHelper.objectFromLiteral(val.getValue()));
                    ConstantExpression cExpr = new ConstantExpression((IAlgebricksConstantValue)cValue);
                    cExpr.setSourceLocation(expr.getSourceLocation());
                    args.add((Mutable<ILogicalExpression>)new MutableObject((Object)cExpr));
                    continue block4;
                }
            }
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(expr, topOp);
            AbstractLogicalOperator o1 = (AbstractLogicalOperator)((Mutable)eo.second).getValue();
            args.add((Mutable<ILogicalExpression>)new MutableObject((Object)((ILogicalExpression)eo.first)));
            if (o1 == null) continue;
            topOp = (Mutable)eo.second;
        }
        SourceLocation sourceLoc = fcall.getSourceLocation();
        AbstractFunctionCallExpression f = this.lookupFunction(signature, args, sourceLoc);
        if (f == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, sourceLoc, new Serializable[]{signature.toString()});
        }
        if (fcall.hasAggregateFilterExpr()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_FILTER_CLAUSE, sourceLoc, new Serializable[0]);
        }
        if (fcall.hasHints()) {
            f.putAnnotations((Collection)fcall.getHints());
        }
        AssignOperator op = new AssignOperator(v, (Mutable)new MutableObject((Object)f));
        if (topOp != null) {
            op.getInputs().add(topOp);
        }
        op.setSourceLocation(sourceLoc);
        return new Pair((Object)op, (Object)v);
    }

    protected ILogicalExpression translateVariableRef(VariableExpr varExpr) throws CompilationException {
        LogicalVariable var = this.context.getVar(varExpr.getVar().getId());
        if (var == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, varExpr.getSourceLocation(), new Serializable[]{varExpr.toString()});
        }
        VariableReferenceExpression varRef = new VariableReferenceExpression(var);
        varRef.setSourceLocation(varExpr.getSourceLocation());
        return varRef;
    }

    protected AbstractFunctionCallExpression lookupFunction(FunctionSignature signature, List<Mutable<ILogicalExpression>> args, SourceLocation sourceLoc) throws CompilationException {
        AbstractFunctionCallExpression f = this.lookupUserDefinedFunction(signature, args, sourceLoc);
        if (f == null) {
            f = this.lookupBuiltinFunction(signature, args, sourceLoc);
        }
        return f;
    }

    private AbstractFunctionCallExpression lookupUserDefinedFunction(FunctionSignature signature, List<Mutable<ILogicalExpression>> args, SourceLocation sourceLoc) throws CompilationException {
        try {
            Function function = this.metadataProvider.lookupUserDefinedFunction(signature);
            if (function == null) {
                return null;
            }
            if (!function.isExternal()) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{signature});
            }
            IFunctionInfo finfo = ExternalFunctionCompilerUtil.getExternalFunctionInfo((MetadataProvider)this.metadataProvider, (Function)function);
            ScalarFunctionCallExpression f = new ScalarFunctionCallExpression(finfo, args);
            f.setSourceLocation(sourceLoc);
            return f;
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (AlgebricksException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }

    private AbstractFunctionCallExpression lookupBuiltinFunction(FunctionSignature signature, List<Mutable<ILogicalExpression>> args, SourceLocation sourceLoc) throws CompilationException {
        AggregateFunctionCallExpression f;
        FunctionIdentifier fi = signature.createFunctionIdentifier();
        if (BuiltinFunctions.isBuiltinAggregateFunction((FunctionIdentifier)fi)) {
            f = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)fi, args);
        } else if (BuiltinFunctions.isBuiltinUnnestingFunction((FunctionIdentifier)fi)) {
            UnnestingFunctionCallExpression ufce = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)fi), args);
            ufce.setReturnsUniqueValues(BuiltinFunctions.returnsUniqueValues((FunctionIdentifier)fi));
            f = ufce;
        } else if (BuiltinFunctions.isWindowFunction((FunctionIdentifier)fi)) {
            f = BuiltinFunctions.makeWindowFunctionExpression((FunctionIdentifier)fi, args);
        } else {
            BuiltinFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)fi);
            if (finfo == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{fi});
            }
            f = new ScalarFunctionCallExpression((IFunctionInfo)finfo, args);
        }
        f.setSourceLocation(sourceLoc);
        return f;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FunctionDecl fd, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fd.getSourceLocation(), new Serializable[]{fd.getSignature()});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(ViewDecl vd, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, vd.getSourceLocation(), new Serializable[]{vd.getViewName()});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(GroupbyClause gc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SourceLocation sourceLoc = gc.getSourceLocation();
        MutableObject topOp = tupSource;
        LogicalVariable groupRecordVar = null;
        if (gc.hasGroupVar()) {
            groupRecordVar = this.context.newVar();
            AbstractFunctionCallExpression groupRecordConstr = this.createRecordConstructor(gc.getGroupFieldList(), (Mutable<ILogicalOperator>)topOp, sourceLoc);
            AssignOperator groupRecordVarAssignOp = new AssignOperator(groupRecordVar, (Mutable)new MutableObject((Object)groupRecordConstr));
            groupRecordVarAssignOp.getInputs().add(topOp);
            groupRecordVarAssignOp.setSourceLocation(sourceLoc);
            topOp = new MutableObject((Object)groupRecordVarAssignOp);
        }
        boolean propagateHashHint = true;
        GroupByOperator gOp = new GroupByOperator();
        if (!gc.isGroupAll()) {
            List<GbyVariableExpressionPair> groupingSet = this.getSingleGroupingSet(gc);
            if (groupingSet.isEmpty()) {
                gOp.addGbyExpression(this.context.newVar(), (ILogicalExpression)ConstantExpression.TRUE);
                propagateHashHint = false;
            } else {
                for (GbyVariableExpressionPair ve : groupingSet) {
                    VariableExpr vexpr = ve.getVar();
                    LogicalVariable v = vexpr == null ? this.context.newVar() : this.context.newVarFromExpression((Expression)vexpr);
                    Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(ve.getExpr(), (Mutable<ILogicalOperator>)topOp);
                    gOp.addGbyExpression(v, (ILogicalExpression)eo.first);
                    topOp = (Mutable)eo.second;
                }
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair ve : gc.getDecorPairList()) {
                VariableExpr vexpr = ve.getVar();
                LogicalVariable v = vexpr == null ? this.context.newVar() : this.context.newVarFromExpression((Expression)vexpr);
                Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(ve.getExpr(), (Mutable<ILogicalOperator>)topOp);
                gOp.addDecorExpression(v, (ILogicalExpression)eo.first);
                topOp = (Mutable)eo.second;
            }
        }
        gOp.getInputs().add(topOp);
        if (gc.hasGroupVar()) {
            VariableExpr groupVar = gc.getGroupVar();
            LogicalVariable groupLogicalVar = this.context.newVar();
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)gOp));
            ntsOp.setSourceLocation(sourceLoc);
            VariableReferenceExpression groupRecordVarRef = new VariableReferenceExpression(groupRecordVar);
            groupRecordVarRef.setSourceLocation(sourceLoc);
            ILogicalPlan nestedPlan = this.createNestedPlanWithAggregate(groupLogicalVar, BuiltinFunctions.LISTIFY, (ILogicalExpression)groupRecordVarRef, (Mutable<ILogicalOperator>)new MutableObject((Object)ntsOp));
            gOp.getNestedPlans().add(nestedPlan);
            this.context.setVar(groupVar, groupLogicalVar);
        }
        if (gc.hasWithMap()) {
            for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
                VariableExpr withVar = (VariableExpr)entry.getValue();
                Expression withExpr = (Expression)entry.getKey();
                NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)gOp));
                ntsOp.setSourceLocation(sourceLoc);
                Pair<ILogicalExpression, Mutable<ILogicalOperator>> listifyInput = this.langExprToAlgExpression(withExpr, (Mutable<ILogicalOperator>)new MutableObject((Object)ntsOp));
                LogicalVariable withLogicalVar = this.context.newVar();
                ILogicalPlan nestedPlan = this.createNestedPlanWithAggregate(withLogicalVar, BuiltinFunctions.LISTIFY, (ILogicalExpression)listifyInput.first, (Mutable<ILogicalOperator>)((Mutable)listifyInput.second));
                gOp.getNestedPlans().add(nestedPlan);
                this.context.setVar(withVar, withLogicalVar);
            }
        }
        gOp.setGroupAll(gc.isGroupAll());
        if (propagateHashHint) {
            gOp.getAnnotations().put("USE_HASH_GROUP_BY", gc.hasHashGroupByHint());
        }
        gOp.setSourceLocation(sourceLoc);
        return new Pair((Object)gOp, null);
    }

    protected List<GbyVariableExpressionPair> getSingleGroupingSet(GroupbyClause gby) throws CompilationException {
        List groupingSetList = gby.getGbyPairList();
        if (groupingSetList.size() != 1) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, gby.getSourceLocation(), new Serializable[]{String.valueOf(groupingSetList.size())});
        }
        return (List)groupingSetList.get(0);
    }

    protected AbstractFunctionCallExpression createRecordConstructor(List<Pair<Expression, Identifier>> fieldList, Mutable<ILogicalOperator> inputOp, SourceLocation sourceLoc) throws CompilationException {
        ArrayList<MutableObject> args = new ArrayList<MutableObject>();
        for (Pair<Expression, Identifier> field : fieldList) {
            ILogicalExpression fieldNameExpr = (ILogicalExpression)this.langExprToAlgExpression((Expression)new LiteralExpr((Literal)new StringLiteral((String)((Identifier)field.second).getValue())), inputOp).first;
            args.add(new MutableObject((Object)fieldNameExpr));
            ILogicalExpression fieldExpr = (ILogicalExpression)this.langExprToAlgExpression((Expression)((Expression)field.first), inputOp).first;
            args.add(new MutableObject((Object)fieldExpr));
        }
        ScalarFunctionCallExpression recordConstr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), args);
        recordConstr.setSourceLocation(sourceLoc);
        return recordConstr;
    }

    protected ILogicalPlan createNestedPlanWithAggregate(LogicalVariable aggOutputVar, FunctionIdentifier aggFunc, ILogicalExpression aggFnInput, Mutable<ILogicalOperator> aggOpInput) {
        SourceLocation sourceLoc = aggFnInput.getSourceLocation();
        AggregateFunctionCallExpression aggFnCall = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)aggFunc, this.mkSingletonArrayList(new MutableObject((Object)aggFnInput)));
        aggFnCall.setSourceLocation(sourceLoc);
        AggregateOperator aggOp = new AggregateOperator(this.mkSingletonArrayList(aggOutputVar), this.mkSingletonArrayList(new MutableObject((Object)aggFnCall)));
        aggOp.getInputs().add(aggOpInput);
        aggOp.setSourceLocation(sourceLoc);
        return new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(IfExpr ifexpr, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Expression condExpr = ifexpr.getCondExpr();
        Expression thenExpr = ifexpr.getThenExpr();
        Expression elseExpr = ifexpr.getElseExpr();
        Pair pCond = (Pair)condExpr.accept((ILangVisitor)this, tupSource);
        LogicalVariable varCond = (LogicalVariable)pCond.second;
        VariableReferenceExpression varCondRef1 = new VariableReferenceExpression(varCond);
        varCondRef1.setSourceLocation(condExpr.getSourceLocation());
        Pair<ILogicalOperator, LogicalVariable> opAndVarForThen = this.constructSubplanOperatorForBranch((ILogicalOperator)pCond.first, (Mutable<ILogicalExpression>)new MutableObject((Object)varCondRef1), thenExpr);
        VariableReferenceExpression varCondRef2 = new VariableReferenceExpression(varCond);
        varCondRef2.setSourceLocation(condExpr.getSourceLocation());
        ScalarFunctionCallExpression notVarCond = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.NOT), Collections.singletonList(this.generateAndNotIsUnknownWrap((ILogicalExpression)varCondRef2)));
        notVarCond.setSourceLocation(condExpr.getSourceLocation());
        Pair<ILogicalOperator, LogicalVariable> opAndVarForElse = this.constructSubplanOperatorForBranch((ILogicalOperator)opAndVarForThen.first, (Mutable<ILogicalExpression>)new MutableObject((Object)notVarCond), elseExpr);
        LogicalVariable selectVar = this.context.newVar();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        VariableReferenceExpression varCondRef3 = new VariableReferenceExpression(varCond);
        varCondRef3.setSourceLocation(condExpr.getSourceLocation());
        VariableReferenceExpression varThenRef = new VariableReferenceExpression((LogicalVariable)opAndVarForThen.second);
        varThenRef.setSourceLocation(thenExpr.getSourceLocation());
        VariableReferenceExpression varElseRef = new VariableReferenceExpression((LogicalVariable)opAndVarForElse.second);
        varElseRef.setSourceLocation(elseExpr.getSourceLocation());
        arguments.add(new MutableObject((Object)varCondRef3));
        arguments.add(new MutableObject((Object)ConstantExpression.TRUE));
        arguments.add(new MutableObject((Object)varThenRef));
        arguments.add(new MutableObject((Object)varElseRef));
        ScalarFunctionCallExpression swithCaseExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), arguments);
        swithCaseExpr.setSourceLocation(ifexpr.getSourceLocation());
        AssignOperator assignOp = new AssignOperator(selectVar, (Mutable)new MutableObject((Object)swithCaseExpr));
        assignOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)opAndVarForElse.first)));
        assignOp.setSourceLocation(ifexpr.getSourceLocation());
        LogicalVariable unnestVar = this.context.newVar();
        VariableReferenceExpression selectVarRef = new VariableReferenceExpression(selectVar);
        selectVarRef.setSourceLocation(ifexpr.getSourceLocation());
        UnnestingFunctionCallExpression scanCollExpr = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)selectVarRef)));
        scanCollExpr.setSourceLocation(ifexpr.getSourceLocation());
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollExpr));
        unnestOp.getInputs().add(new MutableObject((Object)assignOp));
        unnestOp.setSourceLocation(ifexpr.getSourceLocation());
        LogicalVariable resultVar = this.context.newVar();
        VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
        unnestVarRef.setSourceLocation(ifexpr.getSourceLocation());
        AssignOperator finalAssignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)unnestVarRef));
        finalAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        finalAssignOp.setSourceLocation(ifexpr.getSourceLocation());
        return new Pair((Object)finalAssignOp, (Object)resultVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LiteralExpr l, Mutable<ILogicalOperator> tupSource) {
        SourceLocation sourceLoc = l.getSourceLocation();
        LogicalVariable var = this.context.newVar();
        AsterixConstantValue cValue = new AsterixConstantValue(ConstantHelper.objectFromLiteral(l.getValue()));
        ConstantExpression cExpr = new ConstantExpression((IAlgebricksConstantValue)cValue);
        cExpr.setSourceLocation(sourceLoc);
        AssignOperator a = new AssignOperator(var, (Mutable)new MutableObject((Object)cExpr));
        a.setSourceLocation(sourceLoc);
        if (tupSource != null) {
            a.getInputs().add(tupSource);
        }
        return new Pair((Object)a, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(OperatorExpr op, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        List ops = op.getOpList();
        int nOps = ops.size();
        if (nOps > 0 && (ops.get(0) == OperatorType.AND || ops.get(0) == OperatorType.OR)) {
            return this.visitAndOrOperator(op, tupSource);
        }
        List exprs = op.getExprList();
        Mutable topOp = tupSource;
        SourceLocation sourceLoc = op.getSourceLocation();
        AbstractFunctionCallExpression currExpr = null;
        for (int i = 0; i <= nOps; ++i) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression((Expression)exprs.get(i), topOp);
            topOp = (Mutable)p.second;
            ILogicalExpression e = (ILogicalExpression)p.first;
            if (i < nOps) {
                OperatorType opType = (OperatorType)ops.get(i);
                AbstractFunctionCallExpression f = LangExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(opType, sourceLoc);
                if (i == 0) {
                    f.getArguments().add(new MutableObject((Object)e));
                    currExpr = f;
                    continue;
                }
                currExpr.getArguments().add(new MutableObject((Object)e));
                f.getArguments().add(new MutableObject((Object)currExpr));
                currExpr = f;
                continue;
            }
            currExpr.getArguments().add(new MutableObject((Object)e));
        }
        if (op.hasHints()) {
            currExpr.putAnnotations((Collection)op.getHints());
        }
        LogicalVariable assignedVar = this.context.newVar();
        AssignOperator a = new AssignOperator(assignedVar, (Mutable)new MutableObject(currExpr));
        a.getInputs().add(topOp);
        a.setSourceLocation(sourceLoc);
        return new Pair((Object)a, (Object)assignedVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(OrderbyClause oc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SourceLocation sourceLoc = oc.getSourceLocation();
        OrderOperator ord = new OrderOperator();
        ord.setSourceLocation(sourceLoc);
        List orderbyList = oc.getOrderbyList();
        List modifierList = oc.getModifierList();
        List nullModifierList = oc.getNullModifierList();
        Mutable topOp = tupSource;
        int n = orderbyList.size();
        for (int i = 0; i < n; ++i) {
            Expression e = (Expression)orderbyList.get(i);
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(e, topOp);
            ILogicalExpression obyExpr = (ILogicalExpression)p.first;
            OrderbyClause.OrderModifier modifier = (OrderbyClause.OrderModifier)modifierList.get(i);
            OrderbyClause.NullOrderModifier nullModifier = (OrderbyClause.NullOrderModifier)nullModifierList.get(i);
            this.addOrderByExpression(ord.getOrderExpressions(), obyExpr, modifier, nullModifier);
            topOp = (Mutable)p.second;
        }
        ord.getInputs().add(topOp);
        if (oc.getNumTuples() > 0) {
            ord.getAnnotations().put("CARDINALITY", oc.getNumTuples());
        }
        if (oc.getNumFrames() > 0) {
            ord.getAnnotations().put("MAX_NUMBER_FRAMES", oc.getNumFrames());
        }
        if (oc.getRangeMap() != null) {
            boolean ascending = modifierList.get(0) == OrderbyClause.OrderModifier.ASC;
            RangeMapBuilder.verifyRangeOrder((RangeMap)oc.getRangeMap(), (boolean)ascending, (SourceLocation)sourceLoc);
            ord.getAnnotations().put("USE_STATIC_RANGE", oc.getRangeMap());
        }
        return new Pair((Object)ord, null);
    }

    protected void addOrderByExpression(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> outOrderList, ILogicalExpression obyExpr, OrderbyClause.OrderModifier modifier, OrderbyClause.NullOrderModifier nullModifier) {
        OrderOperator.IOrder comp = this.translateOrderModifier(modifier);
        ILogicalExpression nullModifierExpr = this.translateNullOrderModifier(obyExpr, modifier, nullModifier);
        if (nullModifierExpr != null) {
            outOrderList.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair((Object)comp, (Object)new MutableObject((Object)nullModifierExpr)));
        }
        outOrderList.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair((Object)comp, (Object)new MutableObject((Object)obyExpr)));
    }

    protected OrderOperator.IOrder translateOrderModifier(OrderbyClause.OrderModifier m) {
        return m == OrderbyClause.OrderModifier.ASC ? OrderOperator.ASC_ORDER : OrderOperator.DESC_ORDER;
    }

    protected ILogicalExpression translateNullOrderModifier(ILogicalExpression obyExpr, OrderbyClause.OrderModifier m, OrderbyClause.NullOrderModifier nm) {
        if (m == OrderbyClause.OrderModifier.ASC && nm == OrderbyClause.NullOrderModifier.LAST || m == OrderbyClause.OrderModifier.DESC && nm == OrderbyClause.NullOrderModifier.FIRST) {
            AbstractFunctionCallExpression isUnknownExpr = LangExpressionToPlanTranslator.createFunctionCallExpression(BuiltinFunctions.IS_UNKNOWN, obyExpr.getSourceLocation());
            isUnknownExpr.getArguments().add(new MutableObject((Object)obyExpr.cloneExpression()));
            return isUnknownExpr;
        }
        return null;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject topOp;
        SubplanOperator subplanOp;
        SourceLocation sourceLoc = qe.getSourceLocation();
        if (qe.getQuantifier() == QuantifiedExpression.Quantifier.SOME_AND_EVERY) {
            subplanOp = new SubplanOperator();
            subplanOp.getInputs().add(tupSource);
            subplanOp.setSourceLocation(sourceLoc);
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp));
            ntsOp.setSourceLocation(sourceLoc);
            topOp = new MutableObject((Object)ntsOp);
        } else {
            subplanOp = null;
            topOp = tupSource;
        }
        UnnestOperator firstOp = null;
        MutableObject lastOp = null;
        for (QuantifiedPair qt : qe.getQuantifiedList()) {
            Expression expr = qt.getExpr();
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(expr, (Mutable<ILogicalOperator>)topOp);
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> pUnnestExpr = this.makeUnnestExpression((ILogicalExpression)eo1.first, (Mutable<ILogicalOperator>)((Mutable)eo1.second));
            topOp = (Mutable)pUnnestExpr.second;
            LogicalVariable uVar = this.context.newVarFromExpression((Expression)qt.getVarExpr());
            UnnestOperator u = new UnnestOperator(uVar, (Mutable)new MutableObject((Object)((ILogicalExpression)pUnnestExpr.first)));
            u.setSourceLocation(expr.getSourceLocation());
            if (firstOp == null) {
                firstOp = u;
            }
            if (lastOp != null) {
                u.getInputs().add(lastOp);
            }
            lastOp = new MutableObject((Object)u);
        }
        firstOp.getInputs().add(topOp);
        topOp = lastOp;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo2 = this.langExprToAlgExpression(qe.getSatisfiesExpr(), (Mutable<ILogicalOperator>)topOp);
        switch (qe.getQuantifier()) {
            case SOME: {
                SelectOperator s = new SelectOperator((Mutable)new MutableObject((Object)((ILogicalExpression)eo2.first)));
                s.getInputs().add((Mutable)eo2.second);
                s.setSourceLocation(sourceLoc);
                AggregateFunctionCallExpression fAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.NON_EMPTY_STREAM, new ArrayList(0));
                fAgg.setSourceLocation(sourceLoc);
                LogicalVariable qeVar = this.context.newVar();
                AggregateOperator a = new AggregateOperator(this.mkSingletonArrayList(qeVar), this.mkSingletonArrayList(new MutableObject((Object)fAgg)));
                a.getInputs().add(new MutableObject((Object)s));
                a.setSourceLocation(sourceLoc);
                return new Pair((Object)a, (Object)qeVar);
            }
            case EVERY: {
                ArrayList<MutableObject> ifMissingOrNullArgs = new ArrayList<MutableObject>(2);
                ifMissingOrNullArgs.add(new MutableObject((Object)((ILogicalExpression)eo2.first)));
                ifMissingOrNullArgs.add(new MutableObject((Object)ConstantExpression.FALSE));
                ArrayList<MutableObject> notArgs = new ArrayList<MutableObject>(1);
                ScalarFunctionCallExpression ifMissinOrNullExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.IF_MISSING_OR_NULL), ifMissingOrNullArgs);
                ifMissinOrNullExpr.setSourceLocation(sourceLoc);
                notArgs.add(new MutableObject((Object)ifMissinOrNullExpr));
                ScalarFunctionCallExpression notExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.NOT), notArgs);
                notExpr.setSourceLocation(sourceLoc);
                SelectOperator s = new SelectOperator((Mutable)new MutableObject((Object)notExpr));
                s.getInputs().add((Mutable)eo2.second);
                s.setSourceLocation(sourceLoc);
                AggregateFunctionCallExpression fAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.EMPTY_STREAM, new ArrayList());
                fAgg.setSourceLocation(sourceLoc);
                LogicalVariable qeVar = this.context.newVar();
                AggregateOperator a = new AggregateOperator(this.mkSingletonArrayList(qeVar), this.mkSingletonArrayList(new MutableObject((Object)fAgg)));
                a.getInputs().add(new MutableObject((Object)s));
                a.setSourceLocation(sourceLoc);
                return new Pair((Object)a, (Object)qeVar);
            }
            case SOME_AND_EVERY: {
                AggregateFunctionCallExpression fAgg1 = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.NON_EMPTY_STREAM, new ArrayList(0));
                fAgg1.setSourceLocation(sourceLoc);
                ArrayList<MutableObject> switchCaseArgs = new ArrayList<MutableObject>(4);
                switchCaseArgs.add(new MutableObject((Object)((ILogicalExpression)eo2.first)));
                switchCaseArgs.add(new MutableObject((Object)ConstantExpression.TRUE));
                switchCaseArgs.add(new MutableObject((Object)ConstantExpression.NULL));
                switchCaseArgs.add(new MutableObject((Object)ConstantExpression.TRUE));
                ScalarFunctionCallExpression switchCaseExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), switchCaseArgs);
                switchCaseExpr.setSourceLocation(sourceLoc);
                AggregateFunctionCallExpression fAgg2 = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.SQL_COUNT, this.mkSingletonArrayList(new MutableObject((Object)switchCaseExpr)));
                fAgg2.setSourceLocation(sourceLoc);
                LogicalVariable qeVar1 = this.context.newVar();
                LogicalVariable qeVar2 = this.context.newVar();
                ArrayList<LogicalVariable> qeVarList = new ArrayList<LogicalVariable>(2);
                ArrayList<MutableObject> fAggList = new ArrayList<MutableObject>(2);
                qeVarList.add(qeVar1);
                qeVarList.add(qeVar2);
                fAggList.add(new MutableObject((Object)fAgg1));
                fAggList.add(new MutableObject((Object)fAgg2));
                AggregateOperator a = new AggregateOperator(qeVarList, fAggList);
                a.getInputs().add((Mutable)eo2.second);
                a.setSourceLocation(sourceLoc);
                subplanOp.setRootOp((Mutable)new MutableObject((Object)a));
                VariableReferenceExpression qeVar1Ref = new VariableReferenceExpression(qeVar1);
                qeVar1Ref.setSourceLocation(sourceLoc);
                VariableReferenceExpression qeVar2Ref = new VariableReferenceExpression(qeVar2);
                qeVar2Ref.setSourceLocation(sourceLoc);
                ScalarFunctionCallExpression qeVar2EqZero = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.EQ), new Mutable[]{new MutableObject((Object)qeVar2Ref), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64(0L))))});
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), new Mutable[]{new MutableObject((Object)qeVar1Ref), new MutableObject((Object)qeVar2EqZero)});
                LogicalVariable qeVar = this.context.newVar();
                AssignOperator assignOp2 = new AssignOperator(qeVar, (Mutable)new MutableObject((Object)andExpr));
                assignOp2.setSourceLocation(sourceLoc);
                assignOp2.getInputs().add(new MutableObject((Object)subplanOp));
                return new Pair((Object)assignOp2, (Object)qeVar);
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{qe.getQuantifier().toString()});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return (Pair)q.getBody().accept((ILangVisitor)this, tupSource);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(RecordConstructor rc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR));
        f.setSourceLocation(rc.getSourceLocation());
        LogicalVariable v1 = this.context.newVar();
        AssignOperator a = new AssignOperator(v1, (Mutable)new MutableObject((Object)f));
        a.setSourceLocation(rc.getSourceLocation());
        Mutable topOp = tupSource;
        for (FieldBinding fb : rc.getFbList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(fb.getLeftExpr(), topOp);
            f.getArguments().add(new MutableObject((Object)((ILogicalExpression)eo1.first)));
            topOp = (Mutable)eo1.second;
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo2 = this.langExprToAlgExpression(fb.getRightExpr(), (Mutable<ILogicalOperator>)topOp);
            f.getArguments().add(new MutableObject((Object)((ILogicalExpression)eo2.first)));
            topOp = (Mutable)eo2.second;
        }
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(ListConstructor lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SourceLocation sourceLoc = lc.getSourceLocation();
        FunctionIdentifier fid = lc.getType() == ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR ? BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR : BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR;
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)fid));
        f.setSourceLocation(sourceLoc);
        LogicalVariable v1 = this.context.newVar();
        AssignOperator a = new AssignOperator(v1, (Mutable)new MutableObject((Object)f));
        a.setSourceLocation(sourceLoc);
        Mutable topOp = tupSource;
        for (Expression expr : lc.getExprList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(expr, topOp);
            f.getArguments().add(new MutableObject((Object)((ILogicalExpression)eo.first)));
            topOp = (Mutable)eo.second;
        }
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnaryExpr u, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        AssignOperator a;
        SourceLocation sourceLoc = u.getSourceLocation();
        Expression expr = u.getExpr();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(expr, tupSource);
        LogicalVariable v1 = this.context.newVar();
        switch (u.getExprType()) {
            case POSITIVE: {
                a = new AssignOperator(v1, (Mutable)new MutableObject((Object)((ILogicalExpression)eo.first)));
                a.setSourceLocation(sourceLoc);
                break;
            }
            case NEGATIVE: {
                ScalarFunctionCallExpression m = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NUMERIC_UNARY_MINUS));
                m.setSourceLocation(sourceLoc);
                m.getArguments().add(new MutableObject((Object)((ILogicalExpression)eo.first)));
                a = new AssignOperator(v1, (Mutable)new MutableObject((Object)m));
                a.setSourceLocation(sourceLoc);
                break;
            }
            case EXISTS: {
                a = this.processExists((ILogicalExpression)eo.first, v1, false, sourceLoc);
                break;
            }
            case NOT_EXISTS: {
                a = this.processExists((ILogicalExpression)eo.first, v1, true, sourceLoc);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unsupported operator: " + u.getExprType()});
            }
        }
        a.getInputs().add((Mutable)eo.second);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(VariableExpr v, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ILogicalExpression oldVRef = this.translateVariableRef(v);
        LogicalVariable var = this.context.newVar();
        AssignOperator a = new AssignOperator(var, (Mutable)new MutableObject((Object)oldVRef));
        a.getInputs().add(tupSource);
        a.setSourceLocation(v.getSourceLocation());
        return new Pair((Object)a, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(WhereClause w, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(w.getWhereExpr(), tupSource);
        SelectOperator s = new SelectOperator((Mutable)new MutableObject((Object)((ILogicalExpression)p.first)));
        s.getInputs().add((Mutable)p.second);
        s.setSourceLocation(w.getSourceLocation());
        return new Pair((Object)s, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LimitClause lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Mutable topOp = tupSource;
        ILogicalExpression maxObjectsExpr = null;
        if (lc.hasLimitExpr()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p1 = this.langExprToAlgExpression(lc.getLimitExpr(), topOp);
            maxObjectsExpr = this.createLimitOffsetValueExpression((ILogicalExpression)p1.first, lc.getLimitExpr().getSourceLocation());
            topOp = (Mutable)p1.second;
        }
        ILogicalExpression offsetExpr = null;
        if (lc.hasOffset()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p2 = this.langExprToAlgExpression(lc.getOffset(), topOp);
            offsetExpr = this.createLimitOffsetValueExpression((ILogicalExpression)p2.first, lc.getOffset().getSourceLocation());
            topOp = (Mutable)p2.second;
        }
        LimitOperator limitOp = new LimitOperator(maxObjectsExpr, offsetExpr);
        limitOp.getInputs().add(topOp);
        limitOp.setSourceLocation(lc.getSourceLocation());
        return new Pair((Object)limitOp, null);
    }

    private ILogicalExpression createLimitOffsetValueExpression(ILogicalExpression inputExpr, SourceLocation sourceLoc) throws CompilationException {
        AInt32 zero = new AInt32(0);
        AbstractFunctionCallExpression valueExpr = LangExpressionToPlanTranslator.createFunctionCallExpression(BuiltinFunctions.TREAT_AS_INTEGER, sourceLoc);
        valueExpr.getArguments().add(new MutableObject((Object)inputExpr));
        AbstractFunctionCallExpression cmpExpr = LangExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(OperatorType.GT, sourceLoc);
        cmpExpr.getArguments().add(new MutableObject((Object)valueExpr));
        cmpExpr.getArguments().add(new MutableObject((Object)this.createConstantExpression((IAObject)zero, sourceLoc)));
        AbstractFunctionCallExpression switchExpr = LangExpressionToPlanTranslator.createFunctionCallExpression(BuiltinFunctions.SWITCH_CASE, sourceLoc);
        switchExpr.getArguments().add(new MutableObject((Object)cmpExpr));
        switchExpr.getArguments().add(new MutableObject((Object)this.createConstantExpression((IAObject)ABoolean.TRUE, sourceLoc)));
        switchExpr.getArguments().add(new MutableObject((Object)valueExpr.cloneExpression()));
        switchExpr.getArguments().add(new MutableObject((Object)this.createConstantExpression((IAObject)zero, sourceLoc)));
        return switchExpr;
    }

    protected static AbstractFunctionCallExpression createFunctionCallExpressionForBuiltinOperator(OperatorType t, SourceLocation sourceLoc) throws CompilationException {
        FunctionIdentifier fid;
        switch (t) {
            case EQ: {
                fid = AlgebricksBuiltinFunctions.EQ;
                break;
            }
            case NEQ: {
                fid = AlgebricksBuiltinFunctions.NEQ;
                break;
            }
            case GT: {
                fid = AlgebricksBuiltinFunctions.GT;
                break;
            }
            case GE: {
                fid = AlgebricksBuiltinFunctions.GE;
                break;
            }
            case LT: {
                fid = AlgebricksBuiltinFunctions.LT;
                break;
            }
            case LE: {
                fid = AlgebricksBuiltinFunctions.LE;
                break;
            }
            case PLUS: {
                fid = AlgebricksBuiltinFunctions.NUMERIC_ADD;
                break;
            }
            case MINUS: {
                fid = BuiltinFunctions.NUMERIC_SUBTRACT;
                break;
            }
            case MUL: {
                fid = BuiltinFunctions.NUMERIC_MULTIPLY;
                break;
            }
            case DIVIDE: {
                fid = BuiltinFunctions.NUMERIC_DIVIDE;
                break;
            }
            case DIV: {
                fid = BuiltinFunctions.NUMERIC_DIV;
                break;
            }
            case MOD: {
                fid = BuiltinFunctions.NUMERIC_MOD;
                break;
            }
            case CARET: {
                fid = BuiltinFunctions.NUMERIC_POWER;
                break;
            }
            case AND: {
                fid = AlgebricksBuiltinFunctions.AND;
                break;
            }
            case OR: {
                fid = AlgebricksBuiltinFunctions.OR;
                break;
            }
            case FUZZY_EQ: {
                fid = BuiltinFunctions.FUZZY_EQ;
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Operator " + t + " is not yet implemented"});
            }
        }
        return LangExpressionToPlanTranslator.createFunctionCallExpression(fid, sourceLoc);
    }

    protected static AbstractFunctionCallExpression createFunctionCallExpression(FunctionIdentifier fid, SourceLocation sourceLoc) {
        ScalarFunctionCallExpression callExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)fid));
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    protected Pair<ILogicalExpression, Mutable<ILogicalOperator>> langExprToAlgExpression(Expression expr, Mutable<ILogicalOperator> topOpRef) throws CompilationException {
        SourceLocation sourceLoc = expr.getSourceLocation();
        switch (expr.getKind()) {
            case VARIABLE_EXPRESSION: {
                VariableExpr varExpr = (VariableExpr)expr;
                ILogicalExpression varRefExpr = this.translateVariableRef(varExpr);
                return new Pair((Object)varRefExpr, topOpRef);
            }
            case LITERAL_EXPRESSION: {
                LiteralExpr val = (LiteralExpr)expr;
                AsterixConstantValue cValue = new AsterixConstantValue(ConstantHelper.objectFromLiteral(val.getValue()));
                ConstantExpression cExpr = new ConstantExpression((IAlgebricksConstantValue)cValue);
                cExpr.setSourceLocation(sourceLoc);
                return new Pair((Object)cExpr, topOpRef);
            }
        }
        if (this.expressionNeedsNoNesting(expr)) {
            Pair p = (Pair)expr.accept((ILangVisitor)this, topOpRef);
            ILogicalExpression exp = (ILogicalExpression)((Mutable)((AssignOperator)p.first).getExpressions().get(0)).getValue();
            return new Pair((Object)exp, (Object)((Mutable)((ILogicalOperator)p.first).getInputs().get(0)));
        }
        MutableObject srcRef = new MutableObject();
        Pair p = (Pair)expr.accept((ILangVisitor)this, (Object)srcRef);
        if (((ILogicalOperator)p.first).getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
            if (topOpRef.getValue() != null) {
                srcRef.setValue((Object)((ILogicalOperator)topOpRef.getValue()));
            } else {
                this.rebindBottomOpRef((ILogicalOperator)p.first, (Mutable<ILogicalOperator>)srcRef, topOpRef);
            }
            MutableObject top2 = new MutableObject((Object)((ILogicalOperator)p.first));
            VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)p.second);
            varRef.setSourceLocation(sourceLoc);
            return new Pair((Object)varRef, (Object)top2);
        }
        SubplanOperator s = new SubplanOperator();
        s.getInputs().add(topOpRef);
        s.setSourceLocation(sourceLoc);
        NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)s));
        ntsOp.setSourceLocation(sourceLoc);
        srcRef.setValue((Object)ntsOp);
        MutableObject planRoot = new MutableObject((Object)((ILogicalOperator)p.first));
        s.setRootOp((Mutable)planRoot);
        VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)p.second);
        varRef.setSourceLocation(sourceLoc);
        return new Pair((Object)varRef, (Object)new MutableObject((Object)s));
    }

    protected Pair<ILogicalOperator, LogicalVariable> aggListifyForSubquery(LogicalVariable var, Mutable<ILogicalOperator> opRef, boolean bProject) {
        AggregateOperator res;
        SourceLocation sourceLoc = ((ILogicalOperator)opRef.getValue()).getSourceLocation();
        AggregateFunctionCallExpression funAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, new ArrayList());
        funAgg.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(var)));
        funAgg.setSourceLocation(sourceLoc);
        LogicalVariable varListified = this.context.newSubplanOutputVar();
        AggregateOperator agg = new AggregateOperator(this.mkSingletonArrayList(varListified), this.mkSingletonArrayList(new MutableObject((Object)funAgg)));
        agg.getInputs().add(opRef);
        agg.setSourceLocation(sourceLoc);
        if (bProject) {
            ProjectOperator pr = new ProjectOperator(varListified);
            pr.getInputs().add(new MutableObject((Object)agg));
            pr.setSourceLocation(sourceLoc);
            res = pr;
        } else {
            res = agg;
        }
        return new Pair((Object)res, (Object)varListified);
    }

    protected Pair<ILogicalOperator, LogicalVariable> visitAndOrOperator(OperatorExpr op, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SourceLocation sourceLoc = op.getSourceLocation();
        List ops = op.getOpList();
        int nOps = ops.size();
        List exprs = op.getExprList();
        Mutable topOp = tupSource;
        OperatorType opLogical = (OperatorType)ops.get(0);
        AbstractFunctionCallExpression f = LangExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(opLogical, sourceLoc);
        for (int i = 0; i <= nOps; ++i) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression((Expression)exprs.get(i), topOp);
            topOp = (Mutable)p.second;
            if (i < nOps && ops.get(i) != opLogical) {
                throw new CompilationException(ErrorCode.COMPILATION_UNEXPECTED_OPERATOR, sourceLoc, new Serializable[]{(Serializable)ops.get(i), opLogical});
            }
            f.getArguments().add(new MutableObject((Object)((ILogicalExpression)p.first)));
        }
        LogicalVariable assignedVar = this.context.newVar();
        AssignOperator a = new AssignOperator(assignedVar, (Mutable)new MutableObject((Object)f));
        a.getInputs().add(topOp);
        a.setSourceLocation(sourceLoc);
        return new Pair((Object)a, (Object)assignedVar);
    }

    protected boolean expressionNeedsNoNesting(Expression expr) throws CompilationException {
        switch (expr.getKind()) {
            case VARIABLE_EXPRESSION: 
            case LITERAL_EXPRESSION: 
            case LIST_CONSTRUCTOR_EXPRESSION: 
            case RECORD_CONSTRUCTOR_EXPRESSION: 
            case CALL_EXPRESSION: 
            case OP_EXPRESSION: 
            case FIELD_ACCESSOR_EXPRESSION: 
            case INDEX_ACCESSOR_EXPRESSION: 
            case UNARY_EXPRESSION: 
            case IF_EXPRESSION: 
            case CASE_EXPRESSION: 
            case WINDOW_EXPRESSION: {
                return true;
            }
            case QUANTIFIED_EXPRESSION: {
                return ((QuantifiedExpression)expr).getQuantifier() == QuantifiedExpression.Quantifier.SOME_AND_EVERY;
            }
        }
        return false;
    }

    protected <T> List<T> mkSingletonArrayList(T item) {
        ArrayList<T> array = new ArrayList<T>(1);
        array.add(item);
        return array;
    }

    protected Pair<ILogicalExpression, Mutable<ILogicalOperator>> makeUnnestExpression(ILogicalExpression expr, Mutable<ILogicalOperator> topOpRef) throws CompilationException {
        SourceLocation sourceLoc = expr.getSourceLocation();
        switch (expr.getExpressionTag()) {
            case CONSTANT: 
            case VARIABLE: {
                UnnestingFunctionCallExpression scanCollExpr1 = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), this.mkSingletonArrayList(new MutableObject((Object)expr)));
                scanCollExpr1.setSourceLocation(sourceLoc);
                return new Pair((Object)scanCollExpr1, topOpRef);
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
                if (fce.getKind() == AbstractFunctionCallExpression.FunctionKind.UNNEST) {
                    return new Pair((Object)expr, topOpRef);
                }
                if (fce.getKind() == AbstractFunctionCallExpression.FunctionKind.SCALAR && this.unnestNeedsAssign(fce)) {
                    LogicalVariable var = this.context.newVar();
                    AssignOperator assignOp = new AssignOperator(var, (Mutable)new MutableObject((Object)expr));
                    assignOp.setSourceLocation(sourceLoc);
                    assignOp.getInputs().add(topOpRef);
                    VariableReferenceExpression varRef = new VariableReferenceExpression(var);
                    varRef.setSourceLocation(sourceLoc);
                    UnnestingFunctionCallExpression scanCollExpr2 = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), this.mkSingletonArrayList(new MutableObject((Object)varRef)));
                    scanCollExpr2.setSourceLocation(sourceLoc);
                    return new Pair((Object)scanCollExpr2, (Object)new MutableObject((Object)assignOp));
                }
                UnnestingFunctionCallExpression scanCollExpr3 = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), this.mkSingletonArrayList(new MutableObject((Object)expr)));
                scanCollExpr3.setSourceLocation(sourceLoc);
                return new Pair((Object)scanCollExpr3, topOpRef);
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[0]);
    }

    private boolean unnestNeedsAssign(AbstractFunctionCallExpression fce) {
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)fce.getFunctionIdentifier()) != null;
    }

    private boolean rebindBottomOpRef(ILogicalOperator currentOp, Mutable<ILogicalOperator> opRef, Mutable<ILogicalOperator> replacementOpRef) {
        int index = 0;
        for (Mutable childRef : currentOp.getInputs()) {
            if (childRef == opRef) {
                currentOp.getInputs().set(index, replacementOpRef);
                return true;
            }
            if (this.rebindBottomOpRef((ILogicalOperator)childRef.getValue(), opRef, replacementOpRef)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected void eliminateSharedOperatorReferenceForPlan(ILogicalPlan plan) throws CompilationException {
        for (Mutable opRef : plan.getRoots()) {
            HashSet<Mutable<ILogicalOperator>> opRefSet = new HashSet<Mutable<ILogicalOperator>>();
            this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)opRef, opRefSet);
        }
    }

    private LinkedHashMap<LogicalVariable, LogicalVariable> eliminateSharedOperatorReference(Mutable<ILogicalOperator> currentOpRef, Set<Mutable<ILogicalOperator>> opRefSet) throws CompilationException {
        try {
            opRefSet.add(currentOpRef);
            AbstractLogicalOperator currentOperator = (AbstractLogicalOperator)currentOpRef.getValue();
            if (currentOperator.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans opWithNestedPlan = (AbstractOperatorWithNestedPlans)currentOperator;
                for (ILogicalPlan plan : opWithNestedPlan.getNestedPlans()) {
                    for (Mutable rootRef : plan.getRoots()) {
                        HashSet<Mutable<ILogicalOperator>> nestedOpRefSet = new HashSet<Mutable<ILogicalOperator>>();
                        this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)rootRef, nestedOpRefSet);
                    }
                }
            }
            int childIndex = 0;
            LinkedHashMap<LogicalVariable, LogicalVariable> varMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
            for (Mutable childRef : currentOperator.getInputs()) {
                if (opRefSet.contains(childRef)) {
                    LogicalOperatorDeepCopyWithNewVariablesVisitor visitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)this.context, null);
                    ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)childRef.getValue()).accept((ILogicalOperatorVisitor)visitor, null);
                    LinkedHashMap cloneVarMap = visitor.getInputToOutputVariableMapping();
                    VariableUtilities.substituteVariables((ILogicalOperator)currentOperator, (Map)cloneVarMap, null);
                    varMap.putAll(cloneVarMap);
                    childRef = new MutableObject((Object)newChild);
                    currentOperator.getInputs().set(childIndex, childRef);
                }
                LinkedHashMap<LogicalVariable, LogicalVariable> childVarMap = this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)childRef, opRefSet);
                VariableUtilities.substituteVariables((ILogicalOperator)currentOperator, childVarMap, null);
                varMap.entrySet().forEach(entry -> {
                    LogicalVariable newVar = (LogicalVariable)childVarMap.get(entry.getValue());
                    if (newVar != null) {
                        entry.setValue(newVar);
                    }
                });
                varMap.putAll(childVarMap);
                ++childIndex;
            }
            HashSet liveVars = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)currentOperator, liveVars);
            varMap.values().retainAll(liveVars);
            return varMap;
        }
        catch (AlgebricksException e) {
            throw new CompilationException((Throwable)e);
        }
    }

    protected Pair<ILogicalOperator, LogicalVariable> constructSubplanOperatorForBranch(ILogicalOperator inputOp, Mutable<ILogicalExpression> selectExpr, Expression branchExpression) throws CompilationException {
        this.context.enterSubplan();
        SourceLocation sourceLoc = inputOp.getSourceLocation();
        SubplanOperator subplanOp = new SubplanOperator();
        subplanOp.getInputs().add(new MutableObject((Object)inputOp));
        subplanOp.setSourceLocation(sourceLoc);
        NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp));
        ntsOp.setSourceLocation(sourceLoc);
        SelectOperator select = new SelectOperator(selectExpr);
        OperatorPropertiesUtil.markMovable((ILogicalOperator)select, (boolean)false);
        select.getInputs().add(new MutableObject((Object)ntsOp));
        select.setSourceLocation(((ILogicalExpression)selectExpr.getValue()).getSourceLocation());
        Pair pBranch = (Pair)branchExpression.accept((ILangVisitor)this, (Object)new MutableObject((Object)select));
        LogicalVariable branchVar = this.context.newVar();
        VariableReferenceExpression pBranchVarRef = new VariableReferenceExpression((LogicalVariable)pBranch.second);
        pBranchVarRef.setSourceLocation(branchExpression.getSourceLocation());
        AggregateFunctionCallExpression listifyExpr = new AggregateFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.LISTIFY), false, Collections.singletonList(new MutableObject((Object)pBranchVarRef)));
        listifyExpr.setSourceLocation(branchExpression.getSourceLocation());
        AggregateOperator aggOp = new AggregateOperator(Collections.singletonList(branchVar), Collections.singletonList(new MutableObject((Object)listifyExpr)));
        aggOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)pBranch.first)));
        aggOp.setSourceLocation(branchExpression.getSourceLocation());
        ALogicalPlanImpl planForBranch = new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
        subplanOp.getNestedPlans().add(planForBranch);
        this.context.exitSubplan();
        return new Pair((Object)subplanOp, (Object)branchVar);
    }

    private AssignOperator processExists(ILogicalExpression inputExpr, LogicalVariable v1, boolean not, SourceLocation sourceLoc) {
        ScalarFunctionCallExpression count = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCALAR_COUNT));
        count.getArguments().add(new MutableObject((Object)inputExpr));
        count.setSourceLocation(sourceLoc);
        ScalarFunctionCallExpression comparison = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)(not ? BuiltinFunctions.EQ : BuiltinFunctions.NEQ)));
        ConstantExpression eZero = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64(0L)));
        eZero.setSourceLocation(sourceLoc);
        comparison.getArguments().add(new MutableObject((Object)count));
        comparison.getArguments().add(new MutableObject((Object)eZero));
        comparison.setSourceLocation(sourceLoc);
        AssignOperator a = new AssignOperator(v1, (Mutable)new MutableObject((Object)comparison));
        a.setSourceLocation(sourceLoc);
        return a;
    }

    protected Mutable<ILogicalExpression> generateNoMatchedPrecedingWhenBranchesFilter(List<ILogicalExpression> inputBooleanExprs, SourceLocation sourceLoc) {
        ArrayList<Mutable<ILogicalExpression>> arguments = new ArrayList<Mutable<ILogicalExpression>>();
        for (ILogicalExpression inputBooleanExpr : inputBooleanExprs) {
            arguments.add(this.generateAndNotIsUnknownWrap(inputBooleanExpr));
        }
        ScalarFunctionCallExpression hasBeenExecutedExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OR), arguments);
        hasBeenExecutedExpr.setSourceLocation(sourceLoc);
        ScalarFunctionCallExpression notExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)hasBeenExecutedExpr))));
        notExpr.setSourceLocation(sourceLoc);
        return new MutableObject((Object)notExpr);
    }

    protected Mutable<ILogicalExpression> generateAndNotIsUnknownWrap(ILogicalExpression logicalExpr) {
        SourceLocation sourceLoc = logicalExpr.getSourceLocation();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)logicalExpr.cloneExpression()));
        ScalarFunctionCallExpression isUnknownExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_UNKNOWN), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)logicalExpr.cloneExpression()))));
        isUnknownExpr.setSourceLocation(sourceLoc);
        ScalarFunctionCallExpression notExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)isUnknownExpr))));
        notExpr.setSourceLocation(sourceLoc);
        arguments.add(new MutableObject((Object)notExpr));
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), arguments);
        andExpr.setSourceLocation(sourceLoc);
        return new MutableObject((Object)andExpr);
    }

    protected Pair<ILogicalOperator, LogicalVariable> translateUnionAllFromInputExprs(List<ILangExpression> inputExprs, Mutable<ILogicalOperator> tupSource, SourceLocation sourceLoc) throws CompilationException {
        ArrayList<MutableObject> inputOpRefsToUnion = new ArrayList<MutableObject>();
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        for (ILangExpression expr : inputExprs) {
            SourceLocation exprSourceLoc = expr.getSourceLocation();
            Pair opAndVar = (Pair)expr.accept((ILangVisitor)this, tupSource);
            LogicalVariable unnestVar = this.context.newVar();
            ArrayList<MutableObject> args = new ArrayList<MutableObject>();
            VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)opAndVar.second);
            varRef.setSourceLocation(exprSourceLoc);
            args.add(new MutableObject((Object)varRef));
            UnnestingFunctionCallExpression scanCollExpr = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), args);
            scanCollExpr.setSourceLocation(exprSourceLoc);
            UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollExpr));
            unnestOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)opAndVar.first)));
            unnestOp.setSourceLocation(exprSourceLoc);
            inputOpRefsToUnion.add(new MutableObject((Object)unnestOp));
            vars.add(unnestVar);
        }
        UnionAllOperator topUnionAllOp = null;
        LogicalVariable topUnionVar = null;
        Iterator inputOpRefIterator = inputOpRefsToUnion.iterator();
        Mutable leftInputBranch = (Mutable)inputOpRefIterator.next();
        Iterator inputVarIterator = vars.iterator();
        LogicalVariable leftInputVar = (LogicalVariable)inputVarIterator.next();
        while (inputOpRefIterator.hasNext()) {
            topUnionVar = this.context.newVar();
            Triple varTriple = new Triple((Object)leftInputVar, (Object)((LogicalVariable)inputVarIterator.next()), (Object)topUnionVar);
            ArrayList<Triple> varTriples = new ArrayList<Triple>();
            varTriples.add(varTriple);
            topUnionAllOp = new UnionAllOperator(varTriples);
            topUnionAllOp.getInputs().add(leftInputBranch);
            topUnionAllOp.getInputs().add((Mutable)inputOpRefIterator.next());
            topUnionAllOp.setSourceLocation(sourceLoc);
            leftInputBranch = new MutableObject((Object)topUnionAllOp);
            leftInputVar = topUnionVar;
        }
        return new Pair(topUnionAllOp, (Object)topUnionVar);
    }

    private ConstantExpression createConstantExpression(IAObject value, SourceLocation sourceLoc) {
        ConstantExpression constExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(value));
        constExpr.setSourceLocation(sourceLoc);
        return constExpr;
    }
}

