/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.INodeResolver;

public class NodeResolver
implements INodeResolver {
    private final Random random = new Random();

    @Override
    public String resolveNode(ICcApplicationContext appCtx, String value, Map<InetAddress, Set<String>> ncMap, Set<String> ncs) throws AsterixException {
        if (ncs.contains(value)) {
            return value;
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new AsterixException(ErrorCode.NODE_RESOLVER_UNABLE_RESOLVE_HOST, (Throwable)e, new Serializable[]{value});
        }
        Set<String> nodeControllers = ncMap.get(ipAddress);
        if (nodeControllers == null || nodeControllers.isEmpty()) {
            throw new AsterixException(ErrorCode.NODE_RESOLVER_NO_NODE_CONTROLLERS, new Serializable[]{value});
        }
        return nodeControllers.toArray(new String[0])[this.random.nextInt(nodeControllers.size())];
    }
}

