/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.msgpack;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.input.stream.StandardUTF8ToModifiedUTF8DataOutput;
import org.apache.asterix.external.input.stream.builders.ListLikeNumericArrayFactory;
import org.apache.asterix.external.input.stream.builders.StandardToModifiedUTF8DataOutputFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.msgpack.core.MessagePack;

public class MessageUnpackerToADM {
    private final IObjectPool<IMutableValueStorage, ATypeTag> abvsBuilderPool = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    private final IObjectPool<StandardUTF8ToModifiedUTF8DataOutput, ATypeTag> utfPool = new ListObjectPool((IObjectFactory)new StandardToModifiedUTF8DataOutputFactory());
    private final IObjectPool<List<Long>, Long> listPool = new ListObjectPool(new ListLikeNumericArrayFactory());

    public void unpack(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        byte tag = -64;
        if (in != null) {
            tag = in.get();
        }
        if (MessagePack.Code.isFixStr((byte)tag)) {
            this.unpackStr(in, out, tag ^ 0xFFFFFFA0, tagged);
        } else if (MessagePack.Code.isFixInt((byte)tag)) {
            if (tagged) {
                out.writeByte(ATypeTag.SERIALIZED_INT8_TYPE_TAG);
            }
            if (MessagePack.Code.isPosFixInt((byte)tag)) {
                out.writeByte(tag);
            } else if (MessagePack.Code.isNegFixInt((byte)tag)) {
                out.writeByte(tag);
            }
        } else if (MessagePack.Code.isFixedArray((byte)tag)) {
            this.unpackArray(in, out, tag ^ 0xFFFFFF90);
        } else if (MessagePack.Code.isFixedMap((byte)tag)) {
            this.unpackMap(in, out, tag ^ 0xFFFFFF80);
        } else {
            switch (tag) {
                case -61: {
                    out.writeByte(ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                    out.writeByte(1);
                    break;
                }
                case -62: {
                    out.writeByte(ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                    out.writeByte(0);
                    break;
                }
                case -64: {
                    out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    break;
                }
                case -52: {
                    MessageUnpackerToADM.unpackUByte(in, out, tagged);
                    break;
                }
                case -51: {
                    MessageUnpackerToADM.unpackUShort(in, out, tagged);
                    break;
                }
                case -50: {
                    MessageUnpackerToADM.unpackUInt(in, out, tagged);
                    break;
                }
                case -49: {
                    MessageUnpackerToADM.unpackULong(in, out, tagged);
                    break;
                }
                case -48: {
                    MessageUnpackerToADM.unpackByte(in, out, tagged);
                    break;
                }
                case -47: {
                    MessageUnpackerToADM.unpackShort(in, out, tagged);
                    break;
                }
                case -46: {
                    MessageUnpackerToADM.unpackInt(in, out, tagged);
                    break;
                }
                case -45: {
                    MessageUnpackerToADM.unpackLong(in, out, tagged);
                    break;
                }
                case -54: {
                    MessageUnpackerToADM.unpackFloat(in, out, tagged);
                    break;
                }
                case -53: {
                    MessageUnpackerToADM.unpackDouble(in, out, tagged);
                    break;
                }
                case -39: {
                    this.unpackStr(in, out, Byte.toUnsignedInt(in.get()), tagged);
                    break;
                }
                case -38: {
                    this.unpackStr(in, out, Short.toUnsignedInt(in.getShort()), tagged);
                    break;
                }
                case -37: {
                    this.unpackStr(in, out, Integer.toUnsignedLong(in.getInt()), tagged);
                    break;
                }
                case -36: {
                    this.unpackArray(in, out, Short.toUnsignedInt(in.getShort()));
                    break;
                }
                case -35: {
                    this.unpackArray(in, out, Integer.toUnsignedLong(in.getInt()));
                    break;
                }
                case -34: {
                    this.unpackMap(in, out, Short.toUnsignedInt(in.getShort()));
                    break;
                }
                case -33: {
                    this.unpackMap(in, out, (int)Integer.toUnsignedLong(in.getInt()));
                    break;
                }
                default: {
                    throw HyracksDataException.create((Throwable)AsterixException.create((ErrorCode)ErrorCode.PARSER_ADM_DATA_PARSER_CAST_ERROR, (Serializable[])new Serializable[]{"msgpack tag " + tag + " ", "to an ADM type"}));
                }
            }
        }
    }

    public static void unpackByte(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT8_TYPE_TAG);
        }
        out.writeByte(in.get());
    }

    public static void unpackShort(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT16_TYPE_TAG);
        }
        out.writeShort(in.getShort());
    }

    public static void unpackInt(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT32_TYPE_TAG);
        }
        out.writeInt(in.getInt());
    }

    public static void unpackLong(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        out.writeLong(in.getLong());
    }

    public static void unpackUByte(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT16_TYPE_TAG);
        }
        out.writeShort((short)(in.get() & 0xFF));
    }

    public static void unpackUShort(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT32_TYPE_TAG);
        }
        out.writeInt(in.getShort() & 0xFFFF);
    }

    public static void unpackUInt(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        out.writeLong((long)in.getInt() & 0xFFFFFFFFL);
    }

    public static void unpackULong(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        long val;
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        if ((val = in.getLong()) < 0L) {
            throw new IllegalArgumentException("Integer overflow");
        }
        out.writeLong(val);
    }

    public static void unpackFloat(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_FLOAT_TYPE_TAG);
        }
        out.writeFloat(in.getFloat());
    }

    public static void unpackDouble(ByteBuffer in, DataOutput out, boolean tagged) throws IOException {
        if (tagged) {
            out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
        out.writeDouble(in.getDouble());
    }

    public void unpackArray(ByteBuffer in, DataOutput out, long uLen) throws IOException {
        int i;
        if (uLen > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array is too long");
        }
        ArrayBackedValueStorage buildBuf = (ArrayBackedValueStorage)this.abvsBuilderPool.allocate((Object)ATypeTag.ARRAY);
        buildBuf.reset();
        DataOutput bufOut = buildBuf.getDataOutput();
        int count = (int)uLen;
        bufOut.writeByte(ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
        bufOut.writeByte(ATypeTag.ANY.serialize());
        int asxLenPos = buildBuf.getLength();
        bufOut.writeInt(-1);
        bufOut.writeInt(count);
        int slotStartOffs = buildBuf.getLength();
        for (i = 0; i < count; ++i) {
            bufOut.writeInt(-559038737);
        }
        for (i = 0; i < count; ++i) {
            IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)(slotStartOffs + i * 4), (int)buildBuf.getLength());
            this.unpack(in, bufOut, true);
        }
        IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)asxLenPos, (int)buildBuf.getLength());
        out.write(buildBuf.getByteArray(), buildBuf.getStartOffset(), buildBuf.getLength());
    }

    public void unpackMap(ByteBuffer in, DataOutput out, int count) throws IOException {
        int i;
        ArrayBackedValueStorage buildBuf = (ArrayBackedValueStorage)this.abvsBuilderPool.allocate((Object)ATypeTag.OBJECT);
        List offsets = (List)this.listPool.allocate((Object)count);
        DataOutput bufOut = buildBuf.getDataOutput();
        bufOut.writeByte(ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
        int totalSizeOffs = buildBuf.getLength();
        bufOut.writeInt(-1);
        bufOut.writeByte(1);
        int openPartOffs = buildBuf.getLength();
        bufOut.writeInt(-1);
        IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)openPartOffs, (int)buildBuf.getLength());
        bufOut.writeInt(count);
        int offsetAryPos = buildBuf.getLength();
        int offsetArySz = count * 2;
        for (i = 0; i < offsetArySz; ++i) {
            bufOut.writeInt(-559038737);
        }
        for (i = 0; i < count; ++i) {
            int offs = buildBuf.getLength();
            this.unpack(in, bufOut, false);
            long hash = UTF8StringUtil.hash((byte[])buildBuf.getByteArray(), (int)offs);
            offsets.set(i, (hash << 32) + (long)offs);
            this.unpack(in, bufOut, true);
        }
        Collections.sort(offsets);
        for (Long l : offsets) {
            IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)offsetAryPos, (int)((int)(l >> 32)));
            IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)(offsetAryPos += 4), (int)((int)(l << 32 >> 32)));
            offsetAryPos += 4;
        }
        IntegerPointable.setInteger((byte[])buildBuf.getByteArray(), (int)totalSizeOffs, (int)buildBuf.getLength());
        out.write(buildBuf.getByteArray(), buildBuf.getStartOffset(), buildBuf.getLength());
    }

    public void unpackStr(ByteBuffer in, DataOutput out, long uLen, boolean tag) throws IOException {
        if (tag) {
            out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (Long.compareUnsigned(uLen, Integer.MAX_VALUE) > 0) {
            throw new UnsupportedOperationException("String is too long");
        }
        int len = (int)uLen;
        StandardUTF8ToModifiedUTF8DataOutput conv = (StandardUTF8ToModifiedUTF8DataOutput)this.utfPool.allocate((Object)ATypeTag.STRING);
        conv.setDataOutput(out);
        conv.write(in.array(), in.arrayOffset() + in.position(), len);
        in.position(in.position() + len);
    }
}

