/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class TimeConverter
extends GenericPrimitiveConverter {
    private final LogicalTypeAnnotation.TimeUnit timeUnit;

    TimeConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context, LogicalTypeAnnotation.TimeUnit timeUnit) {
        super(parent, fieldName, index, context);
        this.timeUnit = timeUnit;
    }

    @Override
    public void addInt(int value) {
        this.addLong(value);
    }

    @Override
    public void addLong(long value) {
        int convertedTime = (int)TimeConverter.getConvertedTime(this.timeUnit, value);
        this.context.serializeTime(convertedTime, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    public static long getConvertedTime(LogicalTypeAnnotation.TimeUnit timeUnit, long value) {
        long convertedTime;
        switch (timeUnit) {
            case MICROS: {
                convertedTime = TimeUnit.MICROSECONDS.toMillis(value);
                break;
            }
            case NANOS: {
                convertedTime = TimeUnit.NANOSECONDS.toMillis(value);
                break;
            }
            default: {
                convertedTime = value;
            }
        }
        return convertedTime;
    }
}

