/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs2.dataflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ConfFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] confBytes;

    public ConfFactory(Job conf) throws HyracksDataException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            conf.getConfiguration().write((DataOutput)dos);
            this.confBytes = bos.toByteArray();
            dos.close();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public Job getConf() throws HyracksDataException {
        try {
            Job conf = new Job();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.confBytes));
            conf.getConfiguration().readFields((DataInput)dis);
            dis.close();
            return conf;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

