/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class EstimatedCostComputationVisitor
implements ILogicalOperatorVisitor<Pair<Double, Double>, Double> {
    public Pair<Double, Double> visitAggregateOperator(AggregateOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitRunningAggregateOperator(RunningAggregateOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Double arg) throws AlgebricksException {
        return new Pair((Object)0.0, (Object)0.0);
    }

    public Pair<Double, Double> visitGroupByOperator(GroupByOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitLimitOperator(LimitOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitInnerJoinOperator(InnerJoinOperator op, Double arg) throws AlgebricksException {
        return this.visitInnerJoin(op, arg);
    }

    public Pair<Double, Double> visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Double arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest((ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Double arg) throws AlgebricksException {
        Pair cardCost = EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
        return ((ILogicalOperator)op.getDataSourceReference().getValue()).getOperatorTag() == LogicalOperatorTag.SUBPLAN ? cardCost : new Pair((Object)0.0, (Object)0.0);
    }

    public Pair<Double, Double> visitOrderOperator(OrderOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitAssignOperator(AssignOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitWindowOperator(WindowOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitSelectOperator(SelectOperator op, Double arg) throws AlgebricksException {
        Pair cardCost = (Pair)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, (Object)arg);
        for (Map.Entry anno : op.getAnnotations().entrySet()) {
            if (anno.getValue() != null && ((String)anno.getKey()).equals("OUTPUT_CARDINALITY")) {
                cardCost.setFirst((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() == null || !((String)anno.getKey()).equals("TOTAL_COST")) continue;
            cardCost.setSecond((Object)((Double)anno.getValue()));
        }
        return cardCost;
    }

    public Pair<Double, Double> visitDelegateOperator(DelegateOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitProjectOperator(ProjectOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitReplicateOperator(ReplicateOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitSplitOperator(SplitOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitSwitchOperator(SwitchOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitMaterializeOperator(MaterializeOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitScriptOperator(ScriptOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitSubplanOperator(SubplanOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitSinkOperator(SinkOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitUnionOperator(UnionAllOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitUnnestOperator(UnnestOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Double arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest((ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitUnnestMapOperator(UnnestMapOperator op, Double arg) throws AlgebricksException {
        Pair cardCost = new Pair((Object)0.0, (Object)0.0);
        for (Map.Entry anno : op.getAnnotations().entrySet()) {
            if (anno.getValue() != null && ((String)anno.getKey()).equals("OUTPUT_CARDINALITY")) {
                cardCost.setFirst((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() == null || !((String)anno.getKey()).equals("TOTAL_COST")) continue;
            cardCost.setSecond((Object)((Double)anno.getValue()));
        }
        return cardCost;
    }

    public Pair<Double, Double> visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Double arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest((ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitDataScanOperator(DataSourceScanOperator op, Double arg) throws AlgebricksException {
        Pair cardCost = new Pair((Object)0.0, (Object)0.0);
        for (Map.Entry anno : op.getAnnotations().entrySet()) {
            if (anno.getValue() != null && ((String)anno.getKey()).equals("INPUT_CARDINALITY")) {
                cardCost.setFirst((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() == null || !((String)anno.getKey()).equals("TOTAL_COST")) continue;
            cardCost.setSecond((Object)((Double)anno.getValue()));
        }
        return cardCost;
    }

    public Pair<Double, Double> visitDistinctOperator(DistinctOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitExchangeOperator(ExchangeOperator op, Double arg) throws AlgebricksException {
        double exchCost = 0.0;
        if (arg != null) {
            exchCost = arg;
        }
        Pair cardCost = (Pair)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, (Object)arg);
        if (exchCost != 0.0) {
            op.getAnnotations().put("OP_COST", exchCost);
            op.getAnnotations().put("TOTAL_COST", exchCost + (Double)cardCost.getSecond());
        } else {
            op.getAnnotations().put("OP_COST", 0.0);
            op.getAnnotations().put("TOTAL_COST", cardCost.getSecond());
        }
        op.getAnnotations().put("OUTPUT_CARDINALITY", cardCost.getFirst());
        return cardCost;
    }

    public Pair<Double, Double> visitWriteOperator(WriteOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitDistributeResultOperator(DistributeResultOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitWriteResultOperator(WriteResultOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitTokenizeOperator(TokenizeOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitForwardOperator(ForwardOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    public Pair<Double, Double> visitIntersectOperator(IntersectOperator op, Double arg) throws AlgebricksException {
        return EstimatedCostComputationVisitor.annotate(this, (ILogicalOperator)op, arg);
    }

    private static Pair<Double, Double> annotate(EstimatedCostComputationVisitor visitor, ILogicalOperator op, Double arg) throws AlgebricksException {
        if (op.getInputs().isEmpty()) {
            return new Pair((Object)0.0, (Object)0.0);
        }
        Pair cardCost = (Pair)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)visitor, (Object)arg);
        op.getAnnotations().put("OUTPUT_CARDINALITY", cardCost.getFirst());
        op.getAnnotations().put("TOTAL_COST", cardCost.getSecond());
        op.getAnnotations().put("OP_COST", 0.0);
        return cardCost;
    }

    private Pair<Double, Double> visitLeftOuterUnnest(ILogicalOperator operator, Double arg) throws AlgebricksException {
        return (Pair)((ILogicalOperator)((Mutable)operator.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, (Object)arg);
    }

    private Pair<Double, Double> visitInnerJoin(InnerJoinOperator joinOperator, Double arg) throws AlgebricksException {
        Pair cardCost = new Pair((Object)0.0, (Object)0.0);
        ILogicalOperator left = (ILogicalOperator)((Mutable)joinOperator.getInputs().get(0)).getValue();
        ILogicalOperator right = (ILogicalOperator)((Mutable)joinOperator.getInputs().get(1)).getValue();
        double leftExchangeCost = 0.0;
        double rightExchangeCost = 0.0;
        for (Map.Entry anno : joinOperator.getAnnotations().entrySet()) {
            if (anno.getValue() != null && ((String)anno.getKey()).equals("OUTPUT_CARDINALITY")) {
                cardCost.setFirst((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() != null && ((String)anno.getKey()).equals("TOTAL_COST")) {
                cardCost.setSecond((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() != null && ((String)anno.getKey()).equals("LEFT_EXCHANGE_COST")) {
                leftExchangeCost = (Double)anno.getValue();
                continue;
            }
            if (anno.getValue() == null || !((String)anno.getKey()).equals("RIGHT_EXCHANGE_COST")) continue;
            rightExchangeCost = (Double)anno.getValue();
        }
        left.accept((ILogicalOperatorVisitor)this, (Object)leftExchangeCost);
        right.accept((ILogicalOperatorVisitor)this, (Object)rightExchangeCost);
        return cardCost;
    }
}

