/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class OperatorStats
implements IOperatorStats {
    private static final long serialVersionUID = 6401830963361567126L;
    public final String operatorName;
    public final String operatorId;
    public final ICounter tupleCounter;
    public final ICounter timeCounter;
    public final ICounter pageReads;
    public final ICounter coldReadCounter;
    public final ICounter avgTupleSz;
    public final ICounter minTupleSz;
    public final ICounter maxTupleSz;
    public final ICounter inputTupleCounter;
    public final ICounter level;
    public final ICounter bytesRead;
    public final ICounter bytesWritten;
    private final Map<String, IndexStats> indexesStats;

    public OperatorStats(String operatorName, String operatorId) {
        if (operatorName == null || operatorName.isEmpty()) {
            throw new IllegalArgumentException("operatorName must not be null or empty");
        }
        this.operatorName = operatorName;
        this.operatorId = operatorId;
        this.tupleCounter = new Counter("tupleCounter");
        this.timeCounter = new Counter("timeCounter");
        this.pageReads = new Counter("diskIoCounter");
        this.coldReadCounter = new Counter("coldReadCounter");
        this.avgTupleSz = new Counter("avgTupleSz");
        this.minTupleSz = new Counter("minTupleSz");
        this.maxTupleSz = new Counter("maxTupleSz");
        this.inputTupleCounter = new Counter("inputTupleCounter");
        this.level = new Counter("level");
        this.bytesRead = new Counter("bytesRead");
        this.bytesWritten = new Counter("bytesWritten");
        this.level.set(-1L);
        this.indexesStats = new HashMap<String, IndexStats>();
    }

    @Override
    public String getName() {
        return this.operatorName;
    }

    @Override
    public ICounter getTupleCounter() {
        return this.tupleCounter;
    }

    @Override
    public ICounter getTimeCounter() {
        return this.timeCounter;
    }

    @Override
    public ICounter getPageReads() {
        return this.pageReads;
    }

    @Override
    public ICounter coldReadCounter() {
        return this.coldReadCounter;
    }

    @Override
    public ICounter getAverageTupleSz() {
        return this.avgTupleSz;
    }

    @Override
    public ICounter getMaxTupleSz() {
        return this.maxTupleSz;
    }

    @Override
    public ICounter getMinTupleSz() {
        return this.minTupleSz;
    }

    @Override
    public ICounter getInputTupleCounter() {
        return this.inputTupleCounter;
    }

    @Override
    public ICounter getLevel() {
        return this.level;
    }

    @Override
    public ICounter getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public ICounter getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public String getOperatorId() {
        return this.operatorId;
    }

    @Override
    public void updateIndexesStats(Map<String, IndexStats> stats) {
        if (stats == null) {
            return;
        }
        for (Map.Entry<String, IndexStats> stat : stats.entrySet()) {
            String indexName = stat.getKey();
            IndexStats indexStat = stat.getValue();
            IndexStats existingIndexStat = this.indexesStats.get(indexName);
            if (existingIndexStat == null) {
                this.indexesStats.put(indexName, new IndexStats(indexName, indexStat.getNumPages()));
                continue;
            }
            existingIndexStat.updateNumPages(indexStat.getNumPages());
        }
    }

    @Override
    public Map<String, IndexStats> getIndexesStats() {
        return this.indexesStats;
    }

    @Override
    public void updateFrom(IOperatorStats stats) {
        this.tupleCounter.update(stats.getTupleCounter().get());
        this.timeCounter.update(stats.getTimeCounter().get());
        this.pageReads.update(stats.getPageReads().get());
        this.updateIndexesStats(stats.getIndexesStats());
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.operatorName);
        output.writeUTF(this.operatorId);
        output.writeLong(this.tupleCounter.get());
        output.writeLong(this.timeCounter.get());
        output.writeLong(this.pageReads.get());
        output.writeLong(this.coldReadCounter.get());
        output.writeLong(this.avgTupleSz.get());
        output.writeLong(this.minTupleSz.get());
        output.writeLong(this.maxTupleSz.get());
        output.writeLong(this.inputTupleCounter.get());
        output.writeLong(this.level.get());
        output.writeLong(this.bytesRead.get());
        output.writeLong(this.bytesWritten.get());
        this.writeIndexesStats(output);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.tupleCounter.set(input.readLong());
        this.timeCounter.set(input.readLong());
        this.pageReads.set(input.readLong());
        this.coldReadCounter.set(input.readLong());
        this.avgTupleSz.set(input.readLong());
        this.minTupleSz.set(input.readLong());
        this.maxTupleSz.set(input.readLong());
        this.inputTupleCounter.set(input.readLong());
        this.level.set(input.readLong());
        this.bytesRead.set(input.readLong());
        this.bytesWritten.set(input.readLong());
        this.readIndexesStats(input);
    }

    private void writeIndexesStats(DataOutput output) throws IOException {
        output.writeInt(this.indexesStats.size());
        for (Map.Entry<String, IndexStats> indexStat : this.indexesStats.entrySet()) {
            output.writeUTF(indexStat.getKey());
            indexStat.getValue().writeFields(output);
        }
    }

    private void readIndexesStats(DataInput input) throws IOException {
        int numIndexes = input.readInt();
        for (int i = 0; i < numIndexes; ++i) {
            String indexName = input.readUTF();
            IndexStats indexStats = IndexStats.create(input);
            this.indexesStats.put(indexName, indexStats);
        }
    }

    public String toString() {
        return "{ \"operatorName\": \"" + this.operatorName + "\", \"id\": \"" + this.operatorId + "\", \"" + this.tupleCounter.getName() + "\": " + this.tupleCounter.get() + ", \"" + this.timeCounter.getName() + "\": " + this.timeCounter.get() + ", \"" + this.coldReadCounter.getName() + "\": " + this.coldReadCounter.get() + this.avgTupleSz.getName() + "\": " + this.avgTupleSz.get() + ", \"" + this.minTupleSz.getName() + "\": " + this.minTupleSz.get() + ", \"" + this.minTupleSz.getName() + "\": " + this.timeCounter.get() + ", \"" + this.inputTupleCounter.getName() + "\": " + this.bytesRead.get() + ", \"" + this.bytesRead.getName() + "\": " + this.bytesWritten.get() + ", \"" + this.bytesWritten.getName() + "\": " + this.inputTupleCounter.get() + ", \"" + this.level.getName() + "\": " + this.level.get() + ", \"indexStats\": \"" + this.indexesStats + "\" }";
    }
}

