/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.trace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.util.trace.ITraceCategoryRegistry;

public class TraceCategoryRegistry
implements ITraceCategoryRegistry {
    private final Map<String, Long> categories = Collections.synchronizedMap(new HashMap());
    private final String[] names = new String[64];
    private int bitPos = 0;

    public TraceCategoryRegistry() {
        this.categories.put("*", -1L);
    }

    @Override
    public long get(String name) {
        return this.categories.computeIfAbsent(name, this::nextCode);
    }

    private synchronized long nextCode(String name) {
        if (this.bitPos > 63) {
            throw new IllegalStateException("Cannot add category " + name);
        }
        this.names[this.bitPos] = name;
        return 1L << this.bitPos++;
    }

    @Override
    public String getName(long categoryCode) {
        if (-1L == categoryCode) {
            return "*";
        }
        if (categoryCode == 0L) {
            throw new IllegalArgumentException("Illegal category code " + categoryCode);
        }
        int postition = TraceCategoryRegistry.mostSignificantBit(categoryCode);
        if (postition >= this.bitPos) {
            throw new IllegalArgumentException("No category for code " + categoryCode);
        }
        return this.nameAt(postition);
    }

    public String nameAt(int n) {
        return this.names[n];
    }

    public static int mostSignificantBit(long n) {
        int pos = -1;
        while (n != 0L) {
            ++pos;
            n >>>= 1;
        }
        return pos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < 64; ++pos) {
            long categoryCode = 1L << pos;
            String name = this.nameAt(pos);
            if (name == null) continue;
            String codeString = Long.toBinaryString(categoryCode);
            sb.append(name).append(" -> ").append(codeString).append(' ');
        }
        return sb.toString();
    }
}

