/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.IntValuesDistribution;
import com.teradata.tpcds.distribution.StringValuesDistribution;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.List;

public final class ItemsDistributions {
    public static final IntValuesDistribution ITEM_MANAGER_ID_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("item_manager_id.dst", 3, 4);
    public static final IntValuesDistribution ITEM_MANUFACT_ID_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("item_manufact_id.dst", 3, 4);
    public static final StringValuesDistribution SIZES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("sizes.dst", 1, 3);
    public static final StringValuesDistribution COLORS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("colors.dst", 1, 5);
    public static final StringValuesDistribution UNITS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("units.dst", 1, 1);
    public static final StringValuesDistribution BRAND_SYLLABLES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("brand_syllables.dst", 1, 1);

    private ItemsDistributions() {
    }

    public static List<Integer> pickRandomManagerIdRange(IdWeights idWeights, RandomNumberStream stream) {
        int index = ITEM_MANAGER_ID_DISTRIBUTION.pickRandomIndex(idWeights.ordinal(), stream);
        return ImmutableList.of((Object)ITEM_MANAGER_ID_DISTRIBUTION.getValueAtIndex(1, index), (Object)ITEM_MANAGER_ID_DISTRIBUTION.getValueAtIndex(2, index));
    }

    public static List<Integer> pickRandomManufactIdRange(IdWeights idWeights, RandomNumberStream stream) {
        int index = ITEM_MANUFACT_ID_DISTRIBUTION.pickRandomIndex(idWeights.ordinal(), stream);
        return ImmutableList.of((Object)ITEM_MANUFACT_ID_DISTRIBUTION.getValueAtIndex(1, index), (Object)ITEM_MANUFACT_ID_DISTRIBUTION.getValueAtIndex(2, index));
    }

    public static String pickRandomSize(SizeWeights sizeWeights, RandomNumberStream stream) {
        return SIZES_DISTRIBUTION.pickRandomValue(0, sizeWeights.ordinal(), stream);
    }

    public static String pickRandomColor(ColorsWeights colorsWeights, RandomNumberStream stream) {
        return COLORS_DISTRIBUTION.pickRandomValue(0, colorsWeights.ordinal(), stream);
    }

    public static String pickRandomUnit(RandomNumberStream stream) {
        return UNITS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static enum ColorsWeights {
        UNIFORM,
        SKEWED,
        LOW_LIKELIHOOD,
        MEDIUM_LIKELIHOOD,
        HIGH_LIKELIHOOD;

    }

    public static enum SizeWeights {
        UNIFIED,
        NO_SIZE,
        SIZED;

    }

    public static enum IdWeights {
        UNIFIED,
        LOW,
        MEDIUM,
        HIGH;

    }
}

