/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class WaitForJobCompletionWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final List<String> statOperatorNames;
    private final IResultCallback<Object> callback;

    public WaitForJobCompletionWork(ClusterControllerService ccs, JobId jobId, List<String> statOperatorNames, IResultCallback<Object> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.statOperatorNames = statOperatorNames;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        IJobManager jobManager = this.ccs.getJobManager();
        final JobRun jobRun = jobManager.get(this.jobId);
        if (jobRun != null) {
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName(Thread.currentThread().getName() + " : WaitForCompletionForJobId: " + WaitForJobCompletionWork.this.jobId);
                        jobRun.waitForCompletion();
                        WaitForJobCompletionWork.this.callback.setValue((Object)jobRun.getJobProfile().getAggregatedStats(WaitForJobCompletionWork.this.statOperatorNames));
                    }
                    catch (Exception e) {
                        WaitForJobCompletionWork.this.callback.setException(e);
                    }
                }
            });
        } else {
            List<Exception> exceptionHistory = jobManager.getExceptionHistory(this.jobId);
            List<Throwable> exceptions = exceptionHistory == null ? Collections.singletonList(HyracksDataException.create((ErrorCode)ErrorCode.JOB_HAS_BEEN_CLEARED_FROM_HISTORY, (Serializable[])new Serializable[]{this.jobId})) : exceptionHistory;
            this.ccs.getExecutor().execute(() -> {
                if (!exceptions.isEmpty()) {
                    this.callback.setException((Exception)exceptions.get(0));
                } else {
                    this.callback.setValue(null);
                }
            });
        }
    }

    public String toString() {
        return this.getName() + " jobId:" + this.jobId;
    }
}

