/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.deployment.DeploymentRun;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class CliUnDeployBinaryWork
extends SynchronizableWork {
    private ClusterControllerService ccs;
    private DeploymentId deploymentId;
    private IPCResponder<DeploymentId> callback;

    public CliUnDeployBinaryWork(ClusterControllerService ncs, DeploymentId deploymentId, IPCResponder<DeploymentId> callback) {
        this.ccs = ncs;
        this.deploymentId = deploymentId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.deploymentId == null) {
                this.deploymentId = new DeploymentId(UUID.randomUUID().toString());
            }
            DeploymentUtils.undeploy((DeploymentId)this.deploymentId, (ConcurrentMap)this.ccs.getContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ccs.getServerContext());
            INodeManager nodeManager = this.ccs.getNodeManager();
            Collection<String> nodeIds = nodeManager.getAllNodeIds();
            final DeploymentRun dRun = new DeploymentRun(nodeIds);
            this.ccs.addDeploymentRun(this.deploymentId, dRun);
            for (NodeControllerState ncs : nodeManager.getAllNodeControllerStates()) {
                ncs.getNodeController().undeployBinary(this.deploymentId);
            }
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        dRun.waitForCompletion();
                        CliUnDeployBinaryWork.this.ccs.removeDeploymentRun(CliUnDeployBinaryWork.this.deploymentId);
                        CliUnDeployBinaryWork.this.callback.setValue(null);
                    }
                    catch (Exception e) {
                        CliUnDeployBinaryWork.this.callback.setException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

