/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixTypeToParquetTypeVisitor;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.BinaryConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.DateConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.DecimalConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.JsonStringConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.MissingConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.TimeConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.TimestampConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.UUIDConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.UnsignedIntegerConverter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class PrimitiveConverterProvider {
    public static final PrimitiveType MISSING = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("MISSING");

    private PrimitiveConverterProvider() {
    }

    public static PrimitiveConverter createPrimitiveConverter(PrimitiveType type, AbstractComplexConverter parent, int index, ParquetConverterContext context) {
        return PrimitiveConverterProvider.createPrimitiveConverter(type, parent, null, index, context);
    }

    public static PrimitiveConverter createPrimitiveConverter(PrimitiveType type, AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context) {
        if (type == MISSING) {
            return MissingConverter.INSTANCE;
        }
        ATypeTag mappedType = AsterixTypeToParquetTypeVisitor.mapType((Type)type, context, null);
        switch (mappedType) {
            case BOOLEAN: 
            case STRING: {
                return new GenericPrimitiveConverter(parent, fieldName, index, context);
            }
            case BIGINT: {
                return PrimitiveConverterProvider.getIntConverter(type, parent, fieldName, index, context);
            }
            case DOUBLE: {
                return PrimitiveConverterProvider.getDoubleConverter(type, parent, fieldName, index, context);
            }
            case BINARY: {
                return new BinaryConverter(parent, fieldName, index, context);
            }
            case UUID: {
                return new UUIDConverter(parent, fieldName, index, context);
            }
            case DATE: {
                return new DateConverter(parent, fieldName, index, context);
            }
            case TIME: {
                return PrimitiveConverterProvider.getTimeConverter(type, parent, fieldName, index, context);
            }
            case DATETIME: {
                return PrimitiveConverterProvider.getTimeStampConverter(type, parent, fieldName, index, context);
            }
            case ANY: {
                return new JsonStringConverter(parent, fieldName, index, context);
            }
        }
        return MissingConverter.INSTANCE;
    }

    private static PrimitiveConverter getIntConverter(PrimitiveType type, AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context) {
        LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        if (intType != null && !intType.isSigned()) {
            return new UnsignedIntegerConverter(parent, fieldName, index, context);
        }
        return new GenericPrimitiveConverter(parent, fieldName, index, context);
    }

    private static PrimitiveConverter getDoubleConverter(PrimitiveType type, AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context) {
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
            return new DecimalConverter(parent, fieldName, index, context, decimalLogicalType.getPrecision(), decimalLogicalType.getScale());
        }
        return new GenericPrimitiveConverter(parent, fieldName, index, context);
    }

    private static PrimitiveConverter getTimeConverter(PrimitiveType type, AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context) {
        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        return new TimeConverter(parent, fieldName, index, context, timeLogicalType.getUnit());
    }

    private static PrimitiveConverter getTimeStampConverter(PrimitiveType type, AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation tsType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        if (tsType != null) {
            int offset = tsType.isAdjustedToUTC() ? context.getTimeZoneOffset() : 0;
            return new TimestampConverter(parent, fieldName, index, context, tsType.getUnit(), offset);
        }
        return new TimestampConverter(parent, fieldName, index, context, LogicalTypeAnnotation.TimeUnit.MILLIS, 0);
    }
}

