/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.file.AbstractDeserializedFileScanOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IRecordReader;

public class RecordFileScanOperatorDescriptor
extends AbstractDeserializedFileScanOperatorDescriptor {
    private static final long serialVersionUID = 1L;

    public RecordFileScanOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, RecordDescriptor recordDescriptor) {
        super(spec, splits, recordDescriptor);
    }

    @Override
    protected IRecordReader createRecordReader(File file, RecordDescriptor desc) throws Exception {
        return new RecordReaderImpl(file, desc);
    }

    @Override
    protected void configure() throws Exception {
    }

    private static class RecordReaderImpl
    implements IRecordReader {
        private RecordDescriptor recordDesc;
        private DataInputStream in;

        RecordReaderImpl(File file, RecordDescriptor recordDesc) throws Exception {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.recordDesc = recordDesc;
        }

        @Override
        public boolean read(Object[] record) throws Exception {
            this.in.mark(1);
            if (this.in.read() < 0) {
                return false;
            }
            this.in.reset();
            for (int i = 0; i < record.length; ++i) {
                record[i] = this.recordDesc.getFields()[i].deserialize((DataInput)this.in);
            }
            return true;
        }

        @Override
        public void close() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

