/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.AbstractGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;

public class LocalGroupingProperty
extends AbstractGroupingProperty
implements ILocalStructuralProperty {
    private final List<LogicalVariable> preferredOrderEnforcer = new ArrayList<LogicalVariable>();

    public LocalGroupingProperty(Set<LogicalVariable> columnSet) {
        super(columnSet);
    }

    public LocalGroupingProperty(Set<LogicalVariable> columnSet, List<LogicalVariable> preferredOrderEnforcer) {
        this(columnSet);
        if (preferredOrderEnforcer != null) {
            this.preferredOrderEnforcer.addAll(preferredOrderEnforcer);
        }
    }

    @Override
    public ILocalStructuralProperty.PropertyType getPropertyType() {
        return ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY;
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        columns.addAll(this.columnSet);
    }

    public String toString() {
        return this.columnSet.toString();
    }

    @Override
    public void getVariables(Collection<LogicalVariable> variables) {
        variables.addAll(this.columnSet);
    }

    public List<LogicalVariable> getPreferredOrderEnforcer() {
        return this.preferredOrderEnforcer;
    }

    @Override
    public ILocalStructuralProperty retainVariables(Collection<LogicalVariable> vars) {
        LogicalVariable v;
        ListSet newVars = new ListSet();
        newVars.addAll(vars);
        newVars.retainAll(this.columnSet);
        if (this.columnSet.equals(newVars)) {
            return new LocalGroupingProperty(this.columnSet, this.preferredOrderEnforcer);
        }
        ListSet newColumns = new ListSet();
        Iterator iterator = this.columnSet.iterator();
        while (iterator.hasNext() && newVars.contains(v = (LogicalVariable)iterator.next())) {
            newColumns.add(v);
        }
        return this.createNewLocalGroupingProperty((Set<LogicalVariable>)newColumns);
    }

    @Override
    public ILocalStructuralProperty regardToGroup(Collection<LogicalVariable> groupKeys) {
        ListSet newColumns = new ListSet();
        for (LogicalVariable v : this.columnSet) {
            if (groupKeys.contains(v)) continue;
            newColumns.add(v);
        }
        return this.createNewLocalGroupingProperty((Set<LogicalVariable>)newColumns);
    }

    @Override
    public ILocalStructuralProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        Set<LogicalVariable> normalizedColumnSet = this.normalizeAndReduceGroupingColumns(this.columnSet, equivalenceClasses, fds);
        return new LocalGroupingProperty(normalizedColumnSet, this.preferredOrderEnforcer);
    }

    private LocalGroupingProperty createNewLocalGroupingProperty(Set<LogicalVariable> newColumns) {
        if (newColumns.isEmpty()) {
            return null;
        }
        int numColumns = newColumns.size();
        List<LogicalVariable> newOrderEnforcer = this.preferredOrderEnforcer.size() > numColumns ? this.preferredOrderEnforcer.subList(0, numColumns) : this.preferredOrderEnforcer;
        return new LocalGroupingProperty(newColumns, newOrderEnforcer);
    }
}

