/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ISecondaryIndexOperationsHelper;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryTreeIndexOperationsHelper;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.aggregates.collections.FirstElementEvalFactory;
import org.apache.asterix.runtime.evaluators.comparisons.GreaterThanDescriptor;
import org.apache.asterix.runtime.operators.DatasetStreamStatsOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.runningaggregates.std.SampleSlotRunningAggregateFunctionFactory;
import org.apache.asterix.runtime.runningaggregates.std.TidRunningAggregateDescriptor;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.SimpleAlgebricksAccumulatingAggregatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggrun.RunningAggregateRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamProjectRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamSelectRuntimeFactory;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.sort.SortGroupByOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.build.IndexBuilderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexCreateOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public class SampleOperationsHelper
implements ISecondaryIndexOperationsHelper {
    public static final String DATASET_STATS_OPERATOR_NAME = "Sample.DatasetStats";
    private final MetadataProvider metadataProvider;
    private final Dataset dataset;
    private final Index index;
    private final SourceLocation sourceLoc;
    private ARecordType itemType;
    private ARecordType metaType;
    private RecordDescriptor recordDesc;
    private IBinaryComparatorFactory[] comparatorFactories;
    private IFileSplitProvider fileSplitProvider;
    private AlgebricksPartitionConstraint partitionConstraint;
    private ILSMMergePolicyFactory mergePolicyFactory;
    private Map<String, String> mergePolicyProperties;
    private int groupbyNumFrames;

    protected SampleOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) {
        this.dataset = dataset;
        this.index = index;
        this.metadataProvider = metadataProvider;
        this.sourceLoc = sourceLoc;
    }

    @Override
    public void init() throws AlgebricksException {
        this.itemType = (ARecordType)this.metadataProvider.findType(this.dataset.getItemTypeDataverseName(), this.dataset.getItemTypeName());
        this.metaType = DatasetUtil.getMetaType(this.metadataProvider, this.dataset);
        this.recordDesc = this.dataset.getPrimaryRecordDescriptor(this.metadataProvider);
        this.comparatorFactories = this.dataset.getPrimaryComparatorFactories(this.metadataProvider, this.itemType, this.metaType);
        this.groupbyNumFrames = SampleOperationsHelper.getGroupByNumFrames(this.metadataProvider, this.sourceLoc);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> secondarySplitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset, this.index.getIndexName());
        this.fileSplitProvider = (IFileSplitProvider)secondarySplitsAndConstraint.first;
        this.partitionConstraint = (AlgebricksPartitionConstraint)secondarySplitsAndConstraint.second;
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this.dataset, this.metadataProvider.getMetadataTxnContext());
        this.mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        this.mergePolicyProperties = (Map)compactionInfo.second;
    }

    @Override
    public JobSpecification buildCreationJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        IResourceFactory resourceFactory = this.dataset.getResourceFactory(this.metadataProvider, this.index, this.itemType, this.metaType, this.mergePolicyFactory, this.mergePolicyProperties);
        IndexBuilderFactory indexBuilderFactory = new IndexBuilderFactory(storageComponentProvider.getStorageManager(), this.fileSplitProvider, resourceFactory, true);
        IndexCreateOperatorDescriptor indexCreateOp = new IndexCreateOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexBuilderFactory)indexBuilderFactory);
        indexCreateOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)indexCreateOp, (AlgebricksPartitionConstraint)this.partitionConstraint);
        spec.addRoot((IOperatorDescriptor)indexCreateOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        Index.SampleIndexDetails indexDetails = (Index.SampleIndexDetails)this.index.getIndexDetails();
        int sampleCardinalityTarget = indexDetails.getSampleCardinalityTarget();
        long sampleSeed = indexDetails.getSampleSeed();
        IDataFormat format = this.metadataProvider.getDataFormat();
        int nFields = this.recordDesc.getFieldCount();
        int[] columns = new int[nFields];
        for (int i = 0; i < nFields; ++i) {
            columns[i] = i;
        }
        IStorageManager storageMgr = this.metadataProvider.getStorageComponentProvider().getStorageManager();
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        IndexDataflowHelperFactory dataflowHelperFactory = new IndexDataflowHelperFactory(storageMgr, this.fileSplitProvider);
        IndexUtil.bindJobEventListener(spec, this.metadataProvider);
        IOperatorDescriptor sourceOp = DatasetUtil.createDummyKeyProviderOp(spec, this.dataset, this.metadataProvider);
        IOperatorDescriptor targetOp = DatasetUtil.createPrimaryIndexScanOp(spec, this.metadataProvider, this.dataset);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        List<Pair<IFileSplitProvider, String>> indexesInfo = this.metadataProvider.getSplitProviderOfAllIndexes(this.dataset);
        IndexDataflowHelperFactory[] indexes = new IndexDataflowHelperFactory[indexesInfo.size()];
        String[] names = new String[indexesInfo.size()];
        for (int i = 0; i < indexes.length; ++i) {
            Pair<IFileSplitProvider, String> indexInfo = indexesInfo.get(i);
            indexes[i] = new IndexDataflowHelperFactory(storageMgr, (IFileSplitProvider)indexInfo.first);
            names[i] = (String)indexInfo.second;
        }
        targetOp = new DatasetStreamStatsOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.recordDesc, DATASET_STATS_OPERATOR_NAME, (IIndexDataflowHelperFactory[])indexes, names);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        BuiltinType raggSlotType = BuiltinType.AINT32;
        BuiltinType raggCounterType = BuiltinType.AINT64;
        int[] raggProjectColumns = new int[nFields + 2];
        raggProjectColumns[0] = nFields;
        raggProjectColumns[1] = nFields + 1;
        System.arraycopy(columns, 0, raggProjectColumns, 2, nFields);
        int[] raggAggColumns = new int[]{nFields, nFields + 1};
        ISerializerDeserializerProvider serdeProvider = format.getSerdeProvider();
        ISerializerDeserializer[] raggSerdes = new ISerializerDeserializer[nFields + 2];
        raggSerdes[0] = serdeProvider.getSerializerDeserializer((Object)raggSlotType);
        raggSerdes[1] = serdeProvider.getSerializerDeserializer((Object)raggCounterType);
        System.arraycopy(this.recordDesc.getFields(), 0, raggSerdes, 2, nFields);
        ITypeTraitProvider typeTraitProvider = format.getTypeTraitProvider();
        ITypeTraits[] raggTraits = new ITypeTraits[nFields + 2];
        raggTraits[0] = typeTraitProvider.getTypeTrait((Object)raggSlotType);
        raggTraits[1] = typeTraitProvider.getTypeTrait((Object)raggCounterType);
        System.arraycopy(this.recordDesc.getTypeTraits(), 0, raggTraits, 2, nFields);
        RecordDescriptor raggRecordDesc = new RecordDescriptor(raggSerdes, raggTraits);
        SampleSlotRunningAggregateFunctionFactory raggSlotEvalFactory = new SampleSlotRunningAggregateFunctionFactory(sampleCardinalityTarget, sampleSeed);
        IRunningAggregateEvaluatorFactory raggCounterEvalFactory = TidRunningAggregateDescriptor.FACTORY.createFunctionDescriptor().createRunningAggregateEvaluatorFactory(new IScalarEvaluatorFactory[0]);
        RunningAggregateRuntimeFactory raggRuntimeFactory = new RunningAggregateRuntimeFactory(raggProjectColumns, raggAggColumns, new IRunningAggregateEvaluatorFactory[]{raggSlotEvalFactory, raggCounterEvalFactory});
        IFunctionDescriptor gtDescriptor = GreaterThanDescriptor.FACTORY.createFunctionDescriptor();
        gtDescriptor.setImmutableStates(new Object[]{raggSlotType, raggSlotType});
        IScalarEvaluatorFactory gtFactory = gtDescriptor.createEvaluatorFactory(new IScalarEvaluatorFactory[]{new ColumnAccessEvalFactory(0), format.getConstantEvalFactory((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0)))});
        StreamSelectRuntimeFactory selectRuntimeFactory = new StreamSelectRuntimeFactory(gtFactory, null, format.getBinaryBooleanInspectorFactory(), false, -1, null);
        targetOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{raggRuntimeFactory, selectRuntimeFactory}, new RecordDescriptor[]{raggRecordDesc, raggRecordDesc});
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        int[] groupFields = new int[]{0};
        int[] sortFields = new int[]{0, 1};
        OrderOperator.IOrder sortSlotOrder = OrderOperator.ASC_ORDER;
        OrderOperator.IOrder sortCounterOrder = OrderOperator.DESC_ORDER;
        IBinaryComparatorFactoryProvider comparatorFactoryProvider = format.getBinaryComparatorFactoryProvider();
        IBinaryComparatorFactory[] raggCmpFactories = new IBinaryComparatorFactory[]{comparatorFactoryProvider.getBinaryComparatorFactory((Object)raggSlotType, sortSlotOrder.getKind() == OrderOperator.IOrder.OrderKind.ASC), comparatorFactoryProvider.getBinaryComparatorFactory((Object)raggCounterType, sortCounterOrder.getKind() == OrderOperator.IOrder.OrderKind.ASC)};
        INormalizedKeyComputerFactoryProvider normKeyProvider = format.getNormalizedKeyComputerFactoryProvider();
        INormalizedKeyComputerFactory[] normKeyFactories = new INormalizedKeyComputerFactory[]{normKeyProvider.getNormalizedKeyComputerFactory((Object)raggSlotType, sortSlotOrder.getKind() == OrderOperator.IOrder.OrderKind.ASC), normKeyProvider.getNormalizedKeyComputerFactory((Object)raggCounterType, sortCounterOrder.getKind() == OrderOperator.IOrder.OrderKind.ASC)};
        IAggregateEvaluatorFactory[] aggFactories = new IAggregateEvaluatorFactory[nFields + 1];
        for (int i = 0; i < aggFactories.length; ++i) {
            aggFactories[i] = new FirstElementEvalFactory(new IScalarEvaluatorFactory[]{new ColumnAccessEvalFactory(1 + i)}, false, this.sourceLoc);
        }
        SimpleAlgebricksAccumulatingAggregatorFactory aggregatorFactory = new SimpleAlgebricksAccumulatingAggregatorFactory(aggFactories, groupFields);
        targetOp = new SortGroupByOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.groupbyNumFrames, sortFields, groupFields, normKeyFactories, raggCmpFactories, (IAggregatorDescriptorFactory)aggregatorFactory, (IAggregatorDescriptorFactory)aggregatorFactory, raggRecordDesc, raggRecordDesc, false);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        int[] projectColumns = new int[nFields];
        for (int i = 0; i < nFields; ++i) {
            projectColumns[i] = 2 + i;
        }
        StreamProjectRuntimeFactory projectRuntimeFactory = new StreamProjectRuntimeFactory(projectColumns);
        targetOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{projectRuntimeFactory}, new RecordDescriptor[]{this.recordDesc});
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        targetOp = this.createTreeIndexBulkLoadOp(spec, columns, (IIndexDataflowHelperFactory)dataflowHelperFactory, 1.0f, sampleCardinalityTarget);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
        sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
        targetOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[]{this.recordDesc});
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        spec.addRoot(targetOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    protected LSMIndexBulkLoadOperatorDescriptor createTreeIndexBulkLoadOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor, long numElementHint) {
        LSMIndexBulkLoadOperatorDescriptor treeIndexBulkLoadOp = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.recordDesc, fieldPermutation, fillFactor, false, numElementHint, true, dataflowHelperFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, this.dataset.getDatasetId(), null);
        treeIndexBulkLoadOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.partitionConstraint);
        return treeIndexBulkLoadOp;
    }

    @Override
    public JobSpecification buildDropJobSpec(Set<IndexDropOperatorDescriptor.DropOption> options) throws AlgebricksException {
        return SecondaryTreeIndexOperationsHelper.buildDropJobSpecImpl(this.dataset, this.index, options, this.metadataProvider, this.sourceLoc);
    }

    @Override
    public JobSpecification buildCompactJobSpec() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFileSplitProvider getSecondaryFileSplitProvider() {
        return this.fileSplitProvider;
    }

    @Override
    public RecordDescriptor getSecondaryRecDesc() {
        return this.recordDesc;
    }

    @Override
    public IBinaryComparatorFactory[] getSecondaryComparatorFactories() {
        return this.comparatorFactories;
    }

    @Override
    public AlgebricksPartitionConstraint getSecondaryPartitionConstraint() {
        return this.partitionConstraint;
    }

    private static int getGroupByNumFrames(MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getGroupByNumFrames((CompilerProperties)metadataProvider.getApplicationContext().getCompilerProperties(), metadataProvider.getConfig(), (SourceLocation)sourceLoc);
    }
}

