/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import reactor.core.publisher.Mono;

public class OnBehalfOfCredential
implements TokenCredential {
    private final IdentityClient identityClient;
    private final ClientLogger logger = new ClientLogger(OnBehalfOfCredential.class);

    OnBehalfOfCredential(String clientId, String tenantId, String clientSecret, String certificatePath, String certificatePassword, IdentityClientOptions identityClientOptions) {
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).certificatePath(certificatePath).certificatePassword(certificatePassword).identityClientOptions(identityClientOptions).build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.deferContextual(ctx -> this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithOBO(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error)));
    }
}

