/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.AbstractCallExpression;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.UnaryExprType;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.util.LangRecordParseUtil;
import org.apache.asterix.lang.common.visitor.GatherFunctionCallsVisitor;
import org.apache.asterix.object.base.AdmArrayNode;
import org.apache.asterix.object.base.AdmBigIntNode;
import org.apache.asterix.object.base.AdmBooleanNode;
import org.apache.asterix.object.base.AdmDoubleNode;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static IAdmNode toNode(Expression expr) throws CompilationException {
        switch (expr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                return ExpressionUtils.toNode((ListConstructor)expr);
            }
            case LITERAL_EXPRESSION: {
                return ExpressionUtils.toNode((LiteralExpr)expr);
            }
            case RECORD_CONSTRUCTOR_EXPRESSION: {
                return ExpressionUtils.toNode((RecordConstructor)expr);
            }
            case UNARY_EXPRESSION: {
                UnaryExpr unaryExpr = (UnaryExpr)expr;
                UnaryExprType unaryExprType = unaryExpr.getExprType();
                if (unaryExprType == UnaryExprType.POSITIVE || unaryExprType == UnaryExprType.NEGATIVE) {
                    Expression uexpr = unaryExpr.getExpr();
                    if (uexpr.getKind() == Expression.Kind.LITERAL_EXPRESSION) {
                        if (unaryExprType == UnaryExprType.POSITIVE) {
                            return ExpressionUtils.toNode(uexpr);
                        }
                        Literal lit = ((LiteralExpr)uexpr).getValue();
                        return ExpressionUtils.toNode(new LiteralExpr(ExpressionUtils.reverseSign(lit)));
                    }
                    throw new CompilationException(ErrorCode.LITERAL_TYPE_NOT_SUPPORTED_IN_CONSTANT_RECORD, new Serializable[]{uexpr.getKind()});
                }
                throw new CompilationException(ErrorCode.EXPRESSION_NOT_SUPPORTED_IN_CONSTANT_RECORD, new Serializable[]{unaryExprType});
            }
        }
        throw new CompilationException(ErrorCode.EXPRESSION_NOT_SUPPORTED_IN_CONSTANT_RECORD, new Serializable[]{expr.getKind()});
    }

    public static AdmObjectNode toNode(RecordConstructor recordConstructor) throws CompilationException {
        AdmObjectNode node = new AdmObjectNode();
        List<FieldBinding> fbList = recordConstructor.getFbList();
        for (int i = 0; i < fbList.size(); ++i) {
            FieldBinding binding = fbList.get(i);
            String key = LangRecordParseUtil.exprToStringLiteral(binding.getLeftExpr()).getStringValue();
            IAdmNode value = ExpressionUtils.toNode(binding.getRightExpr());
            node.set(key, value);
        }
        return node;
    }

    private static IAdmNode toNode(ListConstructor listConstructor) throws CompilationException {
        List<Expression> exprList = listConstructor.getExprList();
        AdmArrayNode array = new AdmArrayNode(exprList.size());
        for (int i = 0; i < exprList.size(); ++i) {
            array.add(ExpressionUtils.toNode(exprList.get(i)));
        }
        return array;
    }

    private static IAdmNode toNode(LiteralExpr literalExpr) throws CompilationException {
        Literal value = literalExpr.getValue();
        Literal.Type literalType = value.getLiteralType();
        switch (literalType) {
            case DOUBLE: {
                return new AdmDoubleNode(((DoubleLiteral)value).getDoubleValue());
            }
            case FALSE: 
            case TRUE: {
                return AdmBooleanNode.get((Boolean)((Boolean)value.getValue()));
            }
            case LONG: {
                return new AdmBigIntNode(((LongIntegerLiteral)value).getLongValue());
            }
            case NULL: {
                return AdmNullNode.INSTANCE;
            }
            case STRING: {
                return new AdmStringNode(((StringLiteral)value).getValue());
            }
        }
        throw new CompilationException(ErrorCode.LITERAL_TYPE_NOT_SUPPORTED_IN_CONSTANT_RECORD, new Serializable[]{literalType});
    }

    public static <T> Collection<T> emptyIfNull(Collection<T> coll) {
        return coll == null ? Collections.emptyList() : coll;
    }

    public static String getStringLiteral(Expression arg) {
        Literal item;
        if (arg.getKind() == Expression.Kind.LITERAL_EXPRESSION && (item = ((LiteralExpr)arg).getValue()).getLiteralType() == Literal.Type.STRING) {
            return item.getStringValue();
        }
        return null;
    }

    public static Boolean getBooleanLiteral(Expression arg) {
        if (arg.getKind() == Expression.Kind.LITERAL_EXPRESSION) {
            Literal item = ((LiteralExpr)arg).getValue();
            switch (item.getLiteralType()) {
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
        }
        return null;
    }

    public static Literal reverseSign(Literal lit) throws TypeMismatchException {
        switch (lit.getLiteralType()) {
            case DOUBLE: {
                DoubleLiteral dLit = (DoubleLiteral)lit;
                DoubleLiteral reversedDLit = new DoubleLiteral(-dLit.getValue().doubleValue());
                return reversedDLit;
            }
            case FLOAT: {
                FloatLiteral fLit = (FloatLiteral)lit;
                FloatLiteral reversedFLit = new FloatLiteral(Float.valueOf(-fLit.getValue().floatValue()));
                return reversedFLit;
            }
            case LONG: {
                LongIntegerLiteral lLit = (LongIntegerLiteral)lit;
                LongIntegerLiteral reversedLLit = new LongIntegerLiteral(-lLit.getValue().longValue());
                return reversedLLit;
            }
            case INTEGER: {
                IntegerLiteral iLit = (IntegerLiteral)lit;
                IntegerLiteral reversedILit = new IntegerLiteral(-iLit.getValue().intValue());
                return reversedILit;
            }
            case NULL: 
            case MISSING: {
                return lit;
            }
        }
        throw new TypeMismatchException(null, ExpressionUtils.convertLiteralTypeTagToATypeTag(lit), new ATypeTag[]{ATypeTag.DOUBLE, ATypeTag.FLOAT, ATypeTag.BIGINT, ATypeTag.INTEGER});
    }

    public static double getDoubleValue(Literal item) throws TypeMismatchException {
        if (item.getLiteralType() == Literal.Type.DOUBLE || item.getLiteralType() == Literal.Type.FLOAT || item.getLiteralType() == Literal.Type.LONG || item.getLiteralType() == Literal.Type.INTEGER) {
            return ((Number)item.getValue()).doubleValue();
        }
        throw new TypeMismatchException(null, ExpressionUtils.convertLiteralTypeTagToATypeTag(item), new ATypeTag[]{ATypeTag.DOUBLE, ATypeTag.FLOAT, ATypeTag.BIGINT, ATypeTag.INTEGER});
    }

    public static long getLongValue(Literal item) throws TypeMismatchException {
        if (item.getLiteralType() == Literal.Type.LONG || item.getLiteralType() == Literal.Type.INTEGER) {
            return ((Number)item.getValue()).longValue();
        }
        throw new TypeMismatchException(null, ExpressionUtils.convertLiteralTypeTagToATypeTag(item), new ATypeTag[]{ATypeTag.BIGINT, ATypeTag.INTEGER});
    }

    private static ATypeTag convertLiteralTypeTagToATypeTag(Literal lit) {
        switch (lit.getLiteralType()) {
            case DOUBLE: {
                return ATypeTag.DOUBLE;
            }
            case FLOAT: {
                return ATypeTag.FLOAT;
            }
            case LONG: {
                return ATypeTag.BIGINT;
            }
            case INTEGER: {
                return ATypeTag.INTEGER;
            }
            case FALSE: 
            case TRUE: {
                return ATypeTag.BOOLEAN;
            }
            case NULL: {
                return ATypeTag.NULL;
            }
            case MISSING: {
                return ATypeTag.MISSING;
            }
        }
        return ATypeTag.STRING;
    }

    public static void collectDependencies(Expression expression, IQueryRewriter rewriter, List<Triple<DataverseName, String, String>> outDatasetDependencies, List<Triple<DataverseName, String, String>> outSynonymDependencies, List<Triple<DataverseName, String, String>> outFunctionDependencies) throws CompilationException {
        HashSet<DatasetFullyQualifiedName> seenDatasets = new HashSet<DatasetFullyQualifiedName>();
        HashSet<DatasetFullyQualifiedName> seenSynonyms = new HashSet<DatasetFullyQualifiedName>();
        HashSet<FunctionSignature> seenFunctions = new HashSet<FunctionSignature>();
        ArrayList functionCalls = new ArrayList();
        rewriter.getFunctionCalls(expression, functionCalls);
        block4: for (AbstractCallExpression functionCall : functionCalls) {
            switch (functionCall.getKind()) {
                case CALL_EXPRESSION: {
                    FunctionSignature signature = functionCall.getFunctionSignature();
                    if (FunctionUtil.isBuiltinFunctionSignature(signature)) {
                        if (!FunctionUtil.isBuiltinDatasetFunction(signature)) continue block4;
                        Triple<DatasetFullyQualifiedName, Boolean, DatasetFullyQualifiedName> dsArgs = FunctionUtil.parseDatasetFunctionArguments(functionCall);
                        DatasetFullyQualifiedName synonymReference = (DatasetFullyQualifiedName)dsArgs.third;
                        if (synonymReference != null) {
                            if (!seenSynonyms.add(synonymReference)) continue block4;
                            outSynonymDependencies.add((Triple<DataverseName, String, String>)new Triple((Object)synonymReference.getDataverseName(), (Object)synonymReference.getDatasetName(), null));
                            break;
                        }
                        DatasetFullyQualifiedName datasetReference = (DatasetFullyQualifiedName)dsArgs.first;
                        if (!seenDatasets.add(datasetReference)) continue block4;
                        outDatasetDependencies.add((Triple<DataverseName, String, String>)new Triple((Object)datasetReference.getDataverseName(), (Object)datasetReference.getDatasetName(), null));
                        break;
                    }
                    if (!seenFunctions.add(signature)) continue block4;
                    outFunctionDependencies.add((Triple<DataverseName, String, String>)new Triple((Object)signature.getDataverseName(), (Object)signature.getName(), (Object)Integer.toString(signature.getArity())));
                    break;
                }
                case WINDOW_EXPRESSION: {
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, functionCall.getSourceLocation(), new Serializable[]{functionCall.getFunctionSignature().toString(false)});
                }
            }
        }
    }

    public static boolean hasFunctionOrViewRecursion(Map<FunctionSignature, FunctionDecl> functionDeclMap, Map<DatasetFullyQualifiedName, ViewDecl> viewDeclMap, Function<Collection<AbstractCallExpression>, GatherFunctionCallsVisitor> callVisitorFactory) throws CompilationException {
        ArrayList callList = new ArrayList();
        GatherFunctionCallsVisitor callVisitor = callVisitorFactory.apply(callList);
        MutableGraph callGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        for (FunctionDecl functionDecl : functionDeclMap.values()) {
            callList.clear();
            functionDecl.getNormalizedFuncBody().accept(callVisitor, null);
            for (AbstractCallExpression callExpr : callList) {
                ExpressionUtils.addToCallGraph((MutableGraph<AbstractStatement>)callGraph, functionDecl, callExpr, functionDeclMap, viewDeclMap);
            }
        }
        for (ViewDecl viewDecl : viewDeclMap.values()) {
            callList.clear();
            viewDecl.getNormalizedViewBody().accept(callVisitor, null);
            for (AbstractCallExpression callExpr : callList) {
                ExpressionUtils.addToCallGraph((MutableGraph<AbstractStatement>)callGraph, viewDecl, callExpr, functionDeclMap, viewDeclMap);
            }
        }
        return Graphs.hasCycle((Graph)callGraph);
    }

    private static void addToCallGraph(MutableGraph<AbstractStatement> callGraph, AbstractStatement from, AbstractCallExpression callExpr, Map<FunctionSignature, FunctionDecl> functionDeclMap, Map<DatasetFullyQualifiedName, ViewDecl> viewDeclMap) throws CompilationException {
        if (callExpr.getKind() == Expression.Kind.CALL_EXPRESSION) {
            FunctionSignature callSignature = callExpr.getFunctionSignature();
            if (FunctionUtil.isBuiltinFunctionSignature(callSignature)) {
                if (FunctionUtil.isBuiltinDatasetFunction(callSignature)) {
                    DatasetFullyQualifiedName viewName;
                    ViewDecl vdTo;
                    Triple<DatasetFullyQualifiedName, Boolean, DatasetFullyQualifiedName> dsArgs = FunctionUtil.parseDatasetFunctionArguments(callExpr);
                    if (Boolean.TRUE.equals(dsArgs.second) && (vdTo = viewDeclMap.get(viewName = (DatasetFullyQualifiedName)dsArgs.first)) != null) {
                        callGraph.putEdge((Object)from, (Object)vdTo);
                    }
                }
            } else {
                FunctionDecl fdTo = functionDeclMap.get(callSignature);
                if (fdTo != null) {
                    callGraph.putEdge((Object)from, (Object)fdTo);
                }
            }
        }
    }

    public static Query createWrappedQuery(Expression expr, SourceLocation sourceLoc) {
        Query wrappedQuery = new Query(false);
        wrappedQuery.setSourceLocation(sourceLoc);
        wrappedQuery.setBody(expr);
        wrappedQuery.setTopLevel(false);
        return wrappedQuery;
    }
}

