/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class OptimizableFuncExpr
implements IOptimizableFuncExpr {
    protected final AbstractFunctionCallExpression funcExpr;
    protected final LogicalVariable[] logicalVars;
    protected final LogicalVariable[] sourceVars;
    protected final int[] logicalVarsExprsIndexes;
    protected final ILogicalExpression[] logicalExprs;
    protected final List<List<AbstractFunctionCallExpression>> stepsExprs;
    protected final List<List<String>> fieldNames;
    protected final int[] fieldSources;
    protected final IAType[] fieldTypes;
    protected final OptimizableOperatorSubTree[] subTrees;
    protected final ILogicalExpression[] constantExpressions;
    protected final IAType[] constantExpressionTypes;
    protected boolean partialField;

    public OptimizableFuncExpr(AbstractFunctionCallExpression funcExpr, LogicalVariable[] logicalVars, int[] logicalVarsExprsIndexes, ILogicalExpression[] constantExpressions, IAType[] constantExpressionTypes) {
        int i;
        this.funcExpr = funcExpr;
        this.logicalVars = logicalVars;
        this.logicalVarsExprsIndexes = logicalVarsExprsIndexes;
        this.sourceVars = new LogicalVariable[logicalVars.length];
        this.logicalExprs = new ILogicalExpression[logicalVars.length];
        this.constantExpressionTypes = constantExpressionTypes;
        this.constantExpressions = constantExpressions;
        this.fieldSources = new int[logicalVars.length];
        this.fieldNames = new ArrayList<List<String>>();
        for (i = 0; i < logicalVars.length; ++i) {
            this.fieldNames.add(new ArrayList());
        }
        this.stepsExprs = new ArrayList<List<AbstractFunctionCallExpression>>();
        for (i = 0; i < logicalVars.length; ++i) {
            this.stepsExprs.add(new ArrayList());
        }
        this.fieldTypes = new IAType[logicalVars.length];
        this.subTrees = new OptimizableOperatorSubTree[logicalVars.length];
        this.partialField = funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS;
    }

    public OptimizableFuncExpr(AbstractFunctionCallExpression funcExpr, LogicalVariable logicalVar, ILogicalExpression constantExpression, IAType constantExpressionType, int varIndexInOptFunExpr) {
        int i;
        this.funcExpr = funcExpr;
        this.logicalVars = new LogicalVariable[]{logicalVar};
        this.sourceVars = new LogicalVariable[1];
        this.logicalExprs = new ILogicalExpression[1];
        this.constantExpressions = new ILogicalExpression[]{constantExpression};
        this.constantExpressionTypes = new IAType[]{constantExpressionType};
        this.fieldSources = new int[this.logicalVars.length];
        this.fieldNames = new ArrayList<List<String>>();
        for (i = 0; i < this.logicalVars.length; ++i) {
            this.fieldNames.add(new ArrayList());
        }
        this.stepsExprs = new ArrayList<List<AbstractFunctionCallExpression>>();
        for (i = 0; i < this.logicalVars.length; ++i) {
            this.stepsExprs.add(new ArrayList());
        }
        this.logicalVarsExprsIndexes = new int[]{varIndexInOptFunExpr};
        this.fieldTypes = new IAType[this.logicalVars.length];
        this.subTrees = new OptimizableOperatorSubTree[this.logicalVars.length];
        this.partialField = funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS;
    }

    @Override
    public AbstractFunctionCallExpression getFuncExpr() {
        return this.funcExpr;
    }

    @Override
    public int getNumLogicalVars() {
        return this.logicalVars.length;
    }

    @Override
    public int getNumConstantExpr() {
        return this.constantExpressions.length;
    }

    @Override
    public LogicalVariable getLogicalVar(int index) {
        return this.logicalVars[index];
    }

    @Override
    public void setLogicalExpr(int index, ILogicalExpression logExpr) {
        this.logicalExprs[index] = logExpr;
    }

    @Override
    public ILogicalExpression getLogicalExpr(int index) {
        return this.logicalExprs[index];
    }

    @Override
    public void setFieldName(int index, List<String> fieldName, int fieldSource) {
        this.fieldNames.set(index, fieldName);
        this.fieldSources[index] = fieldSource;
    }

    @Override
    public List<String> getFieldName(int index) {
        return this.fieldNames.get(index);
    }

    @Override
    public int getFieldSource(int index) {
        return this.fieldSources[index];
    }

    @Override
    public void setFieldType(int index, IAType fieldType) {
        this.fieldTypes[index] = fieldType;
    }

    @Override
    public IAType getFieldType(int index) {
        return this.fieldTypes[index];
    }

    @Override
    public ILogicalExpression getConstantExpr(int index) {
        return this.constantExpressions[index];
    }

    @Override
    public ILogicalExpression[] getConstantExpressions() {
        return this.constantExpressions;
    }

    @Override
    public void addStepExpr(int index, AbstractFunctionCallExpression funcExpr) {
        this.stepsExprs.get(index).add(funcExpr);
    }

    @Override
    public List<AbstractFunctionCallExpression> getStepsExprs(int index) {
        return this.stepsExprs.get(index);
    }

    @Override
    public Mutable<ILogicalExpression> getArgument(int index) {
        return (Mutable)this.funcExpr.getArguments().get(this.logicalVarsExprsIndexes[index]);
    }

    @Override
    public void setConstType(int index, IAType fieldType) {
        this.constantExpressionTypes[index] = fieldType;
    }

    @Override
    public IAType getConstantType(int index) {
        return this.constantExpressionTypes[index];
    }

    @Override
    public void setConstantExpr(int index, ILogicalExpression expr) {
        this.constantExpressions[index] = expr;
    }

    @Override
    public int findLogicalVar(LogicalVariable var) {
        for (int i = 0; i < this.logicalVars.length; ++i) {
            if (var != this.logicalVars[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findFieldName(List<String> fieldName) {
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (!fieldName.equals(this.fieldNames.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setOptimizableSubTree(int index, OptimizableOperatorSubTree subTree) {
        this.subTrees[index] = subTree;
    }

    @Override
    public OptimizableOperatorSubTree getOperatorSubTree(int index) {
        return this.subTrees[index];
    }

    @Override
    public void substituteVar(LogicalVariable original, LogicalVariable substitution) {
        if (this.logicalVars != null) {
            for (int i = 0; i < this.logicalVars.length; ++i) {
                if (this.logicalVars[i] != original) continue;
                this.logicalVars[i] = substitution;
                break;
            }
        }
    }

    @Override
    public void setPartialField(boolean partialField) {
        this.partialField = partialField;
    }

    @Override
    public boolean containsPartialField() {
        return this.partialField;
    }

    public int hashCode() {
        return this.funcExpr.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OptimizableFuncExpr)) {
            return false;
        }
        return this.funcExpr.equals(o);
    }

    @Override
    public void setSourceVar(int index, LogicalVariable var) {
        this.sourceVars[index] = var;
    }

    @Override
    public LogicalVariable getSourceVar(int index) {
        return this.sourceVars[index];
    }
}

